/*
 * Decompiled with CFR 0.152.
 */
package ffx.xray.commands;

import edu.rit.pj.Comm;
import ffx.algorithms.cli.AlgorithmsCommand;
import ffx.algorithms.cli.ManyBodyOptions;
import ffx.algorithms.optimize.RotamerOptimization;
import ffx.algorithms.optimize.TitrationManyBody;
import ffx.numerics.Potential;
import ffx.potential.MolecularAssembly;
import ffx.potential.bonded.Atom;
import ffx.potential.bonded.Residue;
import ffx.potential.bonded.RotamerLibrary;
import ffx.potential.parsers.PDBFilter;
import ffx.utilities.FFXBinding;
import ffx.xray.DiffractionData;
import ffx.xray.RefinementEnergy;
import ffx.xray.cli.XrayOptions;
import ffx.xray.refine.RefinementMode;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.configuration2.CompositeConfiguration;
import picocli.CommandLine;

@CommandLine.Command(description={" Discrete optimization using a many-body expansion and elimination expressions."}, name="xray.ManyBody")
public class ManyBody
extends AlgorithmsCommand {
    @CommandLine.Mixin
    private XrayOptions xrayOptions;
    @CommandLine.Mixin
    private ManyBodyOptions manyBodyOptions;
    @CommandLine.Parameters(arity="1..*", paramLabel="files", description={"PDB and Real Space input files."})
    private List<String> filenames;
    private MolecularAssembly[] molecularAssemblies;
    private DiffractionData diffractionData;
    private double initialTargetEnergy;
    private double finalTargetEnergy;

    public ManyBody() {
    }

    public ManyBody(String[] args) {
        super(args);
    }

    public ManyBody(FFXBinding binding) {
        super(binding);
    }

    public ManyBody run() {
        List residues;
        if (!this.init()) {
            return this;
        }
        this.xrayOptions.init();
        System.setProperty("sor-scf-fallback", "false");
        System.setProperty("direct-scf-fallback", "true");
        double titrationPH = this.manyBodyOptions.getTitrationPH();
        if (titrationPH > 0.0) {
            System.setProperty("manybody-titration", "true");
        }
        String nea = System.getProperty("native-environment-approximation", "true");
        System.setProperty("native-environment-approximation", nea);
        if (this.filenames != null && !this.filenames.isEmpty()) {
            this.molecularAssemblies = this.algorithmFunctions.openAll(this.filenames.getFirst());
            this.activeAssembly = this.molecularAssemblies[0];
        } else {
            if (this.activeAssembly == null) {
                logger.info(this.helpString());
                return this;
            }
            this.molecularAssemblies = new MolecularAssembly[]{this.activeAssembly};
        }
        String filename = this.activeAssembly.getFile().getAbsolutePath();
        CompositeConfiguration properties = this.activeAssembly.getProperties();
        this.activeAssembly.getPotentialEnergy().setPrintOnFailure(false, false);
        if (this.xrayOptions.refinementMode != RefinementMode.COORDINATES) {
            logger.info(" Refinement mode set to COORDINATES.");
            this.xrayOptions.refinementMode = RefinementMode.COORDINATES;
        }
        if ((residues = this.manyBodyOptions.collectResidues(this.activeAssembly)) == null || residues.isEmpty()) {
            logger.info(" There are no residues in the active system to optimize.");
            return this;
        }
        TitrationManyBody titrationManyBody = null;
        if (titrationPH > 0.0) {
            logger.info(String.format("\n Adding titration hydrogen to: %s\n", this.filenames.getFirst()));
            ArrayList<Integer> resNumberList = new ArrayList<Integer>();
            for (Residue residue : residues) {
                resNumberList.add(residue.getResidueNumber());
            }
            titrationManyBody = new TitrationManyBody(this.filenames.getFirst(), this.activeAssembly.getForceField(), resNumberList, titrationPH, this.manyBodyOptions);
            this.molecularAssemblies = titrationManyBody.getProtonatedAssemblies();
            this.activeAssembly = this.molecularAssemblies[0];
        }
        this.xrayOptions.setProperties(this.parseResult, properties);
        this.diffractionData = this.xrayOptions.getDiffractionData(this.filenames, this.molecularAssemblies, properties);
        RefinementEnergy refinementEnergy = this.xrayOptions.toXrayEnergy(this.diffractionData);
        refinementEnergy.setScaling(null);
        boolean isTitrating = false;
        HashSet excludeAtoms = new HashSet();
        for (int i = 0; i < this.molecularAssemblies.length && i <= 0; ++i) {
            this.activeAssembly = this.molecularAssemblies[i];
            this.activeAssembly.setFile(new File(this.filenames.getFirst()));
            Atom[] atoms = this.activeAssembly.getAtomArray();
            double[] bfactors = new double[atoms.length];
            double averageBFactor = 0.0;
            for (int j = 0; j < atoms.length; ++j) {
                double bfactor;
                bfactors[j] = bfactor = atoms[j].getTempFactor();
                averageBFactor += bfactor;
            }
            averageBFactor /= (double)atoms.length;
            for (Atom atom : atoms) {
                atom.setTempFactor(averageBFactor);
            }
            this.diffractionData.scaleBulkFit();
            this.diffractionData.printStats();
            RotamerOptimization rotamerOptimization = new RotamerOptimization(this.activeAssembly, (Potential)refinementEnergy, this.algorithmListener);
            this.manyBodyOptions.initRotamerOptimization(rotamerOptimization, this.activeAssembly);
            double[] x = new double[refinementEnergy.getNumberOfVariables()];
            x = refinementEnergy.getCoordinates(x);
            this.initialTargetEnergy = refinementEnergy.energy(x, true);
            logger.info(String.format("\n Initial target energy: %16.8f ", this.initialTargetEnergy));
            ArrayList<Residue> residueList = rotamerOptimization.getResidues();
            if (i > 0) {
                Character altLoc = this.activeAssembly.getAlternateLocation();
                ArrayList<Residue> altLocResidues = new ArrayList<Residue>();
                for (Residue r : residues) {
                    if (!r.conatainsAltLoc(altLoc)) continue;
                    altLocResidues.add(r);
                }
                residueList = altLocResidues;
                rotamerOptimization.setResidues(altLocResidues);
            }
            RotamerLibrary.measureRotamers((List)residueList, (boolean)false);
            rotamerOptimization.optimize(this.manyBodyOptions.getAlgorithm(residueList.size()));
            int[] optimalRotamers = rotamerOptimization.getOptimumRotamers();
            if (titrationPH > 0.0) {
                isTitrating = titrationManyBody.excludeExcessAtoms(excludeAtoms, optimalRotamers, residueList);
            }
            logger.info(" Final Minimum Energy");
            x = refinementEnergy.getCoordinates(x);
            this.finalTargetEnergy = refinementEnergy.energy(x, true);
            if (isTitrating) {
                double phBias = rotamerOptimization.getEnergyExpansion().getTotalRotamerPhBias(residueList, optimalRotamers, titrationPH, this.manyBodyOptions.getPHRestraint());
                logger.info(String.format("\n  Rotamer pH Bias      %16.8f", phBias));
                logger.info(String.format("  Xray Target with Bias%16.8f\n", phBias + this.finalTargetEnergy));
            } else {
                logger.info(String.format("\n  Final Target Energy  %16.8f\n", this.finalTargetEnergy));
            }
            for (int j = 0; j < atoms.length; ++j) {
                atoms[j].setTempFactor(bfactors[j]);
            }
            this.diffractionData.scaleBulkFit();
            this.diffractionData.printStats();
        }
        if (Comm.world().rank() == 0) {
            properties.setProperty("standardizeAtomNames", (Object)"false");
            File modelFile = this.saveDirFile(this.activeAssembly.getFile());
            PDBFilter pdbFilter = new PDBFilter(modelFile, List.of(this.molecularAssemblies), this.activeAssembly.getForceField(), properties);
            if (titrationPH > 0.0) {
                String remark = String.format("Titration pH: %6.3f", titrationPH);
                if (!pdbFilter.writeFile(modelFile, false, excludeAtoms, true, true, new String[]{remark})) {
                    logger.info(String.format(" Save failed for %s", this.activeAssembly));
                }
            } else if (!pdbFilter.writeFile(modelFile, false, excludeAtoms, true, true)) {
                logger.info(String.format(" Save failed for %s", this.activeAssembly));
            }
        }
        return this;
    }

    public double getInitialTargetEnergy() {
        return this.initialTargetEnergy;
    }

    public double getFinalTargetEnergy() {
        return this.finalTargetEnergy;
    }

    public ManyBodyOptions getManyBodyOptions() {
        return this.manyBodyOptions;
    }

    public List<Potential> getPotentials() {
        return this.getPotentialsFromAssemblies(this.molecularAssemblies);
    }

    public boolean destroyPotentials() {
        return this.diffractionData == null ? true : this.diffractionData.destroy();
    }
}

