/*
 * Decompiled with CFR 0.152.
 */
package ffx.xray.commands;

import ffx.algorithms.cli.AlgorithmsCommand;
import ffx.numerics.Potential;
import ffx.utilities.FFXBinding;
import ffx.xray.parsers.MTZFilter;
import java.io.File;
import java.util.Collections;
import java.util.List;
import picocli.CommandLine;

@CommandLine.Command(description={" Write out information on an MTZ file."}, name="xray.MTZInfo")
public class MTZInfo
extends AlgorithmsCommand {
    @CommandLine.Parameters(arity="1", paramLabel="MTZ", description={"An MTZ diffraction file."})
    private String filename = null;

    public MTZInfo() {
    }

    public MTZInfo(String[] args) {
        super(args);
    }

    public MTZInfo(FFXBinding binding) {
        super(binding);
    }

    public MTZInfo run() {
        if (!this.init()) {
            return this;
        }
        logger.info("\n Running MTZInfo on " + this.filename);
        File file = new File(this.filename);
        if (!file.exists()) {
            System.out.println(" File " + this.filename + " was not found.");
            return this;
        }
        MTZFilter mtzFilter = new MTZFilter();
        mtzFilter.getReflectionList(file);
        mtzFilter.printHeader();
        return this;
    }

    public List<Potential> getPotentials() {
        return Collections.emptyList();
    }
}

