/*
 * Decompiled with CFR 0.152.
 */
package ffx.xray.commands;

import ffx.algorithms.cli.AlgorithmsCommand;
import ffx.numerics.Potential;
import ffx.potential.MolecularAssembly;
import ffx.potential.bonded.Atom;
import ffx.potential.bonded.Bond;
import ffx.potential.bonded.MSNode;
import ffx.potential.bonded.Molecule;
import ffx.utilities.FFXBinding;
import java.io.File;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import picocli.CommandLine;

@CommandLine.Command(description={" Deuterate exchangable hydrogen of the PDB model."}, name="xray.Deuterate")
public class Deuterate
extends AlgorithmsCommand {
    @CommandLine.Parameters(arity="1..*", paramLabel="files", description={"PDB input file."})
    private List<String> filenames;
    private MolecularAssembly[] molecularAssemblies;

    public Deuterate() {
    }

    public Deuterate(String[] args) {
        super(args);
    }

    public Deuterate(FFXBinding binding) {
        super(binding);
    }

    public Deuterate run() {
        String filename;
        if (!this.init()) {
            return this;
        }
        if (this.filenames != null && !this.filenames.isEmpty()) {
            this.molecularAssemblies = this.algorithmFunctions.openAll(this.filenames.get(0));
            this.activeAssembly = this.molecularAssemblies[0];
            filename = this.filenames.get(0);
        } else {
            if (this.activeAssembly == null) {
                logger.info(this.helpString());
                return this;
            }
            this.molecularAssemblies = new MolecularAssembly[]{this.activeAssembly};
            filename = this.activeAssembly.getFile().getAbsolutePath();
        }
        logger.info("\n Running xray.Deuterate on " + filename);
        for (MolecularAssembly molecularAssembly : this.molecularAssemblies) {
            Atom[] atoms;
            for (Atom a : atoms = molecularAssembly.getAtomArray()) {
                Atom b;
                if (!a.isHydrogen() || (b = ((Bond)a.getBonds().getFirst()).get1_2(a)).getAtomicNumber() != 7 && b.getAtomicNumber() != 8) continue;
                String name = a.getName().replaceFirst("H", "D");
                a.setName(name);
            }
            List water = molecularAssembly.getWater();
            for (MSNode node : water) {
                Molecule wat = (Molecule)node;
                wat.setName("DOD");
            }
        }
        this.algorithmFunctions.saveAsPDB(this.molecularAssemblies, new File(FilenameUtils.removeExtension((String)filename) + "_deuterate.pdb"));
        return this;
    }

    public List<Potential> getPotentials() {
        return this.getPotentialsFromAssemblies(this.molecularAssemblies);
    }
}

