/*
 * Decompiled with CFR 0.152.
 */
package ffx.xray.commands;

import ffx.algorithms.cli.AlgorithmsCommand;
import ffx.numerics.Potential;
import ffx.utilities.FFXBinding;
import ffx.xray.parsers.MTZFilter;
import java.io.File;
import java.util.Collections;
import java.util.List;
import picocli.CommandLine;

@CommandLine.Command(description={" Average two MTZ files."}, name="xray.AverageMTZ")
public class AverageMTZ
extends AlgorithmsCommand {
    @CommandLine.Option(names={"-i", "--iterations"}, paramLabel="1", description={"The current moving average iteration (use 1 for a \"normal\" average of two files)."})
    private int iteration = 1;
    @CommandLine.Parameters(arity="2", paramLabel="MTZ", description={"Two diffraction input files."})
    private List<String> filenames;

    public AverageMTZ() {
    }

    public AverageMTZ(String[] args) {
        super(args);
    }

    public AverageMTZ(FFXBinding binding) {
        super(binding);
    }

    public AverageMTZ run() {
        if (!this.init()) {
            return this;
        }
        if (this.filenames == null || this.filenames.size() <= 1) {
            logger.info(this.helpString());
            return this;
        }
        String mtzfile1 = this.filenames.get(0);
        String mtzfile2 = this.filenames.get(1);
        File file1 = new File(mtzfile1);
        if (!file1.exists()) {
            logger.info(mtzfile1 + " not found.");
            return this;
        }
        File file2 = new File(mtzfile2);
        if (!file2.exists()) {
            logger.info(mtzfile2 + " not found");
            return this;
        }
        MTZFilter mtzfilter = new MTZFilter();
        mtzfilter.averageFcs(file1, file2, mtzfilter.getReflectionList(file1), this.iteration, null);
        return this;
    }

    public List<Potential> getPotentials() {
        return Collections.emptyList();
    }
}

