/*
 * Decompiled with CFR 0.152.
 */
package ffx.xray;

import ffx.algorithms.AlgorithmListener;
import ffx.algorithms.Terminatable;
import ffx.numerics.OptimizationInterface;
import ffx.numerics.optimization.LBFGS;
import ffx.numerics.optimization.LineSearch;
import ffx.numerics.optimization.OptimizationListener;
import ffx.potential.MolecularAssembly;
import ffx.realspace.RealSpaceData;
import ffx.xray.DataContainer;
import ffx.xray.DiffractionData;
import ffx.xray.RefinementEnergy;
import ffx.xray.refine.RefinementMode;
import ffx.xray.refine.RefinementModel;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public class RefinementMinimize
implements OptimizationListener,
Terminatable {
    private static final Logger logger = Logger.getLogger(RefinementMinimize.class.getName());
    private final DataContainer dataContainer;
    private final AlgorithmListener listener;
    private final RefinementModel refinementModel;
    private final RefinementEnergy refinementEnergy;
    private final int n;
    private final double[] x;
    private final double[] grad;
    private final double[] scaling;
    private boolean done = false;
    private boolean terminate = false;
    private long time;
    private double grms;
    private int nSteps;

    public RefinementMinimize(DataContainer dataContainer) {
        this(dataContainer, null);
    }

    public RefinementMinimize(DataContainer dataContainer, @Nullable AlgorithmListener algorithmListener) {
        this.dataContainer = dataContainer;
        this.listener = algorithmListener;
        this.refinementModel = dataContainer.getRefinementModel();
        this.refinementEnergy = new RefinementEnergy(dataContainer);
        this.n = this.refinementModel.getNumParameters();
        this.x = new double[this.n];
        this.grad = new double[this.n];
        this.scaling = new double[this.n];
        this.refinementModel.loadOptimizationScaling(this.scaling);
        this.refinementEnergy.getCoordinates(this.x);
        this.refinementEnergy.setScaling(this.scaling);
    }

    public RefinementEnergy minimize() {
        return this.minimize(1.0);
    }

    public RefinementEnergy minimize(double eps) {
        return this.minimize(7, eps, Integer.MAX_VALUE);
    }

    public RefinementEnergy minimize(int maxIterations) {
        return this.minimize(7, 1.0, maxIterations);
    }

    public RefinementEnergy minimize(double eps, int maxIterations) {
        return this.minimize(7, eps, maxIterations);
    }

    public RefinementEnergy minimize(int m, double eps, int maxiter) {
        if (this.dataContainer instanceof DiffractionData) {
            logger.info(" Beginning X-ray Refinement");
        } else if (this.dataContainer instanceof RealSpaceData) {
            logger.info(" Beginning Real Space Refinement");
        } else {
            logger.info(" Beginning Refinement");
        }
        RefinementMode refinementMode = this.refinementModel.getRefinementMode();
        logger.info(refinementMode.toString());
        logger.info(this.refinementModel.toString());
        this.refinementEnergy.getCoordinates(this.x);
        for (int i = 0; i < this.n; ++i) {
            int n = i;
            this.x[n] = this.x[n] * this.scaling[i];
        }
        long mtime = -System.nanoTime();
        this.time = -System.nanoTime();
        this.done = false;
        double e = this.refinementEnergy.energyAndGradient(this.x, this.grad);
        int status = LBFGS.minimize((int)this.n, (int)m, (double[])this.x, (double)e, (double[])this.grad, (double)eps, (int)maxiter, (OptimizationInterface)this.refinementEnergy, (OptimizationListener)this);
        this.done = true;
        switch (status) {
            case 0: {
                logger.info(String.format("\n Optimization achieved convergence criteria: %8.5f", this.grms));
                break;
            }
            case 1: {
                logger.info(String.format("\n Optimization terminated at step %d.", this.nSteps));
                break;
            }
            default: {
                logger.warning("\n Optimization failed.");
            }
        }
        if (logger.isLoggable(Level.INFO)) {
            StringBuilder sb = new StringBuilder();
            sb.append(String.format(" Optimization time: %g (sec)", (double)(mtime += System.nanoTime()) * 1.0E-9));
            logger.info(sb.toString());
        }
        return this.refinementEnergy;
    }

    public boolean optimizationUpdate(int iter, int nBFGS, int nfun, double grms, double xrms, double f, double df, double angle, @Nullable LineSearch.LineSearchResult info) {
        long currentTime = System.nanoTime();
        double seconds = (double)(currentTime - this.time) * 1.0E-9;
        this.time = currentTime;
        this.grms = grms;
        this.nSteps = iter;
        if (this.listener != null) {
            MolecularAssembly[] molecularAssembly;
            RefinementModel refinementModel = this.dataContainer.getRefinementModel();
            for (MolecularAssembly ma : molecularAssembly = refinementModel.getMolecularAssemblies()) {
                this.listener.algorithmUpdate(ma);
            }
        }
        if (iter == 0) {
            if (nBFGS > 0) {
                logger.info("\n Limited Memory BFGS Quasi-Newton Optimization: \n");
            } else {
                logger.info("\n Steepest Decent Optimization: \n");
            }
            logger.info(" Cycle       Energy      G RMS    Delta E   Delta X    Angle  Evals     Time      " + this.dataContainer.printOptimizationHeader());
        }
        if (info == null) {
            logger.info(String.format("%6d %12.3f %10.3f", iter, f, grms));
        } else if (info == LineSearch.LineSearchResult.Success) {
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("%6d %12.3f %10.3f %10.3f %9.4f %8.2f %6d %8.3f ", iter, f, grms, df, xrms, angle, nfun, seconds));
            sb.append(this.dataContainer.printOptimizationUpdate());
            logger.info(sb.toString());
        } else {
            logger.info(String.format("%6d %12.3f %10.3f %10.3f %9.4f %8.2f %6d %8s", iter, f, grms, df, xrms, angle, nfun, info));
        }
        if (this.terminate) {
            logger.info(" The optimization received a termination request.");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        this.terminate = true;
        while (!this.done) {
            RefinementMinimize refinementMinimize = this;
            synchronized (refinementMinimize) {
                try {
                    this.wait(1L);
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, " Exception terminating minimization.\n", e);
                }
            }
        }
    }
}

