/*
 * Decompiled with CFR 0.152.
 */
package ffx.xray;

import ffx.crystal.ReflectionList;
import ffx.numerics.math.ComplexNumber;
import ffx.numerics.math.ScalarMath;
import ffx.xray.CrystalReciprocalSpace;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.configuration2.CompositeConfiguration;
import org.apache.commons.math3.util.FastMath;

public class DiffractionRefinementData {
    private static final Logger logger = Logger.getLogger(DiffractionRefinementData.class.getName());
    public final int n;
    public final int[] freeR;
    public final double[][] fc;
    public final double[][] fs;
    public final double[][] fomPhi;
    public final double[][] foFc1;
    final double[][] foFc2;
    public final double fSigFCutoff;
    final int nScale;
    final double[][] fSigF;
    final double[][] fcTot;
    final double[][] dFc;
    final double[][] dFs;
    final int nBins;
    public double[] spline;
    public double[] sigmaA;
    public double[] sigmaW;
    public int rFreeFlag;
    double llkR;
    double llkF;
    CrystalReciprocalSpace crystalReciprocalSpaceFc;
    CrystalReciprocalSpace crystalReciprocalSpaceFs;
    double[] esqFc;
    double[] esqFo;
    double bulkSolventK;
    double bulkSolventUeq;
    boolean bulkSolventFixed = false;
    double modelScaleK;
    double[] modelAnisoB = new double[6];

    public DiffractionRefinementData(CompositeConfiguration properties, ReflectionList reflectionList) {
        int i;
        int rflag = -1;
        if (properties != null) {
            rflag = properties.getInt("rfree-flag", -1);
            this.fSigFCutoff = properties.getDouble("f-sigf-cutoff", -1.0);
        } else {
            this.fSigFCutoff = -1.0;
        }
        this.n = reflectionList.hklList.size();
        this.nScale = reflectionList.crystal.scaleN;
        this.rFreeFlag = rflag;
        this.nBins = reflectionList.nBins;
        this.fSigF = new double[this.n][2];
        this.freeR = new int[this.n];
        this.fc = new double[this.n][2];
        this.fs = new double[this.n][2];
        this.fcTot = new double[this.n][2];
        this.fomPhi = new double[this.n][2];
        this.foFc2 = new double[this.n][2];
        this.foFc1 = new double[this.n][2];
        this.dFc = new double[this.n][2];
        this.dFs = new double[this.n][2];
        for (i = 0; i < this.n; ++i) {
            this.fSigF[i][1] = Double.NaN;
            this.fSigF[i][0] = Double.NaN;
            this.fcTot[i][1] = Double.NaN;
            this.fcTot[i][0] = Double.NaN;
        }
        this.spline = new double[this.nBins * 2];
        this.sigmaA = new double[this.nBins];
        this.sigmaW = new double[this.nBins];
        this.esqFc = new double[this.nBins];
        this.esqFo = new double[this.nBins];
        for (i = 0; i < this.nBins; ++i) {
            this.esqFo[i] = 1.0;
            this.esqFc[i] = 1.0;
            this.sigmaA[i] = 1.0;
            this.spline[i + this.nBins] = 1.0;
            this.spline[i] = 1.0;
            this.sigmaW[i] = 0.05;
        }
        this.bulkSolventK = 0.33;
        this.bulkSolventUeq = ScalarMath.b2u((double)50.0);
        this.modelScaleK = 0.0;
    }

    public double FoFc2F(int i) {
        ComplexNumber c = new ComplexNumber(this.foFc2[i][0], this.foFc2[i][1]);
        return c.abs();
    }

    public double FoFc2Phi(int i) {
        ComplexNumber c = new ComplexNumber(this.foFc2[i][0], this.foFc2[i][1]);
        return c.phase();
    }

    public double fcF(int i) {
        ComplexNumber c = new ComplexNumber(this.fc[i][0], this.fc[i][1]);
        return c.abs();
    }

    public double fcPhi(int i) {
        ComplexNumber c = new ComplexNumber(this.fc[i][0], this.fc[i][1]);
        return c.phase();
    }

    public double fcTotF(int i) {
        ComplexNumber c = new ComplexNumber(this.fcTot[i][0], this.fcTot[i][1]);
        return c.abs();
    }

    public double fcTotPhi(int i) {
        ComplexNumber c = new ComplexNumber(this.fcTot[i][0], this.fcTot[i][1]);
        return c.phase();
    }

    public double foFc1F(int i) {
        ComplexNumber c = new ComplexNumber(this.foFc1[i][0], this.foFc1[i][1]);
        return c.abs();
    }

    public double foFc1Phi(int i) {
        ComplexNumber c = new ComplexNumber(this.foFc1[i][0], this.foFc1[i][1]);
        return c.phase();
    }

    public double fsF(int i) {
        ComplexNumber c = new ComplexNumber(this.fs[i][0], this.fs[i][1]);
        return c.abs();
    }

    public double fsPhi(int i) {
        ComplexNumber c = new ComplexNumber(this.fs[i][0], this.fs[i][1]);
        return c.phase();
    }

    public void generateFsigFfromAnomalousFsigF(double[][] anomalousFsigF) {
        for (int i = 0; i < this.n; ++i) {
            if (Double.isNaN(anomalousFsigF[i][0]) && Double.isNaN(anomalousFsigF[i][2])) continue;
            if (Double.isNaN(anomalousFsigF[i][0])) {
                this.fSigF[i][0] = anomalousFsigF[i][2];
                this.fSigF[i][1] = anomalousFsigF[i][3];
                continue;
            }
            if (Double.isNaN(anomalousFsigF[i][2])) {
                this.fSigF[i][0] = anomalousFsigF[i][0];
                this.fSigF[i][1] = anomalousFsigF[i][1];
                continue;
            }
            this.fSigF[i][0] = (anomalousFsigF[i][0] + anomalousFsigF[i][2]) / 2.0;
            this.fSigF[i][1] = FastMath.sqrt((double)(anomalousFsigF[i][1] * anomalousFsigF[i][1] + anomalousFsigF[i][3] * anomalousFsigF[i][3]));
        }
    }

    public void generateRFree() {
        int nonfree;
        int free;
        Random generator = new Random();
        int nfree = 0;
        if (this.rFreeFlag == 0) {
            free = 0;
            nonfree = 1;
        } else {
            free = 1;
            nonfree = 0;
        }
        for (int i = 0; i < this.n; ++i) {
            if (Double.isNaN(this.fSigF[i][0])) {
                this.freeR[i] = nonfree;
                continue;
            }
            int randomi = generator.nextInt(100);
            if (randomi < 5) {
                this.freeR[i] = free;
                ++nfree;
                continue;
            }
            this.freeR[i] = nonfree;
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.info(String.format(" Assigned %d of %d reflections to the R free set (5%%).\n", nfree, this.n));
        }
    }

    public double getF(int i) {
        return this.fSigF[i][0];
    }

    public double[] getFSigF(int i) {
        return this.fSigF[i];
    }

    public ComplexNumber getFcTot(int i) {
        return new ComplexNumber(this.fcTot[i][0], this.fcTot[i][1]);
    }

    public ComplexNumber getFoFc1(int i) {
        return new ComplexNumber(this.foFc1[i][0], this.foFc1[i][1]);
    }

    public void getFoFc1IP(int i, ComplexNumber c) {
        c.re(this.foFc1[i][0]);
        c.im(this.foFc1[i][1]);
    }

    public ComplexNumber getFoFc2(int i) {
        return new ComplexNumber(this.foFc2[i][0], this.foFc2[i][1]);
    }

    public void getFoFc2IP(int i, ComplexNumber c) {
        c.re(this.foFc2[i][0]);
        c.im(this.foFc2[i][1]);
    }

    public int getFreeR(int i) {
        return this.freeR[i];
    }

    public ComplexNumber getFs(int i) {
        return new ComplexNumber(this.fs[i][0], this.fs[i][1]);
    }

    public double getSigF(int i) {
        return this.fSigF[i][1];
    }

    public void intensitiesToAmplitudes() {
        for (int i = 0; i < this.n; ++i) {
            if (this.fSigF[i][0] > 0.0) {
                double tmp = this.fSigF[i][0];
                this.fSigF[i][0] = FastMath.sqrt((double)tmp);
                if (this.fSigF[i][1] < tmp) {
                    this.fSigF[i][1] = this.fSigF[i][0] - FastMath.sqrt((double)(tmp - this.fSigF[i][1]));
                    continue;
                }
                this.fSigF[i][1] = this.fSigF[i][0];
                continue;
            }
            if (Double.isNaN(this.fSigF[i][0])) continue;
            this.fSigF[i][0] = 0.0;
            this.fSigF[i][1] = 0.0;
        }
        if (logger.isLoggable(Level.WARNING)) {
            StringBuilder sb = new StringBuilder();
            sb.append("\n Internally converting intensities to amplitudes.\n");
            sb.append(" This does not use French & Wilson scaling.\n");
            logger.info(sb.toString());
        }
    }

    public boolean isFreeR(int i, int f) {
        return this.freeR[i] == f;
    }

    public double likelihoodFree() {
        return this.llkF;
    }

    public double likelihoodWork() {
        return this.llkR;
    }

    public void setF(int i, double f) {
        this.fSigF[i][0] = f;
    }

    public void setFSigF(int i, double f, double sigf) {
        this.fSigF[i][0] = f;
        this.fSigF[i][1] = sigf;
    }

    public void setFc(int i, ComplexNumber c) {
        this.fc[i][0] = c.re();
        this.fc[i][1] = c.im();
    }

    public void setFcTot(int i, ComplexNumber c) {
        this.fcTot[i][0] = c.re();
        this.fcTot[i][1] = c.im();
    }

    public void setFoFc1(int i, ComplexNumber c) {
        this.foFc1[i][0] = c.re();
        this.foFc1[i][1] = c.im();
    }

    public void setFoFc2(int i, ComplexNumber c) {
        this.foFc2[i][0] = c.re();
        this.foFc2[i][1] = c.im();
    }

    public void setFreeR(int i, int f) {
        this.freeR[i] = f;
    }

    public void setFreeRFlag(int i) {
        this.rFreeFlag = i;
    }

    public void setFs(int i, ComplexNumber c) {
        this.fs[i][0] = c.re();
        this.fs[i][1] = c.im();
    }

    public void setSigF(int i, double sigF) {
        this.fSigF[i][1] = sigF;
    }

    void setCrystalReciprocalSpaceFc(CrystalReciprocalSpace crystalReciprocalSpace) {
        this.crystalReciprocalSpaceFc = crystalReciprocalSpace;
    }

    void setCrystalReciprocalSpaceFs(CrystalReciprocalSpace crystalReciprocalSpace) {
        this.crystalReciprocalSpaceFs = crystalReciprocalSpace;
    }

    boolean isFreeR(int i) {
        return this.freeR[i] == this.rFreeFlag;
    }

    ComplexNumber getFc(int i) {
        return new ComplexNumber(this.fc[i][0], this.fc[i][1]);
    }

    void getFcIP(int i, ComplexNumber c) {
        c.re(this.fc[i][0]);
        c.im(this.fc[i][1]);
    }

    void getFsIP(int i, ComplexNumber c) {
        c.re(this.fs[i][0]);
        c.im(this.fs[i][1]);
    }

    void getFcTotIP(int i, ComplexNumber c) {
        c.re(this.fcTot[i][0]);
        c.im(this.fcTot[i][1]);
    }
}

