/*
 * Decompiled with CFR 0.152.
 */
package ffx.realspace.commands;

import ffx.algorithms.cli.AlgorithmsCommand;
import ffx.algorithms.cli.ManyBodyOptions;
import ffx.algorithms.optimize.RotamerOptimization;
import ffx.algorithms.optimize.TitrationManyBody;
import ffx.numerics.Potential;
import ffx.potential.ForceFieldEnergy;
import ffx.potential.MolecularAssembly;
import ffx.potential.bonded.Atom;
import ffx.potential.bonded.NamingUtils;
import ffx.potential.bonded.Residue;
import ffx.potential.bonded.Rotamer;
import ffx.potential.bonded.RotamerLibrary;
import ffx.potential.cli.AlchemicalOptions;
import ffx.potential.parameters.ForceField;
import ffx.potential.parsers.PDBFilter;
import ffx.realspace.cli.RealSpaceOptions;
import ffx.utilities.FFXBinding;
import ffx.xray.RefinementEnergy;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.configuration2.CompositeConfiguration;
import picocli.CommandLine;

@CommandLine.Command(description={" Run GenZ for ensemble generation."}, name="ffxc realspace.GenZ")
public class GenZ
extends AlgorithmsCommand {
    @CommandLine.Mixin
    private ManyBodyOptions manyBodyOptions;
    @CommandLine.Mixin
    private AlchemicalOptions alchemicalOptions;
    @CommandLine.Mixin
    private RealSpaceOptions realSpaceOptions;
    @CommandLine.Option(names={"--rEE", "--ro-ensembleEnergy"}, paramLabel="0.0", description={"Keep permutations within ensemble Energy kcal/mol from the GMEC."})
    private String ensembleEnergy = "0.0";
    @CommandLine.Option(names={"--pF", "--printFiles"}, paramLabel="false", description={"Write to an energy restart file and ensemble file."})
    private boolean printFiles = false;
    @CommandLine.Option(names={"--pKa"}, paramLabel="false", description={"Calculating protonation populations for pKa shift."})
    private boolean pKa = false;
    @CommandLine.Parameters(arity="1..*", paramLabel="files", description={"PDB and Real Space input files."})
    private List<String> filenames;
    private RefinementEnergy refinementEnergy;
    ForceFieldEnergy potentialEnergy;
    private MolecularAssembly[] molecularAssemblies;
    private ForceField forceField;
    TitrationManyBody titrationManyBody;
    List<Residue> selectedResidues;
    MolecularAssembly[] conformerAssemblies = new MolecularAssembly[3];

    public GenZ() {
    }

    public GenZ(String[] args) {
        super(args);
    }

    public GenZ(FFXBinding binding) {
        super(binding);
    }

    public GenZ run() {
        int[][] conformers;
        if (!this.init()) {
            return this;
        }
        System.setProperty("sor-scf-fallback", "false");
        System.setProperty("direct-scf-fallback", "true");
        double titrationPH = this.manyBodyOptions.getTitrationPH();
        double inclusionCutoff = this.manyBodyOptions.getInclusionCutoff();
        int mutatingResidue = this.manyBodyOptions.getInterestedResidue();
        boolean onlyTitration = this.manyBodyOptions.getOnlyTitration();
        double pHRestraint = this.manyBodyOptions.getPHRestraint();
        if (this.manyBodyOptions.getTitration()) {
            System.setProperty("manybody-titration", "true");
        }
        String nea = System.getProperty("native-environment-approximation", "true");
        System.setProperty("native-environment-approximation", nea);
        boolean lambdaTerm = this.alchemicalOptions.hasSoftcore();
        if (lambdaTerm) {
            System.setProperty("lambdaterm", "true");
            System.setProperty("elec-lambdaterm", "false");
            System.setProperty("intramolecular-softcore", "true");
        }
        System.setProperty("ro-ensembleEnergy", this.ensembleEnergy);
        if (this.filenames != null && !this.filenames.isEmpty()) {
            this.molecularAssemblies = this.algorithmFunctions.openAll(this.filenames.get(0));
            this.activeAssembly = this.molecularAssemblies[0];
            modelFilename = this.filenames.get(0);
        } else {
            if (this.activeAssembly == null) {
                logger.info(this.helpString());
                return this;
            }
            this.molecularAssemblies = new MolecularAssembly[]{this.activeAssembly};
            modelFilename = this.activeAssembly.getFile().getAbsolutePath();
        }
        CompositeConfiguration properties = this.activeAssembly.getProperties();
        this.activeAssembly.getPotentialEnergy().setPrintOnFailure(false, false);
        this.potentialEnergy = this.activeAssembly.getPotentialEnergy();
        this.forceField = this.activeAssembly.getForceField();
        if (this.forceField == null) {
            logger.info("This force field is null");
        }
        String filename = this.filenames.get(0);
        ArrayList titrateResidues = new ArrayList();
        HashSet excludeAtoms = new HashSet();
        boolean isTitrating = false;
        String[] titratableResidues = new String[]{"HIS", "HIE", "HID", "GLU", "GLH", "ASP", "ASH", "LYS", "LYD", "CYS", "CYD"};
        List<String> titratableResiudesList = Arrays.asList(titratableResidues);
        double[][] populationArray = new double[1][55];
        double totalBoltzmann = 0.0;
        List residueList = this.activeAssembly.getResidueList();
        List residues = this.manyBodyOptions.collectResidues(this.activeAssembly);
        if (residues == null || residues.isEmpty()) {
            logger.info(" There are no residues in the active system to optimize.");
            return this;
        }
        if (properties.getBoolean("standardizeAtomNames", false)) {
            NamingUtils.renameAtomsToPDBStandard((MolecularAssembly)this.activeAssembly);
        }
        if (this.manyBodyOptions.getTitration()) {
            logger.info("\n Adding titration hydrogen to : " + this.filenames.get(0) + "\n");
            ArrayList<Integer> resNumberList = new ArrayList<Integer>();
            for (Residue residue : residues) {
                resNumberList.add(residue.getResidueNumber());
            }
            this.titrationManyBody = new TitrationManyBody(filename, this.activeAssembly.getForceField(), resNumberList, titrationPH, this.manyBodyOptions);
            this.activeAssembly = this.titrationManyBody.getProtonatedAssembly();
            this.potentialEnergy = this.activeAssembly.getPotentialEnergy();
        }
        this.molecularAssemblies = new MolecularAssembly[]{this.activeAssembly};
        this.refinementEnergy = this.realSpaceOptions.toRealSpaceEnergy(this.filenames, this.molecularAssemblies);
        if (lambdaTerm) {
            this.alchemicalOptions.setFirstSystemAlchemistry(this.activeAssembly);
            ForceFieldEnergy lambdaInterface = this.potentialEnergy;
            double lambda = this.alchemicalOptions.getInitialLambda();
            logger.info(String.format(" Setting ManyBody softcore lambda to: %5.3f", lambda));
            lambdaInterface.setLambda(lambda);
        }
        RotamerOptimization rotamerOptimization = new RotamerOptimization(this.activeAssembly, (Potential)this.refinementEnergy, this.algorithmListener);
        rotamerOptimization.setPrintFiles(this.printFiles);
        rotamerOptimization.setWriteEnergyRestart(this.printFiles);
        rotamerOptimization.setPHRestraint(pHRestraint);
        rotamerOptimization.setpH(titrationPH);
        this.manyBodyOptions.initRotamerOptimization(rotamerOptimization, this.activeAssembly);
        double[] x = new double[this.refinementEnergy.getNumberOfVariables()];
        x = this.refinementEnergy.getCoordinates(x);
        double e = this.refinementEnergy.energy(x, true);
        logger.info(String.format("\n Initial target energy: %16.8f ", e));
        this.selectedResidues = rotamerOptimization.getResidues();
        rotamerOptimization.initFraction(this.selectedResidues);
        RotamerLibrary.measureRotamers((List)residueList, (boolean)false);
        rotamerOptimization.optimize(this.manyBodyOptions.getAlgorithm(residueList.size()));
        int[] currentRotamers = new int[this.selectedResidues.size()];
        try {
            rotamerOptimization.getFractions(this.selectedResidues.toArray(new Residue[0]), 0, currentRotamers);
            if (this.pKa) {
                rotamerOptimization.getProtonationPopulations(this.selectedResidues.toArray(new Residue[0]));
            }
        }
        catch (Exception ex) {
            logger.severe(" Error calculating rotamer fractions: " + ex.getMessage());
            return this;
        }
        double boltzmannWeights = rotamerOptimization.getTotalBoltzmann();
        double offsets = rotamerOptimization.getRefEnergy();
        populationArray = rotamerOptimization.getFraction();
        try (FileWriter fileWriter = new FileWriter("populations.txt");){
            int residueIndex = 0;
            for (Residue residue : this.selectedResidues) {
                fileWriter.write("\n");
                Rotamer[] rotamers = residue.getRotamers();
                for (int rotIndex = 0; rotIndex < rotamers.length; ++rotIndex) {
                    String rotPop = String.format("%.6f", populationArray[residueIndex][rotIndex]);
                    fileWriter.write(residue.getName() + residue.getResidueNumber() + "\t" + rotamers[rotIndex].toString() + "\t" + rotPop + "\n");
                }
                ++residueIndex;
            }
            System.out.println("\n Successfully wrote to the populations file.");
        }
        catch (IOException ioException) {
            logger.severe(" Error writing populations file: " + ioException.getMessage());
        }
        try {
            conformers = rotamerOptimization.getConformers();
        }
        catch (Exception ex) {
            logger.severe(" Error getting conformers: " + ex.getMessage());
            return this;
        }
        char[] altLocs = new char[]{'C', 'B', 'A'};
        ArrayList<CallSite> residueChainNum = new ArrayList<CallSite>();
        for (Residue residue : this.activeAssembly.getResidueList()) {
            char chain = residue.getChainID().charValue();
            int resNum = residue.getResidueNumber();
            residueChainNum.add((CallSite)((Object)(String.valueOf(chain) + String.valueOf(resNum))));
        }
        File file = new File(filename);
        int[] optimalRotamers = new int[this.selectedResidues.size()];
        int assemblyIndex = 0;
        String[] rotNames = new String[this.selectedResidues.size()];
        for (int confIndex = 2; confIndex > -1; --confIndex) {
            ArrayList<Residue> conformerResidueList = new ArrayList<Residue>();
            MolecularAssembly conformerAssembly = this.algorithmFunctions.open(filename);
            if (this.manyBodyOptions.getTitration()) {
                logger.info("\n Adding titration hydrogen to : " + this.filenames.get(0) + "\n");
                ArrayList<Integer> resNumberList = new ArrayList<Integer>();
                for (Residue residue : residues) {
                    resNumberList.add(residue.getResidueNumber());
                }
                this.titrationManyBody = new TitrationManyBody(filename, this.activeAssembly.getForceField(), resNumberList, titrationPH, this.manyBodyOptions);
                conformerAssembly = this.titrationManyBody.getProtonatedAssembly();
                this.potentialEnergy = conformerAssembly.getPotentialEnergy();
            }
            for (int resIndex = 0; resIndex < this.selectedResidues.size(); ++resIndex) {
                Residue residueSelect = this.selectedResidues.get(resIndex);
                String resChainNum = String.valueOf(residueSelect.getChainID()) + String.valueOf(residueSelect.getResidueNumber());
                int index = residueChainNum.indexOf(resChainNum);
                Residue residue = (Residue)conformerAssembly.getResidueList().get(index);
                conformerResidueList.add(residue);
                residue.setRotamers(this.manyBodyOptions.getRotamerLibrary(true));
                Rotamer[] rotamers = residue.getRotamers();
                int rotIndex = conformers[resIndex][confIndex];
                if (populationArray[resIndex][rotIndex] == 0.0) continue;
                optimalRotamers[resIndex] = rotIndex;
                RotamerLibrary.applyRotamer((Residue)residue, (Rotamer)rotamers[rotIndex]);
                double occupancy = populationArray[resIndex][rotIndex];
                boolean diffStates = false;
                for (int i = 2; i > -1; --i) {
                    int rotamerInd = conformers[resIndex][i];
                    String rotName = rotamers[rotamerInd].getName();
                    double occupancyTest = populationArray[resIndex][rotamerInd];
                    if (i == 2 && rotNames[resIndex] != null) {
                        rotNames[resIndex] = rotName;
                        continue;
                    }
                    if (i < 2 && occupancyTest != 0.0 && !rotNames[resIndex].contains(rotName)) {
                        diffStates = true;
                        String newString = rotNames[resIndex] + rotName;
                        logger.info(newString);
                        rotNames[resIndex] = newString;
                        continue;
                    }
                    if (i != 2) continue;
                    rotNames[resIndex] = rotName;
                }
                for (Atom atom : residue.getAtomList()) {
                    if (!residue.getBackboneAtoms().contains(atom) || diffStates) {
                        if (occupancy != 1.0) {
                            atom.setAltLoc(Character.valueOf(altLocs[confIndex]));
                            atom.setOccupancy(occupancy);
                            continue;
                        }
                        atom.setOccupancy(occupancy);
                        atom.setAltLoc(Character.valueOf(' '));
                        continue;
                    }
                    atom.setOccupancy(1.0);
                    atom.setAltLoc(Character.valueOf(' '));
                }
            }
            this.conformerAssemblies[assemblyIndex] = conformerAssembly;
            this.titrationManyBody.excludeExcessAtoms(excludeAtoms, optimalRotamers, this.conformerAssemblies[assemblyIndex], conformerResidueList);
            excludeAtoms.addAll(this.titrationManyBody.getExcludeAtoms());
            ++assemblyIndex;
        }
        PDBFilter pdbFilter = new PDBFilter(file, Arrays.asList(this.conformerAssemblies), this.forceField, properties);
        pdbFilter.writeFile(file, false, excludeAtoms, true, true);
        System.setProperty("standardizeAtomNames", "false");
        return this;
    }
}

