/*
 * Decompiled with CFR 0.152.
 */
package ffx.realspace.commands;

import ffx.algorithms.cli.AlgorithmsCommand;
import ffx.algorithms.cli.AnnealOptions;
import ffx.algorithms.cli.DynamicsOptions;
import ffx.algorithms.optimize.anneal.SimulatedAnnealing;
import ffx.numerics.Potential;
import ffx.potential.MolecularAssembly;
import ffx.potential.cli.AtomSelectionOptions;
import ffx.potential.cli.WriteoutOptions;
import ffx.potential.utils.PotentialsFunctions;
import ffx.realspace.cli.RealSpaceOptions;
import ffx.utilities.FFXBinding;
import ffx.xray.RefinementEnergy;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import picocli.CommandLine;

@CommandLine.Command(description={" Simulated annealing on a Real Space target."}, name="realspace.Anneal")
public class Anneal
extends AlgorithmsCommand {
    @CommandLine.Mixin
    private AnnealOptions annealOptions;
    @CommandLine.Mixin
    private AtomSelectionOptions atomSelectionOptions;
    @CommandLine.Mixin
    private DynamicsOptions dynamicsOptions;
    @CommandLine.Mixin
    private RealSpaceOptions realSpaceOptions;
    @CommandLine.Mixin
    private WriteoutOptions writeoutOptions;
    @CommandLine.Parameters(arity="1..*", paramLabel="files", description={"PDB and Real Space input files."})
    private List<String> filenames;
    private RefinementEnergy refinementEnergy;

    public Anneal() {
    }

    public Anneal(String[] args) {
        super(args);
    }

    public Anneal(FFXBinding binding) {
        super(binding);
    }

    public Anneal run() {
        String filename;
        if (!this.init()) {
            return this;
        }
        this.dynamicsOptions.init();
        if (this.filenames != null && !this.filenames.isEmpty()) {
            this.activeAssembly = this.algorithmFunctions.open(this.filenames.get(0));
            filename = this.filenames.get(0);
        } else {
            if (this.activeAssembly == null) {
                logger.info(this.helpString());
                return this;
            }
            filename = this.activeAssembly.getFile().getAbsolutePath();
        }
        MolecularAssembly[] molecularAssemblies = new MolecularAssembly[]{this.activeAssembly};
        logger.info("\n Running simulated annealing on on real-space target including " + filename + "\n");
        this.atomSelectionOptions.setActiveAtoms(this.activeAssembly);
        RefinementEnergy potential = this.realSpaceOptions.toRealSpaceEnergy(this.filenames, molecularAssemblies);
        this.algorithmFunctions.energy(this.activeAssembly);
        File dyn = new File(FilenameUtils.removeExtension((String)filename) + ".dyn");
        if (!dyn.exists()) {
            dyn = null;
        }
        SimulatedAnnealing simulatedAnnealing = this.annealOptions.createAnnealer(this.dynamicsOptions, this.activeAssembly, (Potential)potential, this.algorithmListener, dyn);
        simulatedAnnealing.setPrintInterval(this.dynamicsOptions.getReport());
        simulatedAnnealing.setSaveFrequency(this.dynamicsOptions.getWrite());
        simulatedAnnealing.setRestartFrequency(this.dynamicsOptions.getCheckpoint());
        simulatedAnnealing.setTrajectorySteps(this.dynamicsOptions.getTrajSteps());
        simulatedAnnealing.anneal();
        if (!(this.baseDir != null && this.baseDir.exists() && this.baseDir.isDirectory() && this.baseDir.canWrite())) {
            this.baseDir = new File(FilenameUtils.getFullPath((String)filename));
        }
        String dirName = this.baseDir.toString() + File.separator;
        String fileName = FilenameUtils.getName((String)filename);
        fileName = FilenameUtils.removeExtension((String)fileName);
        this.writeoutOptions.saveFile(String.format("%s%s", dirName, fileName), (PotentialsFunctions)this.algorithmFunctions, this.activeAssembly);
        return this;
    }

    public List<Potential> getPotentials() {
        return this.refinementEnergy == null ? Collections.emptyList() : Collections.singletonList(this.refinementEnergy);
    }
}

