/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.itertools;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.ItertoolsModuleBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.iterator.IteratorNodes;
import com.oracle.graal.python.builtins.objects.itertools.PProduct;
import com.oracle.graal.python.builtins.objects.itertools.ProductBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.itertools.ProductBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotIterNext;
import com.oracle.graal.python.lib.PyLongAsIntNode;
import com.oracle.graal.python.lib.PyObjectGetItem;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.LoopNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.profiles.InlinedLoopConditionProfile;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PProduct})
public final class ProductBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = ProductBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return ProductBuiltinsFactory.getFactories();
    }

    @Builtin(name="__setstate__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class SetStateNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static Object setState(VirtualFrame frame, PProduct self, Object state, @Bind Node inliningTarget, @Cached PyObjectGetItem getItemNode, @Cached InlinedLoopConditionProfile loopProfile, @Cached PyLongAsIntNode pyLongAsIntNode, @Cached InlinedBranchProfile stoppedProfile, @Cached InlinedConditionProfile indexProfile) {
            ItertoolsModuleBuiltins.warnPickleDeprecated();
            Object[][] gears = self.getGears();
            Object[] lst = new Object[gears.length];
            int[] indices = self.getIndices();
            loopProfile.profileCounted(inliningTarget, (long)gears.length);
            int i = 0;
            while (loopProfile.inject(inliningTarget, i < gears.length)) {
                Object o = getItemNode.execute((Frame)frame, inliningTarget, state, i);
                int index = pyLongAsIntNode.execute((Frame)frame, inliningTarget, o);
                int gearSize = gears[i].length;
                if (indices == null || gearSize == 0) {
                    stoppedProfile.enter(inliningTarget);
                    self.setStopped(true);
                    return PNone.NONE;
                }
                if (indexProfile.profile(inliningTarget, index < 0)) {
                    index = 0;
                } else if (index > gearSize - 1) {
                    index = gearSize - 1;
                }
                indices[i] = index;
                lst[i] = gears[i][index];
                ++i;
            }
            self.setLst(lst);
            return PNone.NONE;
        }
    }

    @Builtin(name="__reduce__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ReduceNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object reduce(PProduct self, @Bind Node inliningTarget, @Cached InlinedConditionProfile stoppedProfile, @Cached InlinedConditionProfile noLstProfile, @Cached GetClassNode getClassNode, @Bind PythonLanguage language) {
            ItertoolsModuleBuiltins.warnPickleDeprecated();
            Object type = getClassNode.execute(inliningTarget, self);
            if (stoppedProfile.profile(inliningTarget, self.isStopped())) {
                PTuple empty = PFactory.createEmptyTuple(language);
                return PFactory.createTuple(language, new Object[]{type, PFactory.createTuple(language, new Object[]{empty})});
            }
            PTuple gearTuples = ReduceNode.createGearTuple(self, language);
            if (noLstProfile.profile(inliningTarget, self.getLst() == null)) {
                return PFactory.createTuple(language, new Object[]{type, gearTuples});
            }
            PTuple indicesTuple = PFactory.createTuple(language, PythonUtils.arrayCopyOf(self.getIndices(), self.getIndices().length));
            return PFactory.createTuple(language, new Object[]{type, gearTuples, indicesTuple});
        }

        private static PTuple createGearTuple(PProduct self, PythonLanguage language) {
            Object[] lists = new PList[self.getGears().length];
            for (int i = 0; i < lists.length; ++i) {
                lists[i] = PFactory.createList(language, self.getGears()[i]);
            }
            return PFactory.createTuple(language, lists);
        }
    }

    @Slot(value=Slot.SlotKind.tp_iternext, isComplex=true)
    @GenerateNodeFactory
    public static abstract class NextNode
    extends TpSlotIterNext.TpIterNextBuiltin {
        @Specialization(guards={"!self.isStopped()", "!hasLst(self)"})
        static Object next(PProduct self, @Bind Node inliningTarget, @Cached.Exclusive @Cached InlinedLoopConditionProfile loopProfile, @Bind PythonLanguage language) {
            Object[] lst = new Object[self.getGears().length];
            loopProfile.profileCounted(inliningTarget, (long)lst.length);
            int i = 0;
            while (loopProfile.inject(inliningTarget, i < lst.length)) {
                lst[i] = self.getGears()[i][0];
                ++i;
            }
            self.setLst(lst);
            return PFactory.createTuple(language, lst);
        }

        @Specialization(guards={"!self.isStopped()", "hasLst(self)"})
        static Object next(PProduct self, @Bind Node inliningTarget, @Cached InlinedConditionProfile gearsProfile, @Cached InlinedConditionProfile indexProfile, @Cached InlinedBranchProfile wasStoppedProfile, @Cached.Exclusive @Cached InlinedLoopConditionProfile loopProfile, @Cached InlinedBranchProfile doneProfile, @Bind PythonLanguage language) {
            Object[][] gears = self.getGears();
            int x = gears.length - 1;
            if (gearsProfile.profile(inliningTarget, x >= 0)) {
                Object[] gear = gears[x];
                int[] indices = self.getIndices();
                int index = indices[x] + 1;
                if (indexProfile.profile(inliningTarget, index < gear.length)) {
                    self.getLst()[x] = gear[index];
                    indices[x] = index;
                } else {
                    NextNode.rotatePreviousGear(inliningTarget, self, loopProfile, doneProfile);
                }
            } else {
                self.setStopped(true);
            }
            if (self.isStopped()) {
                wasStoppedProfile.enter(inliningTarget);
                throw NextNode.iteratorExhausted();
            }
            Object[] ret = new Object[self.getLst().length];
            PythonUtils.arraycopy(self.getLst(), 0, ret, 0, ret.length);
            return PFactory.createTuple(language, ret);
        }

        @Specialization(guards={"self.isStopped()"})
        static Object nextStopped(PProduct self) {
            throw NextNode.iteratorExhausted();
        }

        private static void rotatePreviousGear(Node inliningTarget, PProduct self, InlinedLoopConditionProfile loopProfile, InlinedBranchProfile doneProfile) {
            Object[] lst = self.getLst();
            Object[][] gears = self.getGears();
            int x = gears.length - 1;
            lst[x] = gears[x][0];
            int[] indices = self.getIndices();
            indices[x] = 0;
            --x;
            while (loopProfile.profile(inliningTarget, x >= 0)) {
                int index = indices[x] + 1;
                Object[] gear = gears[x];
                if (index < gear.length) {
                    doneProfile.enter(inliningTarget);
                    lst[x] = gear[index];
                    indices[x] = index;
                    return;
                }
                lst[x] = gear[0];
                indices[x] = 0;
                --x;
            }
            self.setLst(null);
            self.setStopped(true);
        }

        protected static boolean hasLst(PProduct self) {
            return self.getLst() != null;
        }
    }

    @Slot(value=Slot.SlotKind.tp_iter, isComplex=true)
    @GenerateNodeFactory
    public static abstract class IterNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object iter(PProduct self) {
            return self;
        }
    }

    @Slot(value=Slot.SlotKind.tp_new, isComplex=true)
    @Slot.SlotSignature(name="product", minNumOfPositionalArgs=1, takesVarArgs=true, keywordOnlyNames={"repeat"})
    @GenerateNodeFactory
    public static abstract class ProductNode
    extends PythonBuiltinNode {
        @Specialization(guards={"isTypeNode.execute(inliningTarget, cls)"})
        static Object constructNoneRepeat(VirtualFrame frame, Object cls, Object[] iterables, PNone repeat, @Bind Node inliningTarget, @Cached.Shared @Cached IteratorNodes.ToArrayNode toArrayNode, @Cached.Shared(value="typeNode") @Cached TypeNodes.IsTypeNode isTypeNode, @Bind PythonLanguage language, @Cached.Shared @Cached TypeNodes.GetInstanceShape getInstanceShape) {
            PProduct self = PFactory.createProduct(language, cls, getInstanceShape.execute(cls));
            ProductNode.constructOneRepeat(frame, self, iterables, toArrayNode);
            return self;
        }

        @Specialization(guards={"isTypeNode.execute(inliningTarget, cls)", "repeat == 1"}, limit="1")
        static Object constructOneRepeat(VirtualFrame frame, Object cls, Object[] iterables, int repeat, @Bind Node inliningTarget, @Cached.Shared @Cached IteratorNodes.ToArrayNode toArrayNode, @Cached.Exclusive @Cached TypeNodes.IsTypeNode isTypeNode, @Bind PythonLanguage language, @Cached.Shared @Cached TypeNodes.GetInstanceShape getInstanceShape) {
            PProduct self = PFactory.createProduct(language, cls, getInstanceShape.execute(cls));
            ProductNode.constructOneRepeat(frame, self, iterables, toArrayNode);
            return self;
        }

        @Specialization(guards={"isTypeNode.execute(inliningTarget, cls)", "repeat > 1"}, limit="1")
        static Object construct(VirtualFrame frame, Object cls, Object[] iterables, int repeat, @Bind Node inliningTarget, @Cached.Shared @Cached IteratorNodes.ToArrayNode toArrayNode, @Cached InlinedLoopConditionProfile loopProfile, @Cached.Exclusive @Cached TypeNodes.IsTypeNode isTypeNode, @Bind PythonLanguage language, @Cached.Shared @Cached TypeNodes.GetInstanceShape getInstanceShape) {
            Object[][] lists = ProductNode.unpackIterables(frame, iterables, toArrayNode);
            Object[][] gears = new Object[lists.length * repeat][];
            loopProfile.profileCounted(inliningTarget, (long)repeat);
            LoopNode.reportLoopCount((Node)inliningTarget, (int)repeat);
            int i = 0;
            while (loopProfile.inject(inliningTarget, i < repeat)) {
                PythonUtils.arraycopy(lists, 0, gears, i * lists.length, lists.length);
                ++i;
            }
            PProduct self = PFactory.createProduct(language, cls, getInstanceShape.execute(cls));
            ProductNode.construct(self, gears);
            return self;
        }

        @Specialization(guards={"isTypeNode.execute(inliningTarget, cls)", "repeat == 0"}, limit="1")
        static Object constructNoRepeat(Object cls, Object[] iterables, int repeat, @Bind Node inliningTarget, @Cached.Exclusive @Cached TypeNodes.IsTypeNode isTypeNode, @Bind PythonLanguage language, @Cached.Shared @Cached TypeNodes.GetInstanceShape getInstanceShape) {
            PProduct self = PFactory.createProduct(language, cls, getInstanceShape.execute(cls));
            self.setGears(new Object[0][]);
            self.setIndices(new int[0]);
            self.setLst(null);
            self.setStopped(false);
            return self;
        }

        @Specialization(guards={"isTypeNode.execute(inliningTarget, cls)", "repeat < 0"}, limit="1")
        static Object constructNeg(Object cls, Object[] iterables, int repeat, @Bind Node inliningTarget, @Cached.Exclusive @Cached TypeNodes.IsTypeNode isTypeNode) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.ARG_CANNOT_BE_NEGATIVE, "repeat");
        }

        private static void constructOneRepeat(VirtualFrame frame, PProduct self, Object[] iterables, IteratorNodes.ToArrayNode toArrayNode) {
            Object[][] gears = ProductNode.unpackIterables(frame, iterables, toArrayNode);
            ProductNode.construct(self, gears);
        }

        private static void construct(PProduct self, Object[][] gears) {
            self.setGears(gears);
            for (int i = 0; i < gears.length; ++i) {
                if (gears[i].length != 0) continue;
                self.setIndices(null);
                self.setLst(null);
                self.setStopped(true);
                return;
            }
            self.setIndices(new int[gears.length]);
            self.setLst(null);
            self.setStopped(false);
        }

        private static Object[][] unpackIterables(VirtualFrame frame, Object[] iterables, IteratorNodes.ToArrayNode toArrayNode) {
            Object[][] lists = new Object[iterables.length][];
            for (int i = 0; i < lists.length; ++i) {
                lists[i] = toArrayNode.execute(frame, iterables[i]);
            }
            return lists;
        }

        @Specialization(guards={"!isTypeNode.execute(inliningTarget, cls)"})
        static Object construct(Object cls, Object iterables, Object repeat, @Bind Node inliningTarget, @Cached.Shared(value="typeNode") @Cached TypeNodes.IsTypeNode isTypeNode) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.IS_NOT_TYPE_OBJ, "'cls'", cls);
        }
    }
}

