/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api.types.vectors;

import java.nio.ShortBuffer;
import uk.ac.manchester.tornado.api.internal.annotations.Payload;
import uk.ac.manchester.tornado.api.internal.annotations.Vector;
import uk.ac.manchester.tornado.api.math.TornadoMath;
import uk.ac.manchester.tornado.api.types.vectors.TornadoVectorsInterface;

@Vector
public final class Short2
implements TornadoVectorsInterface<ShortBuffer> {
    public static final Class<Short2> TYPE = Short2.class;
    private static final int NUM_ELEMENTS = 2;
    @Payload
    private final short[] storage;

    private Short2(short[] nativeVectorShort) {
        this.storage = nativeVectorShort;
    }

    public Short2() {
        this(new short[2]);
    }

    public Short2(short x, short y) {
        this();
        this.setX(x);
        this.setY(y);
    }

    public static Short2 add(Short2 a, Short2 b) {
        return new Short2((short)(a.getX() + b.getX()), (short)(a.getY() + b.getY()));
    }

    public static Short2 sub(Short2 a, Short2 b) {
        return new Short2((short)(a.getX() - b.getX()), (short)(a.getY() - b.getY()));
    }

    public static Short2 div(Short2 a, Short2 b) {
        return new Short2((short)(a.getX() / b.getX()), (short)(a.getY() / b.getY()));
    }

    public static Short2 mult(Short2 a, Short2 b) {
        return new Short2((short)(a.getX() * b.getX()), (short)(a.getY() * b.getY()));
    }

    public static Short2 min(Short2 a, Short2 b) {
        return new Short2(TornadoMath.min(a.getX(), b.getX()), TornadoMath.min(a.getY(), b.getY()));
    }

    public static Short2 max(Short2 a, Short2 b) {
        return new Short2(TornadoMath.max(a.getX(), b.getX()), TornadoMath.max(a.getY(), b.getY()));
    }

    public static Short2 add(Short2 a, short b) {
        return new Short2((short)(a.getX() + b), (short)(a.getY() + b));
    }

    public static Short2 sub(Short2 a, short b) {
        return new Short2((short)(a.getX() - b), (short)(a.getY() - b));
    }

    public static Short2 mult(Short2 a, short b) {
        return new Short2((short)(a.getX() * b), (short)(a.getY() * b));
    }

    public static Short2 div(Short2 a, short b) {
        return new Short2((short)(a.getX() / b), (short)(a.getY() / b));
    }

    public static Short2 inc(Short2 a, short value) {
        return Short2.add(a, value);
    }

    public static Short2 dec(Short2 a, short value) {
        return Short2.sub(a, value);
    }

    public static Short2 scale(Short2 a, short value) {
        return Short2.mult(a, value);
    }

    public static Short2 clamp(Short2 x, short min, short max) {
        return new Short2(TornadoMath.clamp(x.getX(), min, max), TornadoMath.clamp(x.getY(), min, max));
    }

    public static short min(Short2 value) {
        return TornadoMath.min(value.getX(), value.getY());
    }

    public static short max(Short2 value) {
        return TornadoMath.max(value.getX(), value.getY());
    }

    public static boolean isEqual(Short2 a, Short2 b) {
        return TornadoMath.isEqual(a.toArray(), b.toArray());
    }

    public short get(int index) {
        return this.storage[index];
    }

    public void set(int index, short value) {
        this.storage[index] = value;
    }

    public void set(Short2 value) {
        this.setX(value.getX());
        this.setY(value.getY());
    }

    public short getX() {
        return this.get(0);
    }

    public void setX(short value) {
        this.set(0, value);
    }

    public short getY() {
        return this.get(1);
    }

    public void setY(short value) {
        this.set(1, value);
    }

    public Short2 duplicate() {
        Short2 vector = new Short2();
        vector.set(this);
        return vector;
    }

    public String toString(String fmt) {
        return String.format(fmt, this.getX(), this.getY());
    }

    public String toString() {
        return this.toString("{%3d,%3d}");
    }

    @Override
    public void loadFromBuffer(ShortBuffer buffer) {
        this.asBuffer().put(buffer);
    }

    @Override
    public ShortBuffer asBuffer() {
        return ShortBuffer.wrap(this.storage);
    }

    @Override
    public int size() {
        return 2;
    }

    public short[] toArray() {
        return this.storage;
    }

    @Override
    public long getNumBytes() {
        return 4L;
    }
}

