/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api.types.vectors;

import java.nio.IntBuffer;
import uk.ac.manchester.tornado.api.exceptions.TornadoRuntimeException;
import uk.ac.manchester.tornado.api.internal.annotations.Payload;
import uk.ac.manchester.tornado.api.internal.annotations.Vector;
import uk.ac.manchester.tornado.api.math.TornadoMath;
import uk.ac.manchester.tornado.api.types.vectors.Int4;
import uk.ac.manchester.tornado.api.types.vectors.TornadoVectorsInterface;

@Vector
public final class Int8
implements TornadoVectorsInterface<IntBuffer> {
    public static final Class<Int8> TYPE = Int8.class;
    private static final int NUM_ELEMENTS = 8;
    @Payload
    private final int[] storage;

    private Int8(int[] storage) {
        this.storage = storage;
    }

    public Int8() {
        this(new int[8]);
    }

    public Int8(int s0, int s1, int s2, int s3, int s4, int s5, int s6, int s7) {
        this();
        this.setS0(s0);
        this.setS1(s1);
        this.setS2(s2);
        this.setS3(s3);
        this.setS4(s4);
        this.setS5(s5);
        this.setS6(s6);
        this.setS7(s7);
    }

    public static Int8 add(Int8 a, Int8 b) {
        Int8 result = new Int8();
        for (int i = 0; i < 8; ++i) {
            result.set(i, a.get(i) + b.get(i));
        }
        return result;
    }

    public static Int8 add(Int8 a, int b) {
        Int8 result = new Int8();
        for (int i = 0; i < 8; ++i) {
            result.set(i, a.get(i) + b);
        }
        return result;
    }

    public static Int8 sub(Int8 a, Int8 b) {
        Int8 result = new Int8();
        for (int i = 0; i < 8; ++i) {
            result.set(i, a.get(i) - b.get(i));
        }
        return result;
    }

    public static Int8 sub(Int8 a, int b) {
        Int8 result = new Int8();
        for (int i = 0; i < 8; ++i) {
            result.set(i, a.get(i) - b);
        }
        return result;
    }

    public static Int8 div(Int8 a, Int8 b) {
        Int8 result = new Int8();
        for (int i = 0; i < 8; ++i) {
            result.set(i, a.get(i) / b.get(i));
        }
        return result;
    }

    public static Int8 div(Int8 a, int value) {
        Int8 result = new Int8();
        for (int i = 0; i < 8; ++i) {
            result.set(i, a.get(i) / value);
        }
        return result;
    }

    public static Int8 mult(Int8 a, Int8 b) {
        Int8 result = new Int8();
        for (int i = 0; i < 8; ++i) {
            result.set(i, a.get(i) * b.get(i));
        }
        return result;
    }

    public static Int8 mult(Int8 a, int value) {
        Int8 result = new Int8();
        for (int i = 0; i < 8; ++i) {
            result.set(i, a.get(i) * value);
        }
        return result;
    }

    public static Int8 min(Int8 a, Int8 b) {
        Int8 result = new Int8();
        for (int i = 0; i < 8; ++i) {
            result.set(i, Math.min(a.get(i), b.get(i)));
        }
        return result;
    }

    public static int min(Int8 value) {
        int result = Integer.MAX_VALUE;
        for (int i = 0; i < 8; ++i) {
            result = Math.min(result, value.get(i));
        }
        return result;
    }

    public static Int8 max(Int8 a, Int8 b) {
        Int8 result = new Int8();
        for (int i = 0; i < 8; ++i) {
            result.set(i, Math.max(a.get(i), b.get(i)));
        }
        return result;
    }

    public static int max(Int8 value) {
        int result = Integer.MIN_VALUE;
        for (int i = 0; i < 8; ++i) {
            result = Math.max(result, value.get(i));
        }
        return result;
    }

    public static Int8 sqrt(Int8 a) {
        Int8 result = new Int8();
        for (int i = 0; i < 8; ++i) {
            a.set(i, (int)TornadoMath.sqrt(a.get(i)));
        }
        return result;
    }

    public static int dot(Int8 a, Int8 b) {
        Int8 m = Int8.mult(a, b);
        return m.getS0() + m.getS1() + m.getS2() + m.getS3() + m.getS4() + m.getS5() + m.getS6() + m.getS7();
    }

    public static boolean isEqual(Int8 a, Int8 b) {
        return TornadoMath.isEqual(a.toArray(), b.toArray());
    }

    public int[] toArray() {
        return this.storage;
    }

    public int get(int index) {
        return this.storage[index];
    }

    public void set(int index, int value) {
        this.storage[index] = value;
    }

    public void set(Int8 value) {
        for (int i = 0; i < 8; ++i) {
            this.set(i, value.get(i));
        }
    }

    public int getS0() {
        return this.get(0);
    }

    public void setS0(int value) {
        this.set(0, value);
    }

    public int getS1() {
        return this.get(1);
    }

    public void setS1(int value) {
        this.set(1, value);
    }

    public int getS2() {
        return this.get(2);
    }

    public void setS2(int value) {
        this.set(2, value);
    }

    public int getS3() {
        return this.get(3);
    }

    public void setS3(int value) {
        this.set(3, value);
    }

    public int getS4() {
        return this.get(4);
    }

    public void setS4(int value) {
        this.set(4, value);
    }

    public int getS5() {
        return this.get(5);
    }

    public void setS5(int value) {
        this.set(5, value);
    }

    public int getS6() {
        return this.get(6);
    }

    public void setS6(int value) {
        this.set(6, value);
    }

    public int getS7() {
        return this.get(7);
    }

    public void setS7(int value) {
        this.set(7, value);
    }

    public Int4 getHigh() {
        return new Int4(this.getS4(), this.getS5(), this.getS6(), this.getS7());
    }

    public Int4 getLow() {
        return new Int4(this.getS0(), this.getS1(), this.getS2(), this.getS3());
    }

    public Int8 duplicate() {
        Int8 vector = new Int8();
        vector.set(this);
        return vector;
    }

    public String toString(String fmt) {
        return String.format(fmt, this.getS0(), this.getS1(), this.getS2(), this.getS3(), this.getS4(), this.getS5(), this.getS6(), this.getS7());
    }

    public String toString() {
        return this.toString("{%d,%d,%d,%d,%d,%d,%d,%d}");
    }

    @Override
    public void loadFromBuffer(IntBuffer buffer) {
        throw new TornadoRuntimeException("Not implemented");
    }

    @Override
    public IntBuffer asBuffer() {
        return IntBuffer.wrap(this.storage);
    }

    @Override
    public int size() {
        return 8;
    }

    @Override
    public long getNumBytes() {
        return 32L;
    }
}

