/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api.types.vectors;

import java.nio.ShortBuffer;
import uk.ac.manchester.tornado.api.internal.annotations.Payload;
import uk.ac.manchester.tornado.api.internal.annotations.Vector;
import uk.ac.manchester.tornado.api.types.HalfFloat;
import uk.ac.manchester.tornado.api.types.vectors.TornadoVectorsInterface;

@Vector
public final class Half16
implements TornadoVectorsInterface<ShortBuffer> {
    public static final Class<Half16> TYPE = Half16.class;
    private static final int NUM_ELEMENTS = 16;
    @Payload
    short[] storage = new short[16];

    private Half16(HalfFloat[] storage) {
        for (int i = 0; i < 16; ++i) {
            this.storage[i] = storage[i].getHalfFloatValue();
        }
    }

    public Half16() {
        this.storage = new short[16];
    }

    public Half16(HalfFloat s0, HalfFloat s1, HalfFloat s2, HalfFloat s3, HalfFloat s4, HalfFloat s5, HalfFloat s6, HalfFloat s7, HalfFloat s8, HalfFloat s9, HalfFloat s10, HalfFloat s11, HalfFloat s12, HalfFloat s13, HalfFloat s14, HalfFloat s15) {
        this();
        this.setS0(s0);
        this.setS1(s1);
        this.setS2(s2);
        this.setS3(s3);
        this.setS4(s4);
        this.setS5(s5);
        this.setS6(s6);
        this.setS7(s7);
        this.setS8(s8);
        this.setS9(s9);
        this.setS10(s10);
        this.setS11(s11);
        this.setS12(s12);
        this.setS13(s13);
        this.setS14(s14);
        this.setS15(s15);
    }

    public static Half16 add(Half16 a, Half16 b) {
        Half16 result = new Half16();
        for (int i = 0; i < 16; ++i) {
            result.set(i, HalfFloat.add(a.get(i), b.get(i)));
        }
        return result;
    }

    public static Half16 add(Half16 a, HalfFloat b) {
        Half16 result = new Half16();
        for (int i = 0; i < 16; ++i) {
            result.set(i, HalfFloat.add(a.get(i), b));
        }
        return result;
    }

    public static Half16 sub(Half16 a, Half16 b) {
        Half16 result = new Half16();
        for (int i = 0; i < 16; ++i) {
            result.set(i, HalfFloat.sub(a.get(i), b.get(i)));
        }
        return result;
    }

    public static Half16 sub(Half16 a, HalfFloat b) {
        Half16 result = new Half16();
        for (int i = 0; i < 16; ++i) {
            result.set(i, HalfFloat.sub(a.get(i), b));
        }
        return result;
    }

    public static Half16 div(Half16 a, Half16 b) {
        Half16 result = new Half16();
        for (int i = 0; i < 16; ++i) {
            result.set(i, HalfFloat.div(a.get(i), b.get(i)));
        }
        return result;
    }

    public static Half16 div(Half16 a, HalfFloat value) {
        Half16 result = new Half16();
        for (int i = 0; i < 16; ++i) {
            result.set(i, HalfFloat.div(a.get(i), value));
        }
        return result;
    }

    public static Half16 mult(Half16 a, Half16 b) {
        Half16 result = new Half16();
        for (int i = 0; i < 16; ++i) {
            result.set(i, HalfFloat.mult(a.get(i), b.get(i)));
        }
        return result;
    }

    public static Half16 mult(Half16 a, HalfFloat value) {
        Half16 result = new Half16();
        for (int i = 0; i < 16; ++i) {
            result.set(i, HalfFloat.mult(a.get(i), value));
        }
        return result;
    }

    public static HalfFloat dot(Half16 a, Half16 b) {
        Half16 m = Half16.mult(a, b);
        return HalfFloat.add(HalfFloat.add(HalfFloat.add(HalfFloat.add(m.getS0(), m.getS1()), HalfFloat.add(m.getS2(), m.getS3())), HalfFloat.add(HalfFloat.add(m.getS4(), m.getS5()), HalfFloat.add(m.getS6(), m.getS7()))), HalfFloat.add(HalfFloat.add(HalfFloat.add(m.getS8(), m.getS9()), HalfFloat.add(m.getS10(), m.getS11())), HalfFloat.add(HalfFloat.add(m.getS12(), m.getS13()), HalfFloat.add(m.getS14(), m.getS15()))));
    }

    public HalfFloat get(int index) {
        return new HalfFloat(this.storage[index]);
    }

    public void set(int index, HalfFloat value) {
        this.storage[index] = value.getHalfFloatValue();
    }

    public HalfFloat getS0() {
        return this.get(0);
    }

    public void setS0(HalfFloat value) {
        this.set(0, value);
    }

    public HalfFloat getS1() {
        return this.get(1);
    }

    public void setS1(HalfFloat value) {
        this.set(1, value);
    }

    public HalfFloat getS2() {
        return this.get(2);
    }

    public void setS2(HalfFloat value) {
        this.set(2, value);
    }

    public HalfFloat getS3() {
        return this.get(3);
    }

    public void setS3(HalfFloat value) {
        this.set(3, value);
    }

    public HalfFloat getS4() {
        return this.get(4);
    }

    public void setS4(HalfFloat value) {
        this.set(4, value);
    }

    public HalfFloat getS5() {
        return this.get(5);
    }

    public void setS5(HalfFloat value) {
        this.set(5, value);
    }

    public HalfFloat getS6() {
        return this.get(6);
    }

    public void setS6(HalfFloat value) {
        this.set(6, value);
    }

    public HalfFloat getS7() {
        return this.get(7);
    }

    public void setS7(HalfFloat value) {
        this.set(7, value);
    }

    public HalfFloat getS8() {
        return this.get(8);
    }

    public void setS8(HalfFloat value) {
        this.set(8, value);
    }

    public HalfFloat getS9() {
        return this.get(9);
    }

    public void setS9(HalfFloat value) {
        this.set(9, value);
    }

    public HalfFloat getS10() {
        return this.get(10);
    }

    public void setS10(HalfFloat value) {
        this.set(10, value);
    }

    public HalfFloat getS11() {
        return this.get(11);
    }

    public void setS11(HalfFloat value) {
        this.set(11, value);
    }

    public HalfFloat getS12() {
        return this.get(12);
    }

    public void setS12(HalfFloat value) {
        this.set(12, value);
    }

    public HalfFloat getS13() {
        return this.get(13);
    }

    public void setS13(HalfFloat value) {
        this.set(13, value);
    }

    public HalfFloat getS14() {
        return this.get(14);
    }

    public void setS14(HalfFloat value) {
        this.set(14, value);
    }

    public HalfFloat getS15() {
        return this.get(15);
    }

    public void setS15(HalfFloat value) {
        this.set(15, value);
    }

    public void set(Half16 value) {
        for (int i = 0; i < 16; ++i) {
            this.set(i, value.get(i));
        }
    }

    public String toString(String fmt) {
        return String.format(fmt, Float.valueOf(this.getS0().getFloat32()), Float.valueOf(this.getS1().getFloat32()), Float.valueOf(this.getS2().getFloat32()), Float.valueOf(this.getS3().getFloat32()), Float.valueOf(this.getS4().getFloat32()), Float.valueOf(this.getS5().getFloat32()), Float.valueOf(this.getS6().getFloat32()), Float.valueOf(this.getS7().getFloat32()), Float.valueOf(this.getS8().getFloat32()), Float.valueOf(this.getS9().getFloat32()), Float.valueOf(this.getS10().getFloat32()), Float.valueOf(this.getS11().getFloat32()), Float.valueOf(this.getS12().getFloat32()), Float.valueOf(this.getS13().getFloat32()), Float.valueOf(this.getS13().getFloat32()), Float.valueOf(this.getS14().getFloat32()), Float.valueOf(this.getS15().getFloat32()));
    }

    public String toString() {
        return this.toString("{%.3f,%.3f,%.3f,%.3f,%.3f,%.3f,%.3f,%.3f,%.3f,%.3f,%.3f,%.3f,%.3f,%.3f,%.3f,%.3f}");
    }

    @Override
    public void loadFromBuffer(ShortBuffer buffer) {
        this.asBuffer().put(buffer);
    }

    @Override
    public ShortBuffer asBuffer() {
        return ShortBuffer.wrap(this.storage);
    }

    @Override
    public int size() {
        return 16;
    }

    public short[] toArray() {
        return this.storage;
    }

    @Override
    public long getNumBytes() {
        return 32L;
    }
}

