/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api.types.tensors;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.nio.ShortBuffer;
import java.util.Arrays;
import uk.ac.manchester.tornado.api.internal.annotations.SegmentElementSize;
import uk.ac.manchester.tornado.api.types.arrays.ShortArray;
import uk.ac.manchester.tornado.api.types.arrays.TornadoNativeArray;
import uk.ac.manchester.tornado.api.types.tensors.DType;
import uk.ac.manchester.tornado.api.types.tensors.Shape;
import uk.ac.manchester.tornado.api.types.tensors.Tensor;

@SegmentElementSize(size=2)
public final class TensorInt16
extends Tensor {
    private static final int SHORT_BYTES = 2;
    private final DType dType;
    private final Shape shape;
    private final ShortArray tensorStorage;
    private int numberOfElements;

    public TensorInt16(Shape shape) {
        super(DType.HALF_FLOAT, shape);
        this.shape = shape;
        this.numberOfElements = shape.getSize();
        this.dType = DType.HALF_FLOAT;
        this.tensorStorage = new ShortArray(this.numberOfElements);
    }

    public void init(short value) {
        for (int i = 0; i < this.getSize(); ++i) {
            this.tensorStorage.getSegmentWithHeader().setAtIndex(ValueLayout.JAVA_SHORT, this.getBaseIndex() + (long)i, value);
        }
    }

    public void set(int index, short value) {
        this.tensorStorage.getSegmentWithHeader().setAtIndex(ValueLayout.JAVA_SHORT, this.getBaseIndex() + (long)index, value);
    }

    private long getBaseIndex() {
        return (int)TornadoNativeArray.ARRAY_HEADER / 2;
    }

    public short get(int index) {
        return this.tensorStorage.getSegmentWithHeader().getAtIndex(ValueLayout.JAVA_SHORT, this.getBaseIndex() + (long)index);
    }

    @Override
    public int getSize() {
        return this.numberOfElements;
    }

    @Override
    public MemorySegment getSegment() {
        return this.tensorStorage.getSegment();
    }

    @Override
    public MemorySegment getSegmentWithHeader() {
        return this.tensorStorage.getSegmentWithHeader();
    }

    @Override
    public long getNumBytesOfSegmentWithHeader() {
        return this.tensorStorage.getNumBytesOfSegmentWithHeader();
    }

    @Override
    public long getNumBytesOfSegment() {
        return this.tensorStorage.getNumBytesOfSegment();
    }

    @Override
    protected void clear() {
        this.init((short)0);
    }

    @Override
    public int getElementSize() {
        return 2;
    }

    @Override
    public Shape getShape() {
        return this.shape;
    }

    @Override
    public String getDTypeAsString() {
        return this.dType.toString();
    }

    @Override
    public DType getDType() {
        return this.dType;
    }

    public ShortBuffer getShortBuffer() {
        return this.getSegment().asByteBuffer().asShortBuffer();
    }

    public static void initialize(TensorInt16 tensor, short value) {
        for (int i = 0; i < tensor.getSize(); ++i) {
            tensor.set(i, value);
        }
    }

    public static TensorInt16 concat(TensorInt16 ... arrays) {
        int newSize = Arrays.stream(arrays).mapToInt(TensorInt16::getSize).sum();
        TensorInt16 concatArray = new TensorInt16(new Shape(newSize));
        long currentPositionBytes = 0L;
        for (TensorInt16 array : arrays) {
            MemorySegment.copy(array.getSegment(), 0L, concatArray.getSegment(), currentPositionBytes, array.getNumBytesOfSegment());
            currentPositionBytes += array.getNumBytesOfSegment();
        }
        return concatArray;
    }
}

