/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api.types.tensors;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.nio.DoubleBuffer;
import java.util.Arrays;
import uk.ac.manchester.tornado.api.internal.annotations.SegmentElementSize;
import uk.ac.manchester.tornado.api.types.arrays.DoubleArray;
import uk.ac.manchester.tornado.api.types.arrays.TornadoNativeArray;
import uk.ac.manchester.tornado.api.types.tensors.DType;
import uk.ac.manchester.tornado.api.types.tensors.Shape;
import uk.ac.manchester.tornado.api.types.tensors.Tensor;

@SegmentElementSize(size=8)
public final class TensorFP64
extends Tensor {
    private static final int DOUBLE_BYTES = 8;
    private final DType dType;
    private final Shape shape;
    private final DoubleArray tensorStorage;
    private int numberOfElements;

    public TensorFP64(Shape shape) {
        super(DType.DOUBLE, shape);
        this.shape = shape;
        this.numberOfElements = shape.getSize();
        this.dType = DType.DOUBLE;
        this.tensorStorage = new DoubleArray(this.numberOfElements);
    }

    public void init(double value) {
        for (int i = 0; i < this.getSize(); ++i) {
            this.tensorStorage.getSegmentWithHeader().setAtIndex(ValueLayout.JAVA_DOUBLE, this.getBaseIndex() + (long)i, value);
        }
    }

    public void set(int index, double value) {
        this.tensorStorage.getSegmentWithHeader().setAtIndex(ValueLayout.JAVA_DOUBLE, this.getBaseIndex() + (long)index, value);
    }

    private long getBaseIndex() {
        return (int)TornadoNativeArray.ARRAY_HEADER / 8;
    }

    public double get(int index) {
        return this.tensorStorage.getSegmentWithHeader().getAtIndex(ValueLayout.JAVA_DOUBLE, this.getBaseIndex() + (long)index);
    }

    @Override
    public int getSize() {
        return this.numberOfElements;
    }

    @Override
    public MemorySegment getSegment() {
        return this.tensorStorage.getSegment();
    }

    @Override
    public MemorySegment getSegmentWithHeader() {
        return this.tensorStorage.getSegmentWithHeader();
    }

    @Override
    public long getNumBytesOfSegmentWithHeader() {
        return this.tensorStorage.getNumBytesOfSegmentWithHeader();
    }

    @Override
    public long getNumBytesOfSegment() {
        return this.tensorStorage.getNumBytesOfSegment();
    }

    @Override
    protected void clear() {
        this.init(0.0);
    }

    @Override
    public int getElementSize() {
        return 8;
    }

    @Override
    public Shape getShape() {
        return this.shape;
    }

    @Override
    public String getDTypeAsString() {
        return this.dType.toString();
    }

    @Override
    public DType getDType() {
        return this.dType;
    }

    public DoubleBuffer getDoubleBuffer() {
        return this.getSegment().asByteBuffer().asDoubleBuffer();
    }

    public static void initialize(TensorFP64 tensor, short value) {
        for (int i = 0; i < tensor.getSize(); ++i) {
            tensor.set(i, value);
        }
    }

    public static TensorFP64 concat(TensorFP64 ... arrays) {
        int newSize = Arrays.stream(arrays).mapToInt(TensorFP64::getSize).sum();
        TensorFP64 concatArray = new TensorFP64(new Shape(newSize));
        long currentPositionBytes = 0L;
        for (TensorFP64 array : arrays) {
            MemorySegment.copy(array.getSegment(), 0L, concatArray.getSegment(), currentPositionBytes, array.getNumBytesOfSegment());
            currentPositionBytes += array.getNumBytesOfSegment();
        }
        return concatArray;
    }
}

