/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api.types.tensors;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.util.Arrays;
import uk.ac.manchester.tornado.api.internal.annotations.SegmentElementSize;
import uk.ac.manchester.tornado.api.types.HalfFloat;
import uk.ac.manchester.tornado.api.types.arrays.HalfFloatArray;
import uk.ac.manchester.tornado.api.types.arrays.TornadoNativeArray;
import uk.ac.manchester.tornado.api.types.tensors.DType;
import uk.ac.manchester.tornado.api.types.tensors.Shape;
import uk.ac.manchester.tornado.api.types.tensors.Tensor;

@SegmentElementSize(size=2)
public final class TensorFP16
extends Tensor {
    private static final int HALF_FLOAT_BYTES = 2;
    private final DType dType;
    private final Shape shape;
    private final HalfFloatArray tensorStorage;
    private int numberOfElements;

    public TensorFP16(Shape shape) {
        super(DType.HALF_FLOAT, shape);
        this.shape = shape;
        this.numberOfElements = shape.getSize();
        this.dType = DType.HALF_FLOAT;
        this.tensorStorage = new HalfFloatArray(this.numberOfElements);
    }

    public void init(HalfFloat value) {
        for (int i = 0; i < this.getSize(); ++i) {
            this.tensorStorage.getSegmentWithHeader().setAtIndex(ValueLayout.JAVA_SHORT, this.getBaseIndex() + (long)i, value.getHalfFloatValue());
        }
    }

    public void set(int index, HalfFloat value) {
        this.tensorStorage.getSegmentWithHeader().setAtIndex(ValueLayout.JAVA_SHORT, this.getBaseIndex() + (long)index, value.getHalfFloatValue());
    }

    private long getBaseIndex() {
        return (int)TornadoNativeArray.ARRAY_HEADER / 2;
    }

    public HalfFloat get(int index) {
        short halfFloatValue = this.tensorStorage.getSegmentWithHeader().getAtIndex(ValueLayout.JAVA_SHORT, this.getBaseIndex() + (long)index);
        return new HalfFloat(halfFloatValue);
    }

    @Override
    public int getSize() {
        return this.numberOfElements;
    }

    @Override
    public MemorySegment getSegment() {
        return this.tensorStorage.getSegment();
    }

    @Override
    public MemorySegment getSegmentWithHeader() {
        return this.tensorStorage.getSegmentWithHeader();
    }

    @Override
    public long getNumBytesOfSegmentWithHeader() {
        return this.tensorStorage.getNumBytesOfSegmentWithHeader();
    }

    @Override
    public long getNumBytesOfSegment() {
        return this.tensorStorage.getNumBytesOfSegment();
    }

    @Override
    protected void clear() {
        this.init(new HalfFloat(0.0f));
    }

    @Override
    public int getElementSize() {
        return 2;
    }

    @Override
    public Shape getShape() {
        return this.shape;
    }

    @Override
    public String getDTypeAsString() {
        return this.dType.toString();
    }

    @Override
    public DType getDType() {
        return this.dType;
    }

    public static void initialize(TensorFP16 tensor, HalfFloat value) {
        for (int i = 0; i < tensor.getSize(); ++i) {
            tensor.set(i, value);
        }
    }

    public static TensorFP16 concat(TensorFP16 ... arrays) {
        int newSize = Arrays.stream(arrays).mapToInt(TensorFP16::getSize).sum();
        TensorFP16 concatArray = new TensorFP16(new Shape(newSize));
        long currentPositionBytes = 0L;
        for (TensorFP16 array : arrays) {
            MemorySegment.copy(array.getSegment(), 0L, concatArray.getSegment(), currentPositionBytes, array.getNumBytesOfSegment());
            currentPositionBytes += array.getNumBytesOfSegment();
        }
        return concatArray;
    }
}

