/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api.types.matrix;

import java.lang.foreign.MemorySegment;
import java.nio.FloatBuffer;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.api.types.matrix.TornadoMatrixInterface;
import uk.ac.manchester.tornado.api.types.utils.FloatOps;
import uk.ac.manchester.tornado.api.types.utils.FloatingPointError;
import uk.ac.manchester.tornado.api.types.vectors.Float4;

public final class Matrix4x4Float
implements TornadoMatrixInterface<FloatBuffer> {
    public static final Class<Matrix4x4Float> TYPE = Matrix4x4Float.class;
    private static final int ROWS = 4;
    private static final int COLUMNS = 4;
    private static final int NUM_ELEMENTS = 16;
    private final FloatArray storage;

    public Matrix4x4Float() {
        this(new FloatArray(16));
    }

    public Matrix4x4Float(FloatArray array) {
        this.storage = array;
    }

    private int toIndex(int i, int j) {
        return j + i * 4;
    }

    private float get(int index) {
        return this.storage.get(index);
    }

    private void set(int index, float value) {
        this.storage.set(index, value);
    }

    public float get(int i, int j) {
        return this.storage.get(this.toIndex(i, j));
    }

    public void set(int i, int j, float value) {
        this.storage.set(this.toIndex(i, j), value);
    }

    public int getNumRows() {
        return 4;
    }

    public int getNumColumns() {
        return 4;
    }

    public Float4 row(int row) {
        int offset = 4 * row;
        return this.loadFromArray(this.storage, offset);
    }

    private Float4 loadFromArray(FloatArray array, int index) {
        Float4 result = new Float4();
        result.setX(array.get(index));
        result.setY(array.get(index + 1));
        result.setZ(array.get(index + 2));
        result.setW(array.get(index + 3));
        return result;
    }

    public Float4 column(int col) {
        return new Float4(this.get(col), this.get(col + 4), this.get(col + 8), this.get(col + 12));
    }

    public Float4 diag() {
        return new Float4(this.get(0), this.get(5), this.get(10), this.get(15));
    }

    public void fill(float value) {
        this.storage.init(value);
    }

    public Matrix4x4Float duplicate() {
        Matrix4x4Float matrix = new Matrix4x4Float();
        matrix.set(this);
        return matrix;
    }

    public void set(Matrix4x4Float m) {
        for (int i = 0; i < 4; ++i) {
            int offset = 4 * i;
            this.storeToArray(m.row(i), this.storage, offset);
        }
    }

    private void storeToArray(Float4 value, FloatArray array, int index) {
        array.set(index, value.getX());
        array.set(index + 1, value.getY());
        array.set(index + 2, value.getZ());
        array.set(index + 3, value.getW());
    }

    public String toString(String fmt) {
        StringBuilder str = new StringBuilder("");
        for (int i = 0; i < 4; ++i) {
            str.append(this.row(i).toString(fmt) + "\n");
        }
        return str.toString().trim();
    }

    public String toString() {
        Object result = String.format("MatrixFloat <%d x %d>", 4, 4);
        result = (String)result + "\n" + this.toString("%.3f,%.3f,%.3f,%.3f");
        return result;
    }

    public void identity() {
        this.fill(0.0f);
        this.set(0, 1.0f);
        this.set(5, 1.0f);
        this.set(10, 1.0f);
        this.set(15, 1.0f);
    }

    @Override
    public void loadFromBuffer(FloatBuffer buffer) {
        this.asBuffer().put(buffer);
    }

    @Override
    public FloatBuffer asBuffer() {
        return FloatBuffer.wrap(this.storage.toHeapArray());
    }

    @Override
    public int size() {
        return 16;
    }

    public FloatingPointError calculateULP(Matrix4x4Float ref) {
        float maxULP = Float.MIN_VALUE;
        float minULP = Float.MAX_VALUE;
        float averageULP = 0.0f;
        if (4 != 4) {
            if (4 != 4) {
                return new FloatingPointError(-1.0f, 0.0f, 0.0f, 0.0f);
            }
        }
        for (int j = 0; j < 4; ++j) {
            for (int i = 0; i < 4; ++i) {
                float v = this.get(i, j);
                float r = ref.get(i, j);
                float ulpFactor = FloatOps.findMaxULP(v, r);
                averageULP += ulpFactor;
                minULP = Math.min(ulpFactor, minULP);
                maxULP = Math.max(ulpFactor, maxULP);
            }
        }
        return new FloatingPointError(averageULP /= 16.0f, minULP, maxULP, -1.0f);
    }

    public void clear() {
        this.storage.clear();
    }

    @Override
    public long getNumBytes() {
        return this.storage.getNumBytesOfSegment();
    }

    @Override
    public long getNumBytesWithHeader() {
        return this.storage.getNumBytesOfSegment();
    }

    @Override
    public MemorySegment getSegment() {
        return this.storage.getSegment();
    }

    @Override
    public MemorySegment getSegmentWithHeader() {
        return this.storage.getSegmentWithHeader();
    }
}

