/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api.types.matrix;

import java.lang.foreign.MemorySegment;
import java.nio.FloatBuffer;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.api.types.matrix.Matrix3DType;
import uk.ac.manchester.tornado.api.types.matrix.TornadoMatrixInterface;
import uk.ac.manchester.tornado.api.types.utils.StorageFormats;
import uk.ac.manchester.tornado.api.types.vectors.Float4;

public final class Matrix3DFloat4
extends Matrix3DType
implements TornadoMatrixInterface<FloatBuffer> {
    public static final Class<Matrix3DFloat4> TYPE = Matrix3DFloat4.class;
    private static final int VECTOR_ELEMENTS = 4;
    private final FloatArray storage;
    private final int numElements;

    public Matrix3DFloat4(int rows, int columns, int depth, FloatArray array) {
        super(rows, columns, depth);
        this.storage = array;
        this.numElements = rows * columns * depth * 4;
    }

    public Matrix3DFloat4(int rows, int columns, int depth) {
        this(rows, columns, depth, new FloatArray(rows * columns * depth * 4));
    }

    public static void scale(Matrix3DFloat4 matrix, float value) {
        for (int i = 0; i < matrix.storage.getSize(); ++i) {
            matrix.storage.set(i, matrix.storage.get(i) * value);
        }
    }

    @Override
    public void clear() {
        this.storage.clear();
    }

    public Float4 get(int i, int j, int k) {
        int baseIndex = StorageFormats.toRowMajor3DVector(i, j, k, this.DEPTH, this.COLUMNS, 4);
        return this.loadFromArray(this.storage, baseIndex);
    }

    private Float4 loadFromArray(FloatArray array, int index) {
        Float4 result = new Float4();
        result.setX(array.get(index));
        result.setY(array.get(index + 1));
        result.setZ(array.get(index + 2));
        result.setW(array.get(index + 3));
        return result;
    }

    public void set(int i, int j, int k, Float4 value) {
        int baseIndex = StorageFormats.toRowMajor3DVector(i, j, k, this.DEPTH, this.COLUMNS, 4);
        this.storeToArray(value, this.storage, baseIndex);
    }

    private void storeToArray(Float4 value, FloatArray array, int index) {
        array.set(index, value.getX());
        array.set(index + 1, value.getY());
        array.set(index + 2, value.getZ());
        array.set(index + 3, value.getW());
    }

    public void fill(float value) {
        this.storage.init(value);
    }

    public Matrix3DFloat4 duplicate() {
        Matrix3DFloat4 matrix = new Matrix3DFloat4(this.ROWS, this.COLUMNS, this.DEPTH);
        matrix.set(this);
        return matrix;
    }

    public void set(Matrix3DFloat4 m) {
        for (int i = 0; i < m.storage.getSize(); ++i) {
            this.storage.set(i, m.storage.get(i));
        }
    }

    public String toString(String fmt) {
        StringBuilder str = new StringBuilder("");
        for (int i = 0; i < this.ROWS; ++i) {
            for (int j = 0; j < this.COLUMNS; ++j) {
                for (int k = 0; k < this.DEPTH; ++k) {
                    str.append(String.format(fmt, this.get(i, j, k)) + " ");
                }
            }
            str.append("\n");
        }
        return str.toString().trim();
    }

    public String toString() {
        Object result = String.format("MatrixFloat <%d x %d x %d>", this.ROWS, this.COLUMNS, this.DEPTH);
        if (this.ROWS < 16 && this.COLUMNS < 16 && this.DEPTH < 16) {
            result = (String)result + "\n" + this.toString("%.3f");
        }
        return result;
    }

    @Override
    public void loadFromBuffer(FloatBuffer buffer) {
        this.asBuffer().put(buffer);
    }

    @Override
    public FloatBuffer asBuffer() {
        return FloatBuffer.wrap(this.storage.toHeapArray());
    }

    @Override
    public int size() {
        return this.numElements;
    }

    @Override
    public long getNumBytes() {
        return this.storage.getNumBytesOfSegment();
    }

    @Override
    public long getNumBytesWithHeader() {
        return this.storage.getNumBytesOfSegment();
    }

    @Override
    public MemorySegment getSegment() {
        return this.storage.getSegment();
    }

    @Override
    public MemorySegment getSegmentWithHeader() {
        return this.storage.getSegmentWithHeader();
    }
}

