/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api.types.images;

import java.lang.foreign.MemorySegment;
import java.nio.FloatBuffer;
import uk.ac.manchester.tornado.api.math.TornadoMath;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.api.types.images.TornadoImagesInterface;
import uk.ac.manchester.tornado.api.types.utils.FloatOps;
import uk.ac.manchester.tornado.api.types.utils.FloatingPointError;
import uk.ac.manchester.tornado.api.types.utils.StorageFormats;

public final class ImageFloat
implements TornadoImagesInterface<FloatBuffer> {
    private final FloatArray storage;
    private final int Y;
    private final int X;
    private final int numElements;
    float maxULP = Float.MIN_VALUE;
    float minULP = Float.MAX_VALUE;
    float averageULP = 0.0f;

    public ImageFloat(int width, int height, FloatArray array) {
        this.storage = array;
        this.X = width;
        this.Y = height;
        this.numElements = this.X * this.Y;
    }

    public ImageFloat(int width, int height) {
        this(width, height, new FloatArray(width * height));
    }

    public ImageFloat(float[][] matrix) {
        this(matrix.length, matrix[0].length);
    }

    public static void scale(ImageFloat image, float alpha) {
        for (int i = 0; i < image.storage.getSize(); ++i) {
            image.storage.set(i, image.storage.get(i) * alpha);
        }
    }

    public FloatArray getArray() {
        return this.storage;
    }

    public float get(int i) {
        return this.storage.get(i);
    }

    public void set(int i, float value) {
        this.storage.set(i, value);
    }

    public float get(int i, int j) {
        return this.storage.get(StorageFormats.toRowMajor(j, i, this.X));
    }

    public void set(int i, int j, float value) {
        this.storage.set(StorageFormats.toRowMajor(j, i, this.X), value);
    }

    public void put(float[] array) {
        System.arraycopy(array, 0, this.storage, 0, array.length);
    }

    public int Y() {
        return this.Y;
    }

    public int X() {
        return this.X;
    }

    public void fill(float value) {
        for (int i = 0; i < this.Y; ++i) {
            for (int j = 0; j < this.X; ++j) {
                this.set(j, i, value);
            }
        }
    }

    public ImageFloat duplicate() {
        ImageFloat matrix = new ImageFloat(this.X, this.Y);
        matrix.set(this);
        return matrix;
    }

    public void set(ImageFloat m) {
        System.arraycopy(this.storage, 0, m.storage, 0, this.storage.getSize());
    }

    public String toString(String fmt) {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < this.Y; ++i) {
            for (int j = 0; j < this.X; ++j) {
                str.append(String.format(fmt, Float.valueOf(this.get(j, i)))).append(" ");
            }
            str.append("\n");
        }
        return str.toString();
    }

    public String toString() {
        Object result = String.format("ImageFloat <%d x %d>", this.X, this.Y);
        if (this.Y < 16 && this.X < 16) {
            result = (String)result + "\n" + this.toString("%.3f");
        }
        return result;
    }

    public float mean() {
        float result = 0.0f;
        for (int i = 0; i < this.storage.getSize(); ++i) {
            result += this.storage.get(i);
        }
        return result / (float)(this.X * this.Y);
    }

    public float min() {
        float result = Float.MAX_VALUE;
        for (int i = 0; i < this.storage.getSize(); ++i) {
            result = Math.min(result, this.storage.get(i));
        }
        return result;
    }

    public float max() {
        float result = Float.MIN_VALUE;
        for (int i = 0; i < this.storage.getSize(); ++i) {
            result = Math.max(result, this.storage.get(i));
        }
        return result;
    }

    public float stdDev() {
        float mean = this.mean();
        float varience = 0.0f;
        for (int i = 0; i < this.storage.getSize(); ++i) {
            float v = this.storage.get(i);
            v -= mean;
            v *= v;
            varience = v / (float)this.X;
        }
        return TornadoMath.sqrt(varience);
    }

    public String summerise() {
        return String.format("ImageFloat<%dx%d>: min=%e, max=%e, mean=%e, sd=%e", this.X, this.Y, Float.valueOf(this.min()), Float.valueOf(this.max()), Float.valueOf(this.mean()), Float.valueOf(this.stdDev()));
    }

    @Override
    public void loadFromBuffer(FloatBuffer buffer) {
        this.asBuffer().put(buffer);
    }

    @Override
    public FloatBuffer asBuffer() {
        return FloatBuffer.wrap(this.storage.toHeapArray());
    }

    @Override
    public int size() {
        return this.numElements;
    }

    public FloatingPointError calculateULP(ImageFloat ref) {
        if (ref.X != this.X && ref.Y != this.Y) {
            return new FloatingPointError(-1.0f, 0.0f, 0.0f, 0.0f);
        }
        for (int j = 0; j < this.Y; ++j) {
            for (int i = 0; i < this.X; ++i) {
                float v = this.get(i, j);
                float r = ref.get(i, j);
                float ulpFactor = FloatOps.findMaxULP(v, r);
                this.averageULP += ulpFactor;
                this.minULP = Math.min(ulpFactor, this.minULP);
                this.maxULP = Math.max(ulpFactor, this.maxULP);
            }
        }
        this.averageULP /= (float)this.X * (float)this.Y;
        return new FloatingPointError(this.averageULP, this.minULP, this.maxULP, -1.0f);
    }

    public void clear() {
        this.storage.clear();
    }

    @Override
    public long getNumBytes() {
        return this.storage.getNumBytesOfSegment();
    }

    @Override
    public long getNumBytesWithHeader() {
        return this.storage.getNumBytesOfSegment();
    }

    @Override
    public MemorySegment getSegment() {
        return this.getArray().getSegment();
    }

    @Override
    public MemorySegment getSegmentWithHeader() {
        return this.getArray().getSegmentWithHeader();
    }
}

