/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api.types.collections;

import java.lang.foreign.MemorySegment;
import java.nio.IntBuffer;
import uk.ac.manchester.tornado.api.types.arrays.IntArray;
import uk.ac.manchester.tornado.api.types.collections.TornadoCollectionInterface;
import uk.ac.manchester.tornado.api.types.vectors.Int8;

public final class VectorInt8
implements TornadoCollectionInterface<IntBuffer> {
    public static final Class<VectorInt8> TYPE = VectorInt8.class;
    private static final int ELEMENT_SIZE = 8;
    private final IntArray storage;
    private final int numElements;

    VectorInt8(int numElements, IntArray array) {
        this.numElements = numElements;
        this.storage = array;
    }

    public VectorInt8(IntArray array) {
        this(array.getSize() / 8, array);
    }

    public VectorInt8(int numElements) {
        this(numElements, new IntArray(numElements * 8));
    }

    public int vectorWidth() {
        return 8;
    }

    private int toIndex(int index) {
        return index * 8;
    }

    public Int8 get(int index) {
        return this.loadFromArray(this.storage, this.toIndex(index));
    }

    private Int8 loadFromArray(IntArray array, int index) {
        Int8 result = new Int8();
        for (int i = 0; i < 8; ++i) {
            result.set(i, array.get(index + i));
        }
        return result;
    }

    public void set(int index, Int8 value) {
        this.storeToArray(value, this.storage, this.toIndex(index));
    }

    private void storeToArray(Int8 value, IntArray array, int index) {
        for (int i = 0; i < 8; ++i) {
            array.set(index + i, value.get(i));
        }
    }

    public void set(VectorInt8 values) {
        for (int i = 0; i < this.numElements; ++i) {
            this.set(i, values.get(i));
        }
    }

    public void set(IntArray values) {
        VectorInt8 vector = new VectorInt8(values);
        for (int i = 0; i < this.numElements; ++i) {
            this.set(i, vector.get(i));
        }
    }

    public void fill(int value) {
        for (int i = 0; i < this.storage.getSize(); ++i) {
            this.storage.set(i, value);
        }
    }

    public VectorInt8 duplicate() {
        VectorInt8 vector = new VectorInt8(this.numElements);
        vector.set(this);
        return vector;
    }

    public String toString() {
        if (this.numElements > 8) {
            return String.format("VectorInt8 <%d>", this.numElements);
        }
        StringBuilder tempString = new StringBuilder();
        for (int i = 0; i < this.numElements; ++i) {
            tempString.append(" ").append(this.get(i).toString());
        }
        return tempString.toString();
    }

    public Int8 sum() {
        Int8 result = new Int8();
        for (int i = 0; i < this.numElements; ++i) {
            result = Int8.add(result, this.get(i));
        }
        return result;
    }

    public Int8 min() {
        Int8 result = new Int8();
        for (int i = 0; i < this.numElements; ++i) {
            result = Int8.min(result, this.get(i));
        }
        return result;
    }

    public Int8 max() {
        Int8 result = new Int8();
        for (int i = 0; i < this.numElements; ++i) {
            result = Int8.max(result, this.get(i));
        }
        return result;
    }

    @Override
    public void loadFromBuffer(IntBuffer buffer) {
        this.asBuffer().put(buffer);
    }

    @Override
    public IntBuffer asBuffer() {
        return IntBuffer.wrap(this.storage.toHeapArray());
    }

    @Override
    public int size() {
        return this.storage.getSize();
    }

    public int getLength() {
        return this.numElements;
    }

    public IntArray getArray() {
        return this.storage;
    }

    public void clear() {
        this.storage.clear();
    }

    @Override
    public long getNumBytes() {
        return this.storage.getNumBytesOfSegment();
    }

    @Override
    public long getNumBytesWithHeader() {
        return this.storage.getNumBytesOfSegmentWithHeader();
    }

    @Override
    public MemorySegment getSegment() {
        return this.getArray().getSegment();
    }

    @Override
    public MemorySegment getSegmentWithHeader() {
        return this.getArray().getSegmentWithHeader();
    }
}

