/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api.types.collections;

import java.lang.foreign.MemorySegment;
import java.nio.ShortBuffer;
import uk.ac.manchester.tornado.api.types.HalfFloat;
import uk.ac.manchester.tornado.api.types.arrays.HalfFloatArray;
import uk.ac.manchester.tornado.api.types.collections.TornadoCollectionInterface;
import uk.ac.manchester.tornado.api.types.vectors.Half16;

public final class VectorHalf16
implements TornadoCollectionInterface<ShortBuffer> {
    public static final Class<VectorHalf16> TYPE = VectorHalf16.class;
    private static final int ELEMENT_SIZE = 16;
    private final int numElements;
    private final HalfFloatArray storage;

    protected VectorHalf16(int numElements, HalfFloatArray array) {
        this.numElements = numElements;
        this.storage = array;
    }

    public VectorHalf16(int numElements) {
        this(numElements, new HalfFloatArray(numElements * 16));
    }

    private VectorHalf16(HalfFloatArray array) {
        this(array.getSize() / 16, array);
    }

    public int vectorWidth() {
        return 16;
    }

    private int toIndex(int index) {
        return index * 16;
    }

    public Half16 get(int index) {
        return this.loadFromArray(this.storage, this.toIndex(index));
    }

    private Half16 loadFromArray(HalfFloatArray array, int index) {
        Half16 result = new Half16();
        for (int i = 0; i < 16; ++i) {
            result.set(i, array.get(index + i));
        }
        return result;
    }

    public void set(int index, Half16 value) {
        this.storeToArray(value, this.storage, this.toIndex(index));
    }

    private void storeToArray(Half16 value, HalfFloatArray array, int index) {
        for (int i = 0; i < 16; ++i) {
            array.set(index + i, value.get(i));
        }
    }

    public void set(VectorHalf16 values) {
        for (int i = 0; i < this.numElements; ++i) {
            this.set(i, values.get(i));
        }
    }

    public void set(HalfFloatArray values) {
        VectorHalf16 vector = new VectorHalf16(values);
        for (int i = 0; i < this.numElements; ++i) {
            this.set(i, vector.get(i));
        }
    }

    public void fill(HalfFloat value) {
        for (int i = 0; i < this.storage.getSize(); ++i) {
            this.storage.set(i, value);
        }
    }

    public VectorHalf16 duplicate() {
        VectorHalf16 vector = new VectorHalf16(this.numElements);
        vector.set(this);
        return vector;
    }

    public String toString() {
        if (this.numElements > 16) {
            return String.format("VectorHalf16 <%d>", this.numElements);
        }
        StringBuilder tempString = new StringBuilder();
        for (int i = 0; i < this.numElements; ++i) {
            tempString.append(" ").append(this.get(i).toString());
        }
        return tempString.toString();
    }

    public Half16 sum() {
        Half16 result = new Half16();
        for (int i = 0; i < this.numElements; ++i) {
            result = Half16.add(result, this.get(i));
        }
        return result;
    }

    @Override
    public void loadFromBuffer(ShortBuffer buffer) {
        this.asBuffer().put(buffer);
    }

    @Override
    public ShortBuffer asBuffer() {
        return ShortBuffer.wrap(this.storage.toShortArray());
    }

    @Override
    public int size() {
        return this.storage.getSize();
    }

    public int getLength() {
        return this.numElements;
    }

    public HalfFloatArray getArray() {
        return this.storage;
    }

    public void clear() {
        this.storage.clear();
    }

    @Override
    public long getNumBytes() {
        return this.storage.getNumBytesOfSegment();
    }

    @Override
    public long getNumBytesWithHeader() {
        return this.storage.getNumBytesOfSegmentWithHeader();
    }

    @Override
    public MemorySegment getSegment() {
        return this.getArray().getSegment();
    }

    @Override
    public MemorySegment getSegmentWithHeader() {
        return this.getArray().getSegmentWithHeader();
    }
}

