/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api.types.collections;

import java.lang.foreign.MemorySegment;
import java.nio.FloatBuffer;
import uk.ac.manchester.tornado.api.math.TornadoMath;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.api.types.collections.TornadoCollectionInterface;

public final class VectorFloat
implements TornadoCollectionInterface<FloatBuffer> {
    private static final int ELEMENT_SIZE = 1;
    private final int numElements;
    private final FloatArray storage;

    public VectorFloat(int numElements, FloatArray array) {
        this.numElements = numElements;
        this.storage = array;
    }

    public VectorFloat(int numElements) {
        this(numElements, new FloatArray(numElements));
    }

    public VectorFloat(FloatArray storage) {
        this(storage.getSize() / 1, storage);
    }

    public static float min(VectorFloat v) {
        float result = Float.MAX_VALUE;
        for (int i = 0; i < v.storage.getSize(); ++i) {
            result = Math.min(v.storage.get(i), result);
        }
        return result;
    }

    public static float max(VectorFloat v) {
        float result = Float.MIN_VALUE;
        for (int i = 0; i < v.storage.getSize(); ++i) {
            result = Math.max(v.storage.get(i), result);
        }
        return result;
    }

    public static float dot(VectorFloat a, VectorFloat b) {
        float sum = 0.0f;
        for (int i = 0; i < a.size(); ++i) {
            sum += a.get(i) * b.get(i);
        }
        return sum;
    }

    public FloatArray getArray() {
        return this.storage;
    }

    public float get(int index) {
        return this.storage.get(index);
    }

    public void set(int index, float value) {
        this.storage.set(index, value);
    }

    public void set(VectorFloat values) {
        for (int i = 0; i < values.storage.getSize(); ++i) {
            this.storage.set(i, values.storage.get(i));
        }
    }

    public void set(float[] values) {
        System.arraycopy(values, 0, this.storage, 0, values.length);
    }

    public void fill(float value) {
        this.storage.init(value);
    }

    public VectorFloat subVector(int start, int length) {
        VectorFloat v = new VectorFloat(length);
        for (int i = 0; i < length; ++i) {
            v.storage.set(i, this.storage.get(i + start));
        }
        return v;
    }

    public VectorFloat duplicate() {
        FloatArray cp = new FloatArray(this.storage.getSize());
        for (int i = 0; i < cp.getSize(); ++i) {
            cp.set(i, this.storage.get(i));
        }
        return new VectorFloat(cp);
    }

    public boolean isEqual(VectorFloat vector) {
        return TornadoMath.isEqual(this.storage, vector.storage);
    }

    public String toString(String fmt) {
        StringBuilder sb = new StringBuilder("[");
        sb.append("[ ");
        for (int i = 0; i < this.numElements; ++i) {
            sb.append(String.format(fmt, Float.valueOf(this.get(i))) + " ");
        }
        sb.append("]");
        return sb.toString();
    }

    public String toString() {
        Object str = String.format("VectorFloat <%d>", this.numElements);
        if (this.numElements < 32) {
            str = (String)str + this.toString("%.3f");
        }
        return str;
    }

    @Override
    public void loadFromBuffer(FloatBuffer buffer) {
        this.asBuffer().put(buffer);
    }

    @Override
    public FloatBuffer asBuffer() {
        return FloatBuffer.wrap(this.storage.toHeapArray());
    }

    @Override
    public int size() {
        return this.numElements;
    }

    public int getLength() {
        return this.numElements;
    }

    public void clear() {
        this.storage.clear();
    }

    @Override
    public long getNumBytes() {
        return this.storage.getNumBytesOfSegment();
    }

    @Override
    public long getNumBytesWithHeader() {
        return this.storage.getNumBytesOfSegmentWithHeader();
    }

    @Override
    public MemorySegment getSegment() {
        return this.getArray().getSegment();
    }

    @Override
    public MemorySegment getSegmentWithHeader() {
        return this.getArray().getSegmentWithHeader();
    }
}

