/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api.types.collections;

import java.lang.foreign.MemorySegment;
import java.nio.DoubleBuffer;
import uk.ac.manchester.tornado.api.types.arrays.DoubleArray;
import uk.ac.manchester.tornado.api.types.collections.TornadoCollectionInterface;
import uk.ac.manchester.tornado.api.types.vectors.Double2;

public final class VectorDouble2
implements TornadoCollectionInterface<DoubleBuffer> {
    public static final Class<VectorDouble2> TYPE = VectorDouble2.class;
    private static final int ELEMENT_SIZE = 2;
    private final DoubleArray storage;
    private final int numElements;

    VectorDouble2(int numElements, DoubleArray array) {
        this.numElements = numElements;
        this.storage = array;
    }

    public VectorDouble2(DoubleArray array) {
        this(array.getSize() / 2, array);
    }

    public VectorDouble2(int numElements) {
        this(numElements, new DoubleArray(numElements * 2));
    }

    public int vectorWidth() {
        return 2;
    }

    private int toIndex(int index) {
        return index * 2;
    }

    public Double2 get(int index) {
        return this.loadFromArray(this.storage, this.toIndex(index));
    }

    private Double2 loadFromArray(DoubleArray array, int index) {
        Double2 result = new Double2();
        result.setX(array.get(index));
        result.setY(array.get(index + 1));
        return result;
    }

    public void set(int index, Double2 value) {
        this.storeToArray(value, this.storage, this.toIndex(index));
    }

    private void storeToArray(Double2 value, DoubleArray array, int index) {
        array.set(index, value.getX());
        array.set(index + 1, value.getY());
    }

    public void set(VectorDouble2 values) {
        for (int i = 0; i < this.numElements; ++i) {
            this.set(i, values.get(i));
        }
    }

    public void set(DoubleArray values) {
        VectorDouble2 vector = new VectorDouble2(values);
        for (int i = 0; i < this.numElements; ++i) {
            this.set(i, vector.get(i));
        }
    }

    public void fill(double value) {
        for (int i = 0; i < this.storage.getSize(); ++i) {
            this.storage.set(i, value);
        }
    }

    public VectorDouble2 duplicate() {
        VectorDouble2 vector = new VectorDouble2(this.numElements);
        vector.set(this);
        return vector;
    }

    public String toString() {
        if (this.numElements > 2) {
            return String.format("VectorDouble2 <%d>", this.numElements);
        }
        StringBuilder tempString = new StringBuilder();
        for (int i = 0; i < this.numElements; ++i) {
            tempString.append(" ").append(this.get(i).toString());
        }
        return tempString.toString();
    }

    public Double2 sum() {
        Double2 result = new Double2();
        for (int i = 0; i < this.numElements; ++i) {
            result = Double2.add(result, this.get(i));
        }
        return result;
    }

    public Double2 min() {
        Double2 result = new Double2();
        for (int i = 0; i < this.numElements; ++i) {
            result = Double2.min(result, this.get(i));
        }
        return result;
    }

    public Double2 max() {
        Double2 result = new Double2();
        for (int i = 0; i < this.numElements; ++i) {
            result = Double2.max(result, this.get(i));
        }
        return result;
    }

    @Override
    public void loadFromBuffer(DoubleBuffer buffer) {
        this.asBuffer().put(buffer);
    }

    @Override
    public DoubleBuffer asBuffer() {
        return DoubleBuffer.wrap(this.storage.toHeapArray());
    }

    public DoubleBuffer asBuffer(DoubleBuffer buffer) {
        return this.asBuffer().put(buffer);
    }

    @Override
    public int size() {
        return this.storage.getSize();
    }

    public int getLength() {
        return this.numElements;
    }

    public DoubleArray getArray() {
        return this.storage;
    }

    public void clear() {
        this.storage.clear();
    }

    @Override
    public long getNumBytes() {
        return this.storage.getNumBytesOfSegment();
    }

    @Override
    public long getNumBytesWithHeader() {
        return this.storage.getNumBytesOfSegmentWithHeader();
    }

    @Override
    public MemorySegment getSegment() {
        return this.getArray().getSegment();
    }

    @Override
    public MemorySegment getSegmentWithHeader() {
        return this.getArray().getSegmentWithHeader();
    }
}

