/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api.types.collections;

import java.lang.foreign.MemorySegment;
import java.nio.DoubleBuffer;
import uk.ac.manchester.tornado.api.math.TornadoMath;
import uk.ac.manchester.tornado.api.types.arrays.DoubleArray;
import uk.ac.manchester.tornado.api.types.collections.TornadoCollectionInterface;

public final class VectorDouble
implements TornadoCollectionInterface<DoubleBuffer> {
    private static final int ELEMENT_SIZE = 1;
    private final int numElements;
    private final DoubleArray storage;

    public VectorDouble(int numElements, DoubleArray array) {
        this.numElements = numElements;
        this.storage = array;
    }

    public VectorDouble(int numElements) {
        this(numElements, new DoubleArray(numElements));
    }

    public VectorDouble(DoubleArray storage) {
        this(storage.getSize() / 1, storage);
    }

    public static double min(VectorDouble v) {
        double result = Double.MAX_VALUE;
        for (int i = 0; i < v.storage.getSize(); ++i) {
            result = Math.min(v.storage.get(i), result);
        }
        return result;
    }

    public static double max(VectorDouble v) {
        double result = Double.MIN_VALUE;
        for (int i = 0; i < v.storage.getSize(); ++i) {
            result = Math.max(v.storage.get(i), result);
        }
        return result;
    }

    public static double dot(VectorDouble a, VectorDouble b) {
        double sum = 0.0;
        for (int i = 0; i < a.size(); ++i) {
            sum += a.get(i) * b.get(i);
        }
        return sum;
    }

    public DoubleArray getArray() {
        return this.storage;
    }

    public double get(int index) {
        return this.storage.get(index);
    }

    public void set(int index, double value) {
        this.storage.set(index, value);
    }

    public void set(VectorDouble values) {
        for (int i = 0; i < values.storage.getSize(); ++i) {
            this.storage.set(i, values.storage.get(i));
        }
    }

    public void set(double[] values) {
        for (int i = 0; i < values.length; ++i) {
            this.storage.set(i, values[i]);
        }
    }

    public void fill(double value) {
        for (int i = 0; i < this.storage.getSize(); ++i) {
            this.storage.set(i, value);
        }
    }

    public VectorDouble subVector(int start, int length) {
        VectorDouble v = new VectorDouble(length);
        for (int i = 0; i < length; ++i) {
            v.storage.set(i, this.storage.get(i + start));
        }
        return v;
    }

    public VectorDouble duplicate() {
        DoubleArray cp = new DoubleArray(this.storage.getSize());
        for (int i = 0; i < cp.getSize(); ++i) {
            cp.set(i, this.storage.get(i));
        }
        return new VectorDouble(cp);
    }

    public boolean isEqual(VectorDouble vector) {
        return TornadoMath.isEqual(this.storage, vector.storage);
    }

    public String toString(String fmt) {
        StringBuilder sb = new StringBuilder("[");
        sb.append("[ ");
        for (int i = 0; i < this.numElements; ++i) {
            sb.append(String.format(fmt, this.get(i)) + " ");
        }
        sb.append("]");
        return sb.toString();
    }

    public String toString() {
        Object str = String.format("VectorDouble <%d>", this.numElements);
        if (this.numElements < 32) {
            str = (String)str + this.toString("%.3f");
        }
        return str;
    }

    @Override
    public void loadFromBuffer(DoubleBuffer buffer) {
        this.asBuffer().put(buffer);
    }

    @Override
    public DoubleBuffer asBuffer() {
        return DoubleBuffer.wrap(this.storage.toHeapArray());
    }

    @Override
    public int size() {
        return this.numElements;
    }

    public int getLength() {
        return this.numElements;
    }

    public void clear() {
        this.storage.clear();
    }

    @Override
    public long getNumBytes() {
        return this.storage.getNumBytesOfSegment();
    }

    @Override
    public long getNumBytesWithHeader() {
        return this.storage.getNumBytesOfSegmentWithHeader();
    }

    @Override
    public MemorySegment getSegment() {
        return this.getArray().getSegment();
    }

    @Override
    public MemorySegment getSegmentWithHeader() {
        return this.getArray().getSegmentWithHeader();
    }
}

