/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api.types.arrays;

import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.nio.ShortBuffer;
import java.util.Arrays;
import uk.ac.manchester.tornado.api.internal.annotations.SegmentElementSize;
import uk.ac.manchester.tornado.api.types.arrays.TornadoNativeArray;

@SegmentElementSize(size=2)
public final class ShortArray
extends TornadoNativeArray {
    private static final int SHORT_BYTES = 2;
    private MemorySegment segment;
    private int numberOfElements;
    private int arrayHeaderSize;
    private int baseIndex;
    private long segmentByteSize;

    public ShortArray(int numberOfElements) {
        this.numberOfElements = numberOfElements;
        this.arrayHeaderSize = (int)TornadoNativeArray.ARRAY_HEADER;
        assert (this.arrayHeaderSize >= 4);
        this.baseIndex = this.arrayHeaderSize / 2;
        this.segmentByteSize = numberOfElements * 2 + this.arrayHeaderSize;
        this.segment = Arena.ofAuto().allocate(this.segmentByteSize, 1L);
        this.segment.setAtIndex(ValueLayout.JAVA_INT, 0L, numberOfElements);
    }

    public ShortArray(ShortArray ... arrays) {
        ShortArray.concat(arrays);
    }

    private static ShortArray createSegment(short[] values) {
        ShortArray array = new ShortArray(values.length);
        for (int i = 0; i < values.length; ++i) {
            array.set(i, values[i]);
        }
        return array;
    }

    public static ShortArray fromArray(short[] values) {
        return ShortArray.createSegment(values);
    }

    public static ShortArray fromElements(short ... values) {
        return ShortArray.createSegment(values);
    }

    public static ShortArray fromSegment(MemorySegment segment) {
        long byteSize = segment.byteSize();
        int numElements = (int)(byteSize / 2L);
        ShortArray.ensureMultipleOfElementSize(byteSize, 2L);
        ShortArray shortArray = new ShortArray(numElements);
        MemorySegment.copy(segment, 0L, shortArray.segment, shortArray.baseIndex * 2, byteSize);
        return shortArray;
    }

    public static ShortArray fromShortBuffer(ShortBuffer buffer) {
        int numElements = buffer.remaining();
        ShortArray shortArray = new ShortArray(numElements);
        shortArray.getSegment().copyFrom(MemorySegment.ofBuffer(buffer));
        return shortArray;
    }

    public short[] toHeapArray() {
        short[] outputArray = new short[this.getSize()];
        for (int i = 0; i < this.getSize(); ++i) {
            outputArray[i] = this.get(i);
        }
        return outputArray;
    }

    public void set(int index, short value) {
        this.segment.setAtIndex(ValueLayout.JAVA_SHORT, (long)(this.baseIndex + index), value);
    }

    public short get(int index) {
        return this.segment.getAtIndex(ValueLayout.JAVA_SHORT, (long)(this.baseIndex + index));
    }

    @Override
    public void clear() {
        this.init((short)0);
    }

    @Override
    public int getElementSize() {
        return 2;
    }

    public void init(short value) {
        for (int i = 0; i < this.getSize(); ++i) {
            this.segment.setAtIndex(ValueLayout.JAVA_SHORT, (long)(this.baseIndex + i), value);
        }
    }

    @Override
    public int getSize() {
        return this.numberOfElements;
    }

    @Override
    public MemorySegment getSegment() {
        return this.segment.asSlice(TornadoNativeArray.ARRAY_HEADER);
    }

    @Override
    public MemorySegment getSegmentWithHeader() {
        return this.segment;
    }

    @Override
    public long getNumBytesOfSegmentWithHeader() {
        return this.segmentByteSize;
    }

    @Override
    public long getNumBytesOfSegment() {
        return this.segmentByteSize - TornadoNativeArray.ARRAY_HEADER;
    }

    public static void initialize(ShortArray array, short value) {
        for (int i = 0; i < array.getSize(); ++i) {
            array.set(i, value);
        }
    }

    public static ShortArray concat(ShortArray ... arrays) {
        int newSize = Arrays.stream(arrays).mapToInt(ShortArray::getSize).sum();
        ShortArray concatArray = new ShortArray(newSize);
        long currentPositionBytes = 0L;
        for (ShortArray array : arrays) {
            MemorySegment.copy(array.getSegment(), 0L, concatArray.getSegment(), currentPositionBytes, array.getNumBytesOfSegment());
            currentPositionBytes += array.getNumBytesOfSegment();
        }
        return concatArray;
    }

    public ShortArray slice(int offset, int length) {
        if (offset < 0 || length < 0 || offset + length > this.getSize()) {
            throw new IllegalArgumentException("Slice out of bounds");
        }
        long sliceOffsetInBytes = TornadoNativeArray.ARRAY_HEADER + (long)(offset * 2);
        long sliceByteLength = length * 2;
        MemorySegment sliceSegment = this.segment.asSlice(sliceOffsetInBytes, sliceByteLength);
        ShortArray slice = ShortArray.fromSegment(sliceSegment);
        return slice;
    }
}

