/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api.types;

import uk.ac.manchester.tornado.api.internal.annotations.HalfType;

@HalfType
public class HalfFloat {
    private short halfFloatValue;

    public HalfFloat(float halfFloat) {
        this.halfFloatValue = Float.floatToFloat16(halfFloat);
    }

    public HalfFloat(short halfFloat) {
        this.halfFloatValue = halfFloat;
    }

    private static float addHalfFloat(short a, short b) {
        float floatA = Float.float16ToFloat(a);
        float floatB = Float.float16ToFloat(b);
        return floatA + floatB;
    }

    public static HalfFloat add(HalfFloat a, HalfFloat b) {
        float result = HalfFloat.addHalfFloat(a.getHalfFloatValue(), b.getHalfFloatValue());
        return new HalfFloat(result);
    }

    private static float subHalfFloat(short a, short b) {
        float floatA = Float.float16ToFloat(a);
        float floatB = Float.float16ToFloat(b);
        return floatA - floatB;
    }

    public static HalfFloat sub(HalfFloat a, HalfFloat b) {
        float result = HalfFloat.subHalfFloat(a.getHalfFloatValue(), b.getHalfFloatValue());
        return new HalfFloat(result);
    }

    private static float multHalfFloat(short a, short b) {
        float floatA = Float.float16ToFloat(a);
        float floatB = Float.float16ToFloat(b);
        return floatA * floatB;
    }

    public static HalfFloat mult(HalfFloat a, HalfFloat b) {
        float result = HalfFloat.multHalfFloat(a.getHalfFloatValue(), b.getHalfFloatValue());
        return new HalfFloat(result);
    }

    private static float divHalfFloat(short a, short b) {
        float floatA = Float.float16ToFloat(a);
        float floatB = Float.float16ToFloat(b);
        return floatA / floatB;
    }

    public static HalfFloat div(HalfFloat a, HalfFloat b) {
        float result = HalfFloat.divHalfFloat(a.getHalfFloatValue(), b.getHalfFloatValue());
        return new HalfFloat(result);
    }

    public short getHalfFloatValue() {
        return this.halfFloatValue;
    }

    public float getFloat32() {
        return Float.float16ToFloat(this.halfFloatValue);
    }

    public String toString() {
        return String.format("HalfFloat: %.4f", Float.valueOf(this.getFloat32()));
    }
}

