/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api.runtime;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import uk.ac.manchester.tornado.api.TornadoRuntime;
import uk.ac.manchester.tornado.api.TornadoSetting;
import uk.ac.manchester.tornado.api.TornadoTaskGraphInterface;
import uk.ac.manchester.tornado.api.exceptions.TornadoAPIException;

public class TornadoAPIProvider {
    public static TornadoTaskGraphInterface loadScheduleRuntime(String name) {
        TornadoTaskGraphInterface taskGraphImpl;
        try {
            String tornadoAPIImplementation = System.getProperty("tornado.load.api.implementation");
            Class<?> klass = Class.forName(tornadoAPIImplementation);
            Constructor<?> constructor = klass.getConstructor(String.class);
            taskGraphImpl = (TornadoTaskGraphInterface)constructor.newInstance(name);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new TornadoAPIException("[ERROR] Tornado API Implementation class not found", e);
        }
        return taskGraphImpl;
    }

    public static TornadoRuntime loadTornadoRuntimeImpl() {
        TornadoRuntime runtime;
        try {
            String tornadoRuntimeImplementation = System.getProperty("tornado.load.runtime.implementation");
            Class<?> klass = Class.forName(tornadoRuntimeImplementation);
            Method method = klass.getDeclaredMethod("getTornadoRuntime", new Class[0]);
            runtime = (TornadoRuntime)method.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new TornadoAPIException("[ERROR] Tornado Runtime Implementation class not found", e);
        }
        return runtime;
    }

    public static TornadoSetting loadTornadoImpl() {
        TornadoSetting tornado;
        try {
            String tornadoImplementation = System.getProperty("tornado.load.tornado.implementation");
            Class<?> klass = Class.forName(tornadoImplementation);
            Constructor<?> constructor = klass.getConstructor(new Class[0]);
            tornado = (TornadoSetting)constructor.newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new TornadoAPIException("[ERROR] Tornado Implementation class not found", e);
        }
        return tornado;
    }
}

