/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api;

import java.util.Collection;
import uk.ac.manchester.tornado.api.GridScheduler;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.common.TornadoDevice;
import uk.ac.manchester.tornado.api.enums.ProfilerMode;
import uk.ac.manchester.tornado.api.enums.TornadoVMBackendType;
import uk.ac.manchester.tornado.api.runtime.ExecutorFrame;

public class ImmutableTaskGraph {
    private final TaskGraph taskGraph;

    ImmutableTaskGraph(TaskGraph taskGraph) {
        this.taskGraph = taskGraph;
    }

    void execute(ExecutorFrame executionPackage) {
        this.taskGraph.execute(executionPackage);
    }

    void warmup(ExecutorFrame executionPackage) {
        this.taskGraph.warmup(executionPackage);
    }

    void withDevice(TornadoDevice device) {
        this.taskGraph.withDevice(device);
    }

    void withDevice(String taskName, TornadoDevice device) {
        this.taskGraph.withDevice(taskName, device);
    }

    void freeDeviceMemory() {
        this.taskGraph.freeDeviceMemory();
    }

    void transferToHost(Object ... objects) {
        this.taskGraph.syncRuntimeTransferToHost(objects);
    }

    void transferToHost(Object object, long offset, long partialCopySize) {
        this.taskGraph.syncRuntimeTransferToHost(object, offset, partialCopySize);
    }

    TaskGraph getTaskGraph() {
        return this.taskGraph;
    }

    long getTotalTime() {
        return this.taskGraph.getTotalTime();
    }

    long getCompileTime() {
        return this.taskGraph.getCompileTime();
    }

    long getTornadoCompilerTime() {
        return this.taskGraph.getTornadoCompilerTime();
    }

    long getDriverInstallTime() {
        return this.taskGraph.getDriverInstallTime();
    }

    long getDataTransfersTime() {
        return this.taskGraph.getDataTransfersTime();
    }

    long getDeviceWriteTime() {
        return this.taskGraph.getWriteTime();
    }

    long getDeviceReadTime() {
        return this.taskGraph.getReadTime();
    }

    long getDataTransferDispatchTime() {
        return this.taskGraph.getDataTransferDispatchTime();
    }

    long getKernelDispatchTime() {
        return this.taskGraph.getKernelDispatchTime();
    }

    long getDeviceKernelTime() {
        return this.taskGraph.getDeviceKernelTime();
    }

    long getTotalBytesCopyIn() {
        return this.taskGraph.getTotalBytesCopyIn();
    }

    long getTotalBytesCopyOut() {
        return this.taskGraph.getTotalBytesCopyOut();
    }

    String getProfileLog() {
        return this.taskGraph.getProfileLog();
    }

    boolean isFinished() {
        return this.taskGraph.isFinished();
    }

    void dumpProfiles() {
        this.taskGraph.dumpProfiles();
    }

    void resetDevice() {
        this.taskGraph.getDevice().clean();
    }

    void clearProfiles() {
        this.taskGraph.clearProfiles();
    }

    void withDefaultScheduler(boolean useDefaultScheduler) {
        this.taskGraph.useDefaultThreadScheduler(useDefaultScheduler);
    }

    void withBatch(String batchSize) {
        this.taskGraph.batch(batchSize);
    }

    void withMemoryLimit(String memoryLimit) {
        this.taskGraph.withMemoryLimit(memoryLimit);
    }

    void withoutMemoryLimit() {
        this.taskGraph.withoutMemoryLimit();
    }

    TornadoDevice getDevice() {
        return this.taskGraph.getDevice();
    }

    void enableProfiler(ProfilerMode profilerMode) {
        this.taskGraph.enableProfiler(profilerMode);
    }

    Collection<?> getOutputs() {
        return this.taskGraph.getOutputs();
    }

    void withConcurrentDevices() {
        this.taskGraph.withConcurrentDevices();
    }

    void withoutConcurrentDevices() {
        this.taskGraph.withoutConcurrentDevices();
    }

    void withThreadInfo() {
        this.taskGraph.withThreadInfo();
    }

    void withoutThreadInfo() {
        this.taskGraph.withoutThreadInfo();
    }

    void withPrintKernel() {
        this.taskGraph.withPrintKernel();
    }

    void withoutPrintKernel() {
        this.taskGraph.withoutPrintKernel();
    }

    void withCompilerFlags(TornadoVMBackendType backendType, String compilerFlags) {
        this.taskGraph.withCompilerFlags(backendType, compilerFlags);
    }

    void withGridScheduler(GridScheduler gridScheduler) {
        this.taskGraph.withGridScheduler(gridScheduler);
    }

    long getTotalBytesTransferred() {
        return this.taskGraph.getTotalBytesTransferred();
    }

    long getTotalDeviceMemoryUsage() {
        return this.taskGraph.getTotalDeviceMemoryUsage();
    }

    long getCurrentDeviceMemoryUsage() {
        return this.taskGraph.getCurrentDeviceMemoryUsage();
    }

    void mapOnDeviceMemoryRegion(Object destArray, Object srcArray, long offset, ImmutableTaskGraph taskGraphSrc) {
        this.taskGraph.mapOnDeviceMemoryRegion(destArray, srcArray, offset, taskGraphSrc.taskGraph.taskGraphImpl);
    }

    void updatePersistedObjectState(ImmutableTaskGraph taskGraphSrc) {
        this.taskGraph.updatePersistedObjectState(taskGraphSrc.taskGraph.taskGraphImpl);
    }
}

