/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms.thermodynamics;

import ffx.algorithms.AlgorithmListener;
import ffx.algorithms.cli.DynamicsOptions;
import ffx.algorithms.dynamics.MDVerbosity;
import ffx.algorithms.dynamics.MDWriteAction;
import ffx.algorithms.dynamics.MolecularDynamics;
import ffx.algorithms.dynamics.integrators.IntegratorEnum;
import ffx.algorithms.dynamics.thermostats.ThermostatEnum;
import ffx.algorithms.mc.BoltzmannMC;
import ffx.algorithms.mc.LambdaMove;
import ffx.algorithms.mc.MDMove;
import ffx.algorithms.thermodynamics.OrthogonalSpaceTempering;
import ffx.numerics.Potential;
import ffx.potential.MolecularAssembly;
import ffx.potential.utils.EnergyException;
import java.io.File;
import java.util.EnumSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.configuration2.CompositeConfiguration;
import org.apache.commons.math3.util.FastMath;

public class MonteCarloOST
extends BoltzmannMC {
    private static final Logger logger = Logger.getLogger(MonteCarloOST.class.getName());
    private final Level mcLogLevel;
    private final MDVerbosity mdVerbosity;
    private static final double ENERGY_CONSERVATION_TOLERANCE = 10.0;
    private final Potential potential;
    private final OrthogonalSpaceTempering orthogonalSpaceTempering;
    private final MDMove mdMove;
    private final int biasDepositionFrequency;
    private long totalSteps;
    private final long stepsPerMove;
    private final LambdaMove lambdaMove;
    private double lambda = 1.0;
    private boolean equilibration = false;
    private boolean automaticWriteouts = true;

    public MonteCarloOST(Potential potentialEnergy, OrthogonalSpaceTempering orthogonalSpaceTempering, MolecularAssembly molecularAssembly, CompositeConfiguration properties, AlgorithmListener listener, DynamicsOptions dynamics, boolean verbose, int cycleLength, File dynRestartFile) {
        boolean useOST;
        this.potential = potentialEnergy;
        this.orthogonalSpaceTempering = orthogonalSpaceTempering;
        this.mcLogLevel = verbose ? Level.INFO : Level.FINE;
        this.mdVerbosity = verbose ? MDVerbosity.QUIET : MDVerbosity.SILENT;
        this.stepsPerMove = cycleLength;
        this.totalSteps = dynamics.getNumSteps();
        ThermostatEnum thermostat = dynamics.thermostat;
        if (!thermostat.equals((Object)ThermostatEnum.ADIABATIC)) {
            logger.info(String.format(" MC-OST MD moves will use the Adiabatic thermostat (%s ignored).", new Object[]{thermostat}));
            dynamics.setThermostat(ThermostatEnum.ADIABATIC);
        }
        IntegratorEnum integrator = dynamics.integrator;
        if (!integrator.reversible || !integrator.deterministic) {
            logger.info(String.format(" MC-OST MD moves require a reversible, deterministic integrator (Verlet replaced %s).", new Object[]{integrator}));
            dynamics.setIntegrator(IntegratorEnum.VERLET);
        }
        OrthogonalSpaceTempering mdPotential = (useOST = properties.getBoolean("mdmove-full", false)) ? orthogonalSpaceTempering : this.potential;
        this.mdMove = new MDMove(molecularAssembly, (Potential)mdPotential, listener, dynamics, this.stepsPerMove, dynRestartFile);
        if (properties.containsKey("randomseed")) {
            int randomSeed = properties.getInt("randomseed", 0);
            logger.info(String.format(" Setting random seed for lambdaMove to %d ", randomSeed));
            this.lambdaMove = new LambdaMove(randomSeed, orthogonalSpaceTempering);
            this.setRandomSeed(randomSeed);
        } else {
            this.lambdaMove = new LambdaMove(orthogonalSpaceTempering);
        }
        boolean discreteLambda = orthogonalSpaceTempering.getHistogram().hd.discreteLambda;
        if (discreteLambda) {
            this.lambdaMove.setContinuous(false);
            this.lambdaMove.setMoveSize(orthogonalSpaceTempering.getHistogram().hd.lambdaBinWidth);
        }
        orthogonalSpaceTempering.setPropagateLambda(false);
        int frequency = properties.getInt("mc-ost-bias-frequency", 1);
        if (frequency <= 1) {
            this.biasDepositionFrequency = 1;
        } else {
            this.biasDepositionFrequency = frequency;
            logger.info(String.format(" MC-OST will deposit a bias only once per %d MC cycles.", this.biasDepositionFrequency));
        }
    }

    public double getLambda() {
        return this.lambda;
    }

    public void setLambda(double lambda) {
        this.lambda = lambda;
        this.orthogonalSpaceTempering.setLambda(lambda);
    }

    public MolecularDynamics getMD() {
        return this.mdMove.getMD();
    }

    public void sampleOneStep() {
        this.lambda = this.orthogonalSpaceTempering.getLambda();
        this.lambda = this.lambdaMove.validateLambda(this.lambda);
        this.orthogonalSpaceTempering.setLambda(this.lambda);
        int n = this.potential.getNumberOfVariables();
        double[] gradient = new double[n];
        double[] currentCoordinates = new double[n];
        double[] proposedCoordinates = new double[n];
        long numMoves = this.totalSteps / this.stepsPerMove;
        int acceptMCOST = 0;
        this.potential.getCoordinates(currentCoordinates);
        OrthogonalSpaceTempering.Histogram histogram = this.orthogonalSpaceTempering.getHistogram();
        double currentOSTEnergy = this.orthogonalSpaceTempering.energyAndGradient(currentCoordinates, gradient);
        double currentdUdL = this.orthogonalSpaceTempering.getForceFielddEdL();
        double currentForceFieldEnergy = this.orthogonalSpaceTempering.getForceFieldEnergy();
        double currentBiasEnergy = this.orthogonalSpaceTempering.getBiasEnergy();
        int imove = 0;
        while ((long)imove < numMoves) {
            block26: {
                double energyChange;
                double proposedOSTEnergy;
                double proposedLambda;
                long totalMoveTime = -System.nanoTime();
                boolean lambdaBeforeMD = this.random.nextBoolean();
                if (logger.isLoggable(Level.FINE)) {
                    if (this.equilibration) {
                        logger.fine(String.format("\n Equilibration Round %d", imove + 1));
                    } else {
                        String moveType = lambdaBeforeMD ? "Single-step lambda plus MD move." : "Single-step MD plus lambda move.";
                        logger.fine(String.format("\n MC-OST Round %d: %s", imove + 1, moveType));
                    }
                    logger.fine(String.format(" Starting force field energy for move %16.8f", currentForceFieldEnergy));
                }
                double currentLambda = this.orthogonalSpaceTempering.getLambda();
                if (this.equilibration) {
                    proposedLambda = currentLambda;
                    this.singleStepMD();
                } else if (lambdaBeforeMD) {
                    proposedLambda = this.singleStepLambda();
                    this.singleStepMD();
                } else {
                    this.singleStepMD();
                    proposedLambda = this.singleStepLambda();
                }
                double currentKineticEnergy = this.mdMove.getInitialKinetic();
                double proposedKineticEnergy = this.mdMove.getKineticEnergy();
                this.potential.getCoordinates(proposedCoordinates);
                long proposedOSTEnergyTime = -System.nanoTime();
                try {
                    proposedOSTEnergy = this.orthogonalSpaceTempering.energyAndGradient(proposedCoordinates, gradient);
                }
                catch (EnergyException e) {
                    this.mdMove.revertMove();
                    if (!this.equilibration) {
                        this.lambdaMove.revertMove();
                        this.lambda = currentLambda;
                    }
                    logger.log(Level.INFO, " Unstable MD Move skipped.");
                    break block26;
                }
                proposedOSTEnergyTime += System.nanoTime();
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(String.format(" Time to complete MD OST energy method call %6.3f", (double)proposedOSTEnergyTime * 1.0E-9));
                }
                double proposeddUdL = this.orthogonalSpaceTempering.getForceFielddEdL();
                double proposedForceFieldEnergy = this.orthogonalSpaceTempering.getForceFieldEnergy();
                double proposedBiasEnergy = this.orthogonalSpaceTempering.getBiasEnergy();
                double currentTotalEnergy = currentOSTEnergy + currentKineticEnergy;
                double proposedTotalEnergy = proposedOSTEnergy + proposedKineticEnergy;
                if (logger.isLoggable(this.mcLogLevel)) {
                    logger.log(this.mcLogLevel, String.format("\n  %8s %12s %12s %12s %12s", "", "Kinetic", "Potential", "Bias", "Total"));
                    logger.log(this.mcLogLevel, String.format("  Current  %12.4f %12.4f %12.4f %12.4f", currentKineticEnergy, currentForceFieldEnergy, currentBiasEnergy, currentTotalEnergy));
                    logger.log(this.mcLogLevel, String.format("  Proposed %12.4f %12.4f %12.4f %12.4f", proposedKineticEnergy, proposedForceFieldEnergy, proposedBiasEnergy, proposedTotalEnergy));
                    logger.log(this.mcLogLevel, String.format("  Delta    %12.4f %12.4f %12.4f %12.4f", proposedKineticEnergy - currentKineticEnergy, proposedForceFieldEnergy - currentForceFieldEnergy, proposedBiasEnergy - currentBiasEnergy, proposedTotalEnergy - currentTotalEnergy));
                }
                if (FastMath.abs((double)(energyChange = this.mdMove.getEnergyChange())) > 10.0) {
                    this.mdMove.revertMove();
                    if (!this.equilibration) {
                        this.lambdaMove.revertMove();
                        this.lambda = currentLambda;
                    }
                    logger.warning(" MC Move skipped due to lack of MD energy conservation.");
                } else {
                    String result = "    ";
                    double dE = proposedTotalEnergy - currentTotalEnergy;
                    if (this.equilibration) {
                        if (this.orthogonalSpaceTempering.insideHardWallConstraint(proposedLambda, proposeddUdL) && this.evaluateMove(currentTotalEnergy, proposedTotalEnergy)) {
                            result = " -> ";
                            ++acceptMCOST;
                            currentOSTEnergy = proposedOSTEnergy;
                            currentdUdL = proposeddUdL;
                            currentForceFieldEnergy = proposedForceFieldEnergy;
                            currentBiasEnergy = proposedBiasEnergy;
                            System.arraycopy(proposedCoordinates, 0, currentCoordinates, 0, n);
                        } else {
                            this.mdMove.revertMove();
                        }
                    } else {
                        if (this.orthogonalSpaceTempering.insideHardWallConstraint(proposedLambda, proposeddUdL) && this.evaluateMove(currentTotalEnergy, proposedTotalEnergy)) {
                            result = " -> ";
                            ++acceptMCOST;
                            this.lambda = proposedLambda;
                            currentdUdL = proposeddUdL;
                            currentForceFieldEnergy = proposedForceFieldEnergy;
                            System.arraycopy(proposedCoordinates, 0, currentCoordinates, 0, n);
                        } else {
                            this.lambdaMove.revertMove();
                            this.lambda = currentLambda;
                            this.mdMove.revertMove();
                        }
                        if (imove % this.biasDepositionFrequency == 0) {
                            histogram.addBias(currentdUdL);
                            if (logger.isLoggable(Level.FINE)) {
                                logger.fine(String.format(" Added Bias at move %d: [ L=%5.3f, FL=%9.3f] ", imove + 1, this.lambda, currentdUdL));
                            }
                        } else {
                            logger.info(String.format(" Cycle %d: skipping bias deposition.", imove + 1));
                        }
                        currentBiasEnergy = histogram.computeBiasEnergy(this.lambda, currentdUdL);
                        currentOSTEnergy = currentForceFieldEnergy + currentBiasEnergy;
                        boolean snapShot = this.lambda >= this.orthogonalSpaceTempering.getLambdaWriteOut();
                        long mdMoveNum = (long)(imove + 1) * this.stepsPerMove;
                        this.orthogonalSpaceTempering.getHistogram().ld.stepsTaken += this.stepsPerMove;
                        EnumSet<MDWriteAction> written = this.mdMove.writeFilesForStep(mdMoveNum, snapShot, true);
                        if (written.contains((Object)MDWriteAction.RESTART)) {
                            this.orthogonalSpaceTempering.writeAdditionalRestartInfo(false);
                        }
                    }
                    double percent = (double)acceptMCOST * 100.0 / (double)(imove + 1);
                    logger.info(String.format(" %4d [ L=%5.3f, dU/dL=%8.3f]%s[ L=%5.3f, dU/dL=%8.3f] \u0394E=%12.4f (%5.1f%%) in %6.3f sec.", imove + 1, currentLambda, currentdUdL, result, proposedLambda, proposeddUdL, dE, percent, (double)(totalMoveTime += System.nanoTime()) * 1.0E-9));
                }
            }
            ++imove;
        }
    }

    public void sampleTwoStep() {
        this.lambda = this.orthogonalSpaceTempering.getLambda();
        this.lambda = this.lambdaMove.validateLambda(this.lambda);
        this.orthogonalSpaceTempering.setLambda(this.lambda);
        int n = this.potential.getNumberOfVariables();
        double[] gradient = new double[n];
        double[] currentCoordinates = new double[n];
        double[] proposedCoordinates = new double[n];
        long numMoves = this.totalSteps / this.stepsPerMove;
        int acceptLambda = 0;
        int acceptMD = 0;
        this.potential.getCoordinates(currentCoordinates);
        OrthogonalSpaceTempering.Histogram histogram = this.orthogonalSpaceTempering.getHistogram();
        double currentOSTEnergy = this.orthogonalSpaceTempering.energyAndGradient(currentCoordinates, gradient);
        double currentdUdL = this.orthogonalSpaceTempering.getForceFielddEdL();
        double currentForceFieldEnergy = this.orthogonalSpaceTempering.getForceFieldEnergy();
        double currentBiasEnergy = this.orthogonalSpaceTempering.getBiasEnergy();
        int imove = 0;
        while ((long)imove < numMoves) {
            block19: {
                double energyChange;
                double proposedOSTEnergy;
                long totalMoveTime = -System.nanoTime();
                long mdMoveAndEvalTime = -System.nanoTime();
                if (logger.isLoggable(Level.FINE)) {
                    if (this.equilibration) {
                        logger.fine(String.format("\n MD Equilibration Round %d", imove + 1));
                    } else {
                        logger.fine(String.format("\n MC Orthogonal Space Sampling Round %d: Independent Steps", imove + 1));
                    }
                }
                long mdMoveTime = -System.nanoTime();
                this.mdMove.move(this.mdVerbosity);
                logger.log(this.mcLogLevel, String.format("  Total time for MD move: %6.3f", (double)(mdMoveTime += System.nanoTime()) * 1.0E-9));
                double currentKineticEnergy = this.mdMove.getInitialKinetic();
                double proposedKineticEnergy = this.mdMove.getKineticEnergy();
                this.potential.getCoordinates(proposedCoordinates);
                long proposedOSTEnergyTime = -System.nanoTime();
                try {
                    proposedOSTEnergy = this.orthogonalSpaceTempering.energyAndGradient(proposedCoordinates, gradient);
                }
                catch (EnergyException e) {
                    this.mdMove.revertMove();
                    logger.log(Level.INFO, " Unstable MD Move skipped.");
                    break block19;
                }
                logger.fine(String.format("  Time to complete MD OST energy method call %6.3f", (double)(proposedOSTEnergyTime += System.nanoTime()) * 1.0E-9));
                double proposeddUdL = this.orthogonalSpaceTempering.getForceFielddEdL();
                double proposedForceFieldEnergy = this.orthogonalSpaceTempering.getForceFieldEnergy();
                double proposedBiasEnergy = this.orthogonalSpaceTempering.getBiasEnergy();
                double currentTotalEnergy = currentOSTEnergy + currentKineticEnergy;
                double proposedTotalEnergy = proposedOSTEnergy + proposedKineticEnergy;
                if (logger.isLoggable(this.mcLogLevel)) {
                    logger.log(this.mcLogLevel, String.format("\n  %8s %12s %12s %12s %12s", "", "Kinetic", "Potential", "Bias", "Total"));
                    logger.log(this.mcLogLevel, String.format("  Current  %12.4f %12.4f %12.4f %12.4f", currentKineticEnergy, currentForceFieldEnergy, currentBiasEnergy, currentTotalEnergy));
                    logger.log(this.mcLogLevel, String.format("  Proposed %12.4f %12.4f %12.4f %12.4f", proposedKineticEnergy, proposedForceFieldEnergy, proposedBiasEnergy, proposedTotalEnergy));
                    logger.log(this.mcLogLevel, String.format("  Delta    %12.4f %12.4f %12.4f %12.4f", proposedKineticEnergy - currentKineticEnergy, proposedForceFieldEnergy - currentForceFieldEnergy, proposedBiasEnergy - currentBiasEnergy, proposedTotalEnergy - currentTotalEnergy));
                }
                if (FastMath.abs((double)(energyChange = this.mdMove.getEnergyChange())) > 10.0) {
                    this.mdMove.revertMove();
                    logger.warning(" MC Move skipped due to lack of MD energy conservation");
                } else {
                    String result = "    ";
                    double dE = proposedTotalEnergy - currentTotalEnergy;
                    if (this.orthogonalSpaceTempering.insideHardWallConstraint(this.orthogonalSpaceTempering.getLambda(), proposeddUdL) && this.evaluateMove(currentTotalEnergy, proposedTotalEnergy)) {
                        ++acceptMD;
                        result = " -> ";
                        currentOSTEnergy = proposedOSTEnergy;
                        currentdUdL = proposeddUdL;
                        currentForceFieldEnergy = proposedForceFieldEnergy;
                        currentBiasEnergy = proposedBiasEnergy;
                        System.arraycopy(proposedCoordinates, 0, currentCoordinates, 0, n);
                    } else {
                        this.mdMove.revertMove();
                    }
                    double percent = (double)acceptMD * 100.0 / (double)(imove + 1);
                    logger.info(String.format(" %4d MD [ L=%5.3f, dU/dL=%8.3f]%s[ L=%5.3f, dU/dL=%8.3f] \u0394E=%12.4f (%5.1f%%) in %6.3f sec.", imove + 1, this.lambda, currentdUdL, result, this.lambda, proposeddUdL, dE, percent, (double)(mdMoveAndEvalTime += System.nanoTime()) * 1.0E-9));
                    if (!this.equilibration) {
                        boolean trySnapshot;
                        long mdMoveNum;
                        EnumSet<MDWriteAction> written;
                        long lambdaMoveTime = -System.nanoTime();
                        double currentLambda = this.orthogonalSpaceTempering.getLambda();
                        this.lambdaMove.move();
                        double proposedLambda = this.orthogonalSpaceTempering.getLambda();
                        long proposedOSTEnergyTime2 = -System.nanoTime();
                        proposedOSTEnergy = this.orthogonalSpaceTempering.energyAndGradient(currentCoordinates, gradient);
                        proposedOSTEnergyTime2 += System.nanoTime();
                        proposedForceFieldEnergy = this.orthogonalSpaceTempering.getForceFieldEnergy();
                        proposeddUdL = this.orthogonalSpaceTempering.getForceFielddEdL();
                        if (logger.isLoggable(this.mcLogLevel)) {
                            logger.log(this.mcLogLevel, String.format("\n  Time to complete Lambda OST energy method call %6.3f ", (double)proposedOSTEnergyTime2 * 1.0E-9));
                            logger.log(this.mcLogLevel, String.format("  Current  OST     %12.3f at L=%5.3f.", currentOSTEnergy, currentLambda));
                            logger.log(this.mcLogLevel, String.format("  Proposed OST     %12.3f at L=%5.3f.", proposedOSTEnergy, proposedLambda));
                            logger.log(this.mcLogLevel, String.format("  MC Energy change: %12.3f (kcal/mol).", proposedOSTEnergy - currentOSTEnergy));
                        }
                        dE = proposedOSTEnergy - currentOSTEnergy;
                        if (this.orthogonalSpaceTempering.insideHardWallConstraint(proposedLambda, proposeddUdL) && this.evaluateMove(currentOSTEnergy, proposedOSTEnergy)) {
                            ++acceptLambda;
                            result = " -> ";
                            currentForceFieldEnergy = proposedForceFieldEnergy;
                            currentdUdL = proposeddUdL;
                            this.lambda = proposedLambda;
                        } else {
                            result = "    ";
                            this.lambdaMove.revertMove();
                            this.lambda = currentLambda;
                        }
                        percent = (double)acceptLambda * 100.0 / (double)(imove + 1);
                        logger.info(String.format("      L  [ L=%5.3f, dU/dL=%8.3f]%s[ L=%5.3f, dU/dL=%8.3f] \u0394E=%12.4f (%5.1f%%) in %6.3f sec.", currentLambda, currentdUdL, result, proposedLambda, proposeddUdL, dE, percent, (double)(lambdaMoveTime += System.nanoTime()) * 1.0E-9));
                        if (imove % this.biasDepositionFrequency == 0) {
                            histogram.addBias(currentdUdL);
                            logger.fine(String.format(" Added Bias at move %d: [ L=%5.3f, FL=%9.3f] ", imove + 1, this.lambda, currentdUdL));
                        } else {
                            logger.info(String.format(" Cycle %d: skipping bias deposition.", imove + 1));
                        }
                        currentBiasEnergy = histogram.computeBiasEnergy(this.lambda, currentdUdL);
                        currentOSTEnergy = currentForceFieldEnergy + currentBiasEnergy;
                        if (this.automaticWriteouts && (written = this.mdMove.writeFilesForStep(mdMoveNum = (long)(imove + 1) * this.stepsPerMove, trySnapshot = this.lambda >= this.orthogonalSpaceTempering.getLambdaWriteOut(), true)).contains((Object)MDWriteAction.RESTART)) {
                            this.orthogonalSpaceTempering.writeAdditionalRestartInfo(false);
                        }
                    }
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine(String.format(" Round complete in %6.3f sec.", (double)(totalMoveTime += System.nanoTime()) * 1.0E-9));
                    }
                }
            }
            ++imove;
        }
    }

    public void setAutomaticWriteouts(boolean autoWrite) {
        this.automaticWriteouts = autoWrite;
    }

    public void setEquilibration(boolean equilibration) {
        this.equilibration = equilibration;
    }

    public void setLambdaStdDev(double stdDev) {
        if (!this.lambdaMove.isContinuous() && stdDev != this.orthogonalSpaceTempering.getHistogram().hd.lambdaBinWidth) {
            logger.info(String.format(" Requested Lambda step size change %6.4f is not equal to OST bin width %6.4f.", stdDev, this.orthogonalSpaceTempering.getHistogram().hd.lambdaBinWidth));
            return;
        }
        this.lambdaMove.setMoveSize(stdDev);
    }

    public void setTotalSteps(long totalSteps) {
        this.totalSteps = totalSteps;
    }

    private double singleStepLambda() {
        this.lambdaMove.move();
        double proposedLambda = this.orthogonalSpaceTempering.getLambda();
        logger.log(this.mcLogLevel, String.format(" Proposed lambda: %5.3f.", proposedLambda));
        return proposedLambda;
    }

    private void singleStepMD() {
        long mdMoveTime = -System.nanoTime();
        this.mdMove.move(this.mdVerbosity);
        logger.log(this.mcLogLevel, String.format(" Total time for MD move: %6.3f", (double)(mdMoveTime += System.nanoTime()) * 1.0E-9));
    }

    @Override
    public void revertStep() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    protected double currentEnergy() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    protected void storeState() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

