/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms.optimize.manybody;

import ffx.crystal.Crystal;
import ffx.crystal.SymOp;
import ffx.potential.bonded.Atom;
import ffx.potential.bonded.Residue;
import ffx.potential.bonded.ResidueState;
import ffx.potential.bonded.Rotamer;
import ffx.potential.bonded.RotamerLibrary;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class ManyBodyCell {
    private final double[] fracCoords = new double[6];
    private final int[] indices = new int[3];
    private final int cellIndex;
    private final ArrayList<Residue> residues = new ArrayList();

    public ManyBodyCell(double[] fractionalCoordinates, int[] indices, int cellIndex) {
        System.arraycopy(fractionalCoordinates, 0, this.fracCoords, 0, this.fracCoords.length);
        System.arraycopy(indices, 0, this.indices, 0, this.indices.length);
        this.cellIndex = cellIndex;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format(" Optimization Cell %2d (%2d, %2d, %2d)\n", this.cellIndex + 1, this.indices[0] + 1, this.indices[1] + 1, this.indices[2] + 1));
        int n = this.residues.size();
        if (n == 0) {
            sb.append("  Cell is Empty\n");
        } else if (n == 1) {
            sb.append(String.format("  Single Residue: %s\n", this.residues.getFirst()));
        } else {
            Residue firstResidue = this.residues.getFirst();
            Residue lastResidue = this.residues.getLast();
            sb.append(String.format("  %d Residues: %s ... %s\n", n, firstResidue.toString(), lastResidue.toString()));
        }
        sb.append("  Fractional Coordinates:\n");
        sb.append(String.format("   A-axis %5.3f to %5.3f\n", this.fracCoords[0], this.fracCoords[3]));
        sb.append(String.format("   B-axis %5.3f to %5.3f\n", this.fracCoords[1], this.fracCoords[4]));
        sb.append(String.format("   C-axis %5.3f to %5.3f", this.fracCoords[2], this.fracCoords[5]));
        return sb.toString();
    }

    public void addResidue(Residue residue) {
        this.residues.add(residue);
    }

    public boolean anyRotamerInsideCell(Residue residue, Crystal crystal, SymOp symOp, boolean variableOnly) {
        ResidueState incomingState = residue.storeState();
        Rotamer[] rotamers = residue.getRotamers();
        boolean inside = Arrays.stream(rotamers).anyMatch(r -> {
            RotamerLibrary.applyRotamer((Residue)residue, (Rotamer)r);
            return this.residueInsideCell(residue, crystal, symOp, variableOnly);
        });
        residue.revertState(incomingState);
        return inside;
    }

    public boolean atomInsideCell(Atom atom, Crystal crystal, SymOp symOp) {
        double[] atXYZ = new double[3];
        atXYZ = atom.getXYZ(atXYZ);
        crystal.toFractionalCoordinates(atXYZ, atXYZ);
        SymOp.applyFracSymOp((double[])atXYZ, (double[])atXYZ, (SymOp)symOp);
        ManyBodyCell.moveValuesBetweenZeroAndOne(atXYZ);
        return this.checkIfContained(atXYZ);
    }

    public static void moveValuesBetweenZeroAndOne(double[] valuesToMove) {
        for (int i = 0; i < valuesToMove.length; ++i) {
            valuesToMove[i] = ManyBodyCell.moveBetweenZeroAndOne(valuesToMove[i]);
        }
    }

    private static double moveBetweenZeroAndOne(double value) {
        if (value < 0.0) {
            int belowZero = (int)value;
            belowZero = 1 + -1 * belowZero;
            value += (double)belowZero;
        } else {
            value %= 1.0;
        }
        return value;
    }

    public int getCellIndex() {
        return this.cellIndex;
    }

    public ArrayList<Residue> getResiduesAsList() {
        return new ArrayList<Residue>(this.residues);
    }

    public int[] getABCIndices() {
        int[] returnedIndices = new int[3];
        System.arraycopy(this.indices, 0, returnedIndices, 0, returnedIndices.length);
        return returnedIndices;
    }

    public boolean residueInsideCell(Residue residue, Crystal crystal, SymOp symOp, boolean variableOnly) {
        List atoms = variableOnly ? residue.getVariableAtoms() : residue.getAtomList();
        return atoms.stream().anyMatch(a -> this.atomInsideCell((Atom)a, crystal, symOp));
    }

    public void sortCellResidues() {
        Comparator<Residue> comparator = Comparator.comparing(Residue::getChainID).thenComparingInt(Residue::getResidueNumber);
        this.residues.sort(comparator);
    }

    private boolean checkIfContained(double[] atomFracCoords) {
        for (int i = 0; i < 3; ++i) {
            if (!(atomFracCoords[i] < this.fracCoords[i]) && !(atomFracCoords[i] > this.fracCoords[i + 3])) continue;
            return false;
        }
        return true;
    }
}

