/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms.optimize.manybody;

import edu.rit.pj.IntegerForLoop;
import edu.rit.pj.IntegerSchedule;
import edu.rit.pj.ParallelRegion;
import ffx.algorithms.AlgorithmListener;
import ffx.algorithms.optimize.manybody.DistanceMatrix;
import ffx.crystal.Crystal;
import ffx.crystal.SymOp;
import ffx.potential.MolecularAssembly;
import ffx.potential.bonded.Residue;
import ffx.potential.bonded.Rotamer;
import ffx.potential.bonded.RotamerLibrary;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DistanceRegion
extends ParallelRegion {
    private static final Logger logger = Logger.getLogger(DistanceRegion.class.getName());
    private final DistanceLoop[] distanceLoops;
    private final int nResidues;
    private final Crystal crystal;
    private final int nSymm;
    private final int[][][] lists;
    private final IntegerSchedule pairwiseSchedule;
    protected AlgorithmListener algorithmListener;
    private DistanceMatrix dM;
    private MolecularAssembly molecularAssembly;
    private Residue[] allResiduesArray;
    private DistanceMatrix.NeighborDistances[][] distanceMatrix;

    public DistanceRegion(int nt, int nResidues, Crystal crystal, int[][][] lists, IntegerSchedule schedule) {
        this.distanceLoops = new DistanceLoop[nt];
        this.nResidues = nResidues;
        this.crystal = crystal;
        this.nSymm = crystal.spaceGroup.getNumberOfSymOps();
        this.lists = lists;
        for (int i = 0; i < nt; ++i) {
            this.distanceLoops[i] = new DistanceLoop(this);
        }
        this.pairwiseSchedule = schedule;
    }

    public void init(DistanceMatrix dM, MolecularAssembly molecularAssembly, Residue[] allResiduesArray, AlgorithmListener algorithmListener, DistanceMatrix.NeighborDistances[][] distanceMatrix) {
        this.dM = dM;
        this.molecularAssembly = molecularAssembly;
        this.allResiduesArray = allResiduesArray;
        this.algorithmListener = algorithmListener;
        this.distanceMatrix = distanceMatrix;
    }

    public void run() {
        try {
            int threadID = this.getThreadIndex();
            this.execute(0, this.nResidues - 1, this.distanceLoops[threadID]);
        }
        catch (Exception e) {
            String message = " Exception computing residue-residue distances.";
            logger.log(Level.SEVERE, message, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double[][] getCoordinates(int i, Residue[] residues, Rotamer rotamer) {
        Residue residue = residues[i];
        synchronized (residue) {
            Residue residue2 = residues[i];
            RotamerLibrary.applyRotamer((Residue)residue2, (Rotamer)rotamer);
            return residue2.storeCoordinateArray();
        }
    }

    private class DistanceLoop
    extends IntegerForLoop {
        final /* synthetic */ DistanceRegion this$0;

        private DistanceLoop(DistanceRegion distanceRegion) {
            DistanceRegion distanceRegion2 = distanceRegion;
            Objects.requireNonNull(distanceRegion2);
            this.this$0 = distanceRegion2;
        }

        public void run(int lb, int ub) {
            for (int iSymOp = 0; iSymOp < this.this$0.nSymm; ++iSymOp) {
                SymOp symOp = this.this$0.crystal.spaceGroup.getSymOp(iSymOp);
                for (int i = lb; i <= ub; ++i) {
                    Residue residueI = this.this$0.allResiduesArray[i];
                    Rotamer[] rotamersI = residueI.getRotamers();
                    int lengthRi = rotamersI.length;
                    int[] list = this.this$0.lists[iSymOp][i];
                    for (int ri = 0; ri < lengthRi; ++ri) {
                        double[][] xi = this.this$0.getCoordinates(i, this.this$0.allResiduesArray, rotamersI[ri]);
                        for (int j : list) {
                            if (i == j) continue;
                            Residue residueJ = this.this$0.allResiduesArray[j];
                            Rotamer[] rotamersJ = residueJ.getRotamers();
                            int lengthRj = rotamersJ.length;
                            for (int rj = 0; rj < lengthRj; ++rj) {
                                double[][] xj = this.this$0.getCoordinates(j, this.this$0.allResiduesArray, rotamersJ[rj]);
                                if (this.getThreadIndex() == 0 && this.this$0.algorithmListener != null) {
                                    this.this$0.algorithmListener.algorithmUpdate(this.this$0.molecularAssembly);
                                }
                                double r = this.this$0.dM.interResidueDistance(xi, xj, symOp);
                                if (i < j) {
                                    this.this$0.distanceMatrix[i][ri].storeDistance(j, rj, r);
                                    continue;
                                }
                                this.this$0.distanceMatrix[j][rj].storeDistance(i, ri, r);
                            }
                        }
                    }
                }
            }
        }

        public IntegerSchedule schedule() {
            return this.this$0.pairwiseSchedule;
        }
    }
}

