/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms.optimize;

import ffx.algorithms.cli.ManyBodyOptions;
import ffx.potential.ForceFieldEnergy;
import ffx.potential.MolecularAssembly;
import ffx.potential.bonded.AminoAcidUtils;
import ffx.potential.bonded.Atom;
import ffx.potential.bonded.Residue;
import ffx.potential.bonded.Rotamer;
import ffx.potential.bonded.RotamerLibrary;
import ffx.potential.openmm.OpenMMEnergy;
import ffx.potential.parameters.ForceField;
import ffx.potential.parameters.TitrationUtils;
import ffx.potential.parsers.PDBFilter;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;

public class TitrationManyBody {
    private static final Logger logger = Logger.getLogger(TitrationManyBody.class.getName());
    private final ForceField forceField;
    private final List<Integer> resNumberList;
    private final double pH;
    private final String filename;
    private PDBFilter protonFilter;
    private ForceFieldEnergy potentialEnergy;
    private ManyBodyOptions manyBodyOptions;
    private Set<Atom> excludeAtoms = new HashSet<Atom>();

    public Set<Atom> getExcludeAtoms() {
        return this.excludeAtoms;
    }

    public void setExcludeAtoms(Set<Atom> excludeAtoms) {
        this.excludeAtoms = excludeAtoms;
    }

    public TitrationManyBody(String filename, ForceField forceField, List<Integer> resNumberList, double pH) {
        this.filename = filename;
        this.forceField = forceField;
        this.resNumberList = resNumberList;
        this.pH = pH;
    }

    public TitrationManyBody(String filename, ForceField forceField, List<Integer> resNumberList, double pH, ManyBodyOptions manyBodyOptions) {
        this.filename = filename;
        this.forceField = forceField;
        this.resNumberList = resNumberList;
        this.pH = pH;
        this.manyBodyOptions = manyBodyOptions;
    }

    public MolecularAssembly getProtonatedAssembly() {
        ForceFieldEnergy residue2;
        MolecularAssembly protonatedAssembly = new MolecularAssembly(this.filename);
        protonatedAssembly.setForceField(this.forceField);
        File structureFile = new File(this.filename);
        this.protonFilter = new PDBFilter(structureFile, protonatedAssembly, this.forceField, this.forceField.getProperties(), this.resNumberList);
        this.protonFilter.setRotamerTitration(true);
        this.protonFilter.readFile();
        this.protonFilter.applyAtomProperties();
        protonatedAssembly.finalize(true, this.forceField);
        this.potentialEnergy = ForceFieldEnergy.energyFactory((MolecularAssembly)protonatedAssembly);
        protonatedAssembly.setFile(structureFile);
        double proteinDielectric = 1.0;
        boolean tanhCorrection = false;
        try {
            proteinDielectric = this.forceField.getDouble("SOLUTE_DIELECTRIC", Double.valueOf(1.0));
            tanhCorrection = this.forceField.getBoolean("TANH_CORRECTION", true);
        }
        catch (Exception e) {
            logger.info("Protein Dielectric or Tanh Correction is Null");
        }
        TitrationUtils titrationUtils = new TitrationUtils(protonatedAssembly.getForceField(), proteinDielectric, tanhCorrection);
        titrationUtils.setRotamerPhBias(298.15, this.pH);
        for (ForceFieldEnergy residue2 : protonatedAssembly.getResidueList()) {
            String resName = residue2.getName();
            if (!this.resNumberList.contains(residue2.getResidueNumber()) || !resName.equalsIgnoreCase("ASH") && !resName.equalsIgnoreCase("GLH") && !resName.equalsIgnoreCase("LYS") && !resName.equalsIgnoreCase("HIS") && !resName.equalsIgnoreCase("CYS")) continue;
            residue2.setTitrationUtils(titrationUtils);
        }
        residue2 = this.potentialEnergy;
        if (residue2 instanceof OpenMMEnergy) {
            OpenMMEnergy openMMEnergy = (OpenMMEnergy)residue2;
            boolean updateBondedTerms = this.forceField.getBoolean("TITRATION_UPDATE_BONDED_TERMS", true);
            openMMEnergy.getSystem().setUpdateBondedTerms(updateBondedTerms);
        }
        this.potentialEnergy.energy();
        return protonatedAssembly;
    }

    public MolecularAssembly[] getProtonatedAssemblies() {
        logger.info(" Adding protons that titrate to molecular assemblies");
        MolecularAssembly molecularAssembly = this.getProtonatedAssembly();
        List altLocs = this.protonFilter.getAltLocs();
        int locs = 1;
        if (altLocs != null) {
            locs = altLocs.size();
            for (int i = 0; i < locs; ++i) {
                if (altLocs.get(i) != null) continue;
                altLocs.remove(altLocs.get(i));
            }
        }
        MolecularAssembly[] molecularAssemblies = new MolecularAssembly[locs];
        molecularAssemblies[0] = molecularAssembly;
        for (int i = 1; i < altLocs.size(); ++i) {
            logger.info(this.filename);
            MolecularAssembly newAssembly = new MolecularAssembly(this.filename);
            newAssembly.setForceField(this.forceField);
            File structureFile = new File(this.filename);
            this.protonFilter = new PDBFilter(structureFile, newAssembly, this.forceField, this.forceField.getProperties(), this.resNumberList);
            this.protonFilter.setRotamerTitration(true);
            this.protonFilter.setAltID(newAssembly, (Character)altLocs.get(i));
            this.protonFilter.readFile();
            this.protonFilter.applyAtomProperties();
            newAssembly.finalize(true, this.forceField);
            this.potentialEnergy = ForceFieldEnergy.energyFactory((MolecularAssembly)newAssembly);
            double proteinDielectric = this.forceField.getDouble("SOLUTE_DIELECTRIC", Double.valueOf(1.0));
            boolean tanhCorrection = this.forceField.getBoolean("TANH_CORRECTION", true);
            TitrationUtils titrationUtils = new TitrationUtils(molecularAssembly.getForceField(), proteinDielectric, tanhCorrection);
            titrationUtils.setRotamerPhBias(298.15, this.pH);
            for (Residue residue : molecularAssembly.getResidueList()) {
                String resName = residue.getName();
                if (!this.resNumberList.contains(residue.getResidueNumber()) || !resName.equalsIgnoreCase("ASH") && !resName.equalsIgnoreCase("GLH") && !resName.equalsIgnoreCase("LYS") && !resName.equalsIgnoreCase("HIS") && !resName.equalsIgnoreCase("CYS")) continue;
                residue.setTitrationUtils(titrationUtils);
            }
            this.potentialEnergy.energy();
            molecularAssemblies[i] = newAssembly;
        }
        return molecularAssemblies;
    }

    public boolean excludeExcessAtoms(Set<Atom> excludeAtoms, int[] optimalRotamers, List<Residue> residueList) {
        boolean isTitrating = false;
        int i = 0;
        for (Residue residue : residueList) {
            RotamerLibrary rotamerLibrary = this.manyBodyOptions.getRotamerLibrary(true);
            residue.setRotamers(rotamerLibrary);
            String resName = residue.getName();
            if (resName.equalsIgnoreCase("ASH") || resName.equalsIgnoreCase("GLH") || resName.equalsIgnoreCase("LYS") || resName.equalsIgnoreCase("HIS") || resName.equalsIgnoreCase("CYS")) {
                Rotamer rotamer = residue.getRotamers()[optimalRotamers[i]];
                RotamerLibrary.applyRotamer((Residue)residue, (Rotamer)rotamer);
                if (residue.getTitrationUtils() != null) {
                    isTitrating = true;
                    AminoAcidUtils.AminoAcid3 aa3 = rotamer.aminoAcid3;
                    residue.setName(aa3.name());
                    switch (aa3) {
                        case HID: 
                        case GLU: {
                            Atom HE2 = residue.getAtomByName("HE2", true);
                            excludeAtoms.add(HE2);
                            break;
                        }
                        case HIE: {
                            Atom HD1 = residue.getAtomByName("HD1", true);
                            excludeAtoms.add(HD1);
                            break;
                        }
                        case ASP: {
                            Atom HD2 = residue.getAtomByName("HD2", true);
                            excludeAtoms.add(HD2);
                            break;
                        }
                        case LYD: {
                            Atom HZ3 = residue.getAtomByName("HZ3", true);
                            excludeAtoms.add(HZ3);
                            break;
                        }
                        case CYD: {
                            Atom HG = residue.getAtomByName("HG", true);
                            excludeAtoms.add(HG);
                            break;
                        }
                    }
                }
            }
            ++i;
        }
        this.setExcludeAtoms(excludeAtoms);
        return isTitrating;
    }

    public boolean excludeExcessAtoms(Set<Atom> excludeAtoms, int[] optimalRotamers, MolecularAssembly molecularAssembly, List<Residue> residueList) {
        boolean isTitrating = false;
        double proteinDielectric = 1.0;
        boolean tanhCorrection = false;
        try {
            proteinDielectric = this.forceField.getDouble("SOLUTE_DIELECTRIC", Double.valueOf(1.0));
            tanhCorrection = this.forceField.getBoolean("TANH_CORRECTION", true);
        }
        catch (Exception e) {
            logger.info("Protein Dielectric or Tanh Correction is Null");
        }
        TitrationUtils titrationUtils = new TitrationUtils(molecularAssembly.getForceField(), proteinDielectric, tanhCorrection);
        titrationUtils.setRotamerPhBias(298.15, this.pH);
        for (Residue residue : residueList) {
            String resName = residue.getName();
            if (!this.resNumberList.contains(residue.getResidueNumber()) || !resName.equalsIgnoreCase("ASH") && !resName.equalsIgnoreCase("GLH") && !resName.equalsIgnoreCase("LYS") && !resName.equalsIgnoreCase("HIS") && !resName.equalsIgnoreCase("CYS")) continue;
            residue.setTitrationUtils(titrationUtils);
        }
        isTitrating = this.excludeExcessAtoms(excludeAtoms, optimalRotamers, residueList);
        return isTitrating;
    }
}

