/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms.optimize;

import ffx.algorithms.AlgorithmListener;
import ffx.algorithms.optimize.Minimize;
import ffx.numerics.Potential;
import ffx.numerics.optimization.LineSearch;
import ffx.potential.ForceFieldEnergy;
import ffx.potential.MolecularAssembly;
import ffx.potential.bonded.Atom;
import ffx.potential.openmm.OpenMMContext;
import ffx.potential.openmm.OpenMMEnergy;
import ffx.potential.openmm.OpenMMState;
import java.util.logging.Logger;
import org.apache.commons.math3.util.FastMath;

public class MinimizeOpenMM
extends Minimize {
    private static final Logger logger = Logger.getLogger(MinimizeOpenMM.class.getName());

    public MinimizeOpenMM(MolecularAssembly molecularAssembly) {
        super(molecularAssembly, (Potential)molecularAssembly.getPotentialEnergy(), null);
    }

    public MinimizeOpenMM(MolecularAssembly molecularAssembly, OpenMMEnergy openMMEnergy) {
        super(molecularAssembly, (Potential)openMMEnergy, null);
    }

    public MinimizeOpenMM(MolecularAssembly molecularAssembly, OpenMMEnergy openMMEnergy, AlgorithmListener algorithmListener) {
        super(molecularAssembly, (Potential)openMMEnergy, algorithmListener);
    }

    @Override
    public Potential minimize(int m, double eps, int maxIterations) {
        return this.minimize(eps, maxIterations);
    }

    @Override
    public Potential minimize(double eps, int maxIterations) {
        ForceFieldEnergy forceFieldEnergy = this.molecularAssembly.getPotentialEnergy();
        if (forceFieldEnergy instanceof OpenMMEnergy) {
            OpenMMEnergy openMMEnergy = (OpenMMEnergy)forceFieldEnergy;
            this.time = -System.nanoTime();
            Atom[] atoms = this.molecularAssembly.getAtomArray();
            openMMEnergy.updateParameters(atoms);
            openMMEnergy.setActiveAtoms();
            openMMEnergy.getCoordinates(this.x);
            double e = openMMEnergy.energy(this.x);
            logger.info(String.format("\n Initial energy:                 %12.6f (kcal/mol)", e));
            OpenMMContext openMMContext = openMMEnergy.getContext();
            openMMContext.optimize(eps, maxIterations);
            int mask = 13;
            OpenMMState openMMState = openMMContext.getOpenMMState(mask);
            this.energy = openMMState.potentialEnergy;
            openMMState.getActivePositions(this.x, atoms);
            openMMState.getActiveGradient(this.grad, atoms);
            openMMState.destroy();
            double grad2 = 0.0;
            for (int i = 0; i < this.n; ++i) {
                double gi = this.grad[i];
                if (Double.isNaN(gi) || Double.isInfinite(gi)) {
                    String message = String.format(" The gradient of variable %d is %8.3f.", i, gi);
                    logger.warning(message);
                }
                grad2 += gi * gi;
            }
            this.rmsGradient = FastMath.sqrt((double)(grad2 / (double)this.n));
            double[] ffxGrad = new double[this.n];
            double ffxEnergy = openMMEnergy.energyAndGradientFFX(this.x, ffxGrad);
            double grmsFFX = 0.0;
            for (int i = 0; i < this.n; ++i) {
                double gi = ffxGrad[i];
                if (Double.isNaN(gi) || Double.isInfinite(gi)) {
                    String message = String.format(" The gradient of variable %d is %8.3f.", i, gi);
                    logger.warning(message);
                }
                grmsFFX += gi * gi;
            }
            grmsFFX = FastMath.sqrt((double)(grmsFFX / (double)this.n));
            this.time += System.nanoTime();
            logger.info(String.format(" Final energy for OpenMM         %12.6f vs. FFX %12.6f in %8.3f (sec).", this.energy, ffxEnergy, (double)this.time * 1.0E-9));
            logger.info(String.format(" Convergence criteria for OpenMM %12.6f vs. FFX %12.6f (kcal/mol/A).", this.rmsGradient, grmsFFX));
        }
        if (this.algorithmListener != null) {
            this.algorithmListener.algorithmUpdate(this.molecularAssembly);
        }
        return forceFieldEnergy;
    }

    @Override
    public boolean optimizationUpdate(int iteration, int nBFGS, int functionEvaluations, double rmsGradient, double rmsCoordinateChange, double energy, double energyChange, double angle, LineSearch.LineSearchResult lineSearchResult) {
        logger.warning(" MinimizeOpenMM does not support updates at each optimization step.");
        return false;
    }
}

