/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms.optimize;

import ffx.algorithms.AlgorithmListener;
import ffx.algorithms.Terminatable;
import ffx.algorithms.optimize.Minimize;
import ffx.crystal.Crystal;
import ffx.numerics.Potential;
import ffx.numerics.optimization.OptimizationListener;
import ffx.potential.ForceFieldEnergy;
import ffx.potential.MolecularAssembly;
import ffx.potential.XtalEnergy;
import java.util.logging.Logger;
import org.apache.commons.math3.util.FastMath;

public class CrystalMinimize
extends Minimize
implements OptimizationListener,
Terminatable {
    private static final Logger logger = Logger.getLogger(CrystalMinimize.class.getName());
    private final ForceFieldEnergy forceFieldEnergy;
    private Crystal crystal;
    private final Crystal unitCell;

    public CrystalMinimize(MolecularAssembly molecularAssembly, XtalEnergy xtalEnergy, AlgorithmListener algorithmListener) {
        super(molecularAssembly, (Potential)xtalEnergy, algorithmListener);
        this.crystal = molecularAssembly.getCrystal();
        this.unitCell = this.crystal.getUnitCell();
        this.forceFieldEnergy = molecularAssembly.getPotentialEnergy();
        for (int i = 0; i < this.n - 6; i += 3) {
            this.scaling[i] = 12.0 * this.crystal.a;
            this.scaling[i + 1] = 12.0 * this.crystal.b;
            this.scaling[i + 2] = 12.0 * this.crystal.c;
        }
        this.scaling[this.n - 6] = 4.0 * FastMath.sqrt((double)this.crystal.a);
        this.scaling[this.n - 5] = 4.0 * FastMath.sqrt((double)this.crystal.b);
        this.scaling[this.n - 4] = 4.0 * FastMath.sqrt((double)this.crystal.c);
        this.scaling[this.n - 3] = 0.02 * FastMath.sqrt((double)this.crystal.volume);
        this.scaling[this.n - 2] = 0.02 * FastMath.sqrt((double)this.crystal.volume);
        this.scaling[this.n - 1] = 0.02 * FastMath.sqrt((double)this.crystal.volume);
    }

    public void computeElasticityTensor(boolean verbose) {
        double[] xOrig = new double[this.forceFieldEnergy.getNumberOfVariables()];
        this.forceFieldEnergy.getCoordinates(xOrig);
        this.forceFieldEnergy.energy(xOrig, verbose);
        MolecularAssembly.FractionalMode currentFractionalMode = this.molecularAssembly.getFractionalMode();
        this.molecularAssembly.setFractionalMode(MolecularAssembly.FractionalMode.MOLECULE);
        this.molecularAssembly.computeFractionalCoordinates();
        double PRESCON = 68568.4112;
        double GPA = 1.0132500000000001E-4;
        double volume = this.crystal.getUnitCell().volume / (double)this.crystal.getUnitCell().spaceGroup.getNumberOfSymOps();
        boolean currentCheckRestrictions = this.crystal.getCheckRestrictions();
        this.crystal.setCheckRestrictions(false);
        logger.info(" The Strain and Stress Tensor code is under development.");
        double delta = 0.005;
        double eps = 0.002;
        double c11 = 0.0;
        double c22 = 0.0;
        double c33 = 0.0;
        double c12 = 0.0;
        double c13 = 0.0;
        double c23 = 0.0;
        double c14 = 0.0;
        double c15 = 0.0;
        double c16 = 0.0;
        double c24 = 0.0;
        double c25 = 0.0;
        double c26 = 0.0;
        double c34 = 0.0;
        double c35 = 0.0;
        double c36 = 0.0;
        double c44 = 0.0;
        double c55 = 0.0;
        double c66 = 0.0;
        double c45 = 0.0;
        double c46 = 0.0;
        double c56 = 0.0;
        double[] x = new double[this.forceFieldEnergy.getNumberOfVariables()];
        System.arraycopy(xOrig, 0, x, 0, x.length);
        switch (this.crystal.spaceGroup.crystalSystem) {
            case CUBIC: {
                double cavg;
                c11 = this.dE2dA2(1, 1, delta, x, eps) * PRESCON * GPA / volume;
                c22 = this.dE2dA2(2, 2, delta, x, eps) * PRESCON * GPA / volume;
                c33 = this.dE2dA2(3, 3, delta, x, eps) * PRESCON * GPA / volume;
                c22 = c33 = (cavg = (c11 + c22 + c33) / 3.0);
                c11 = c33;
                c12 = this.dE2dA2(1, 2, delta, x, eps) * PRESCON * GPA / volume;
                c13 = this.dE2dA2(1, 3, delta, x, eps) * PRESCON * GPA / volume;
                c23 = this.dE2dA2(2, 3, delta, x, eps) * PRESCON * GPA / volume;
                c13 = c23 = (cavg = (c12 + c13 + c23) / 3.0);
                c12 = c23;
                c44 = this.dE2dA2(4, 4, delta, x, eps) * PRESCON * GPA / volume;
                c55 = this.dE2dA2(5, 5, delta, x, eps) * PRESCON * GPA / volume;
                c66 = this.dE2dA2(6, 6, delta, x, eps) * PRESCON * GPA / volume;
                c55 = c66 = (cavg = (c44 + c55 + c66) / 3.0);
                c44 = c66;
                break;
            }
            case HEXAGONAL: {
                double cavg;
                c11 = this.dE2dA2(1, 1, delta, x, eps) * PRESCON * GPA / volume;
                c22 = this.dE2dA2(2, 2, delta, x, eps) * PRESCON * GPA / volume;
                c11 = c22 = (cavg = (c11 + c22) / 2.0);
                c33 = this.dE2dA2(3, 3, delta, x, eps) * PRESCON * GPA / volume;
                c12 = this.dE2dA2(1, 2, delta, x, eps) * PRESCON * GPA / volume;
                c13 = this.dE2dA2(1, 3, delta, x, eps) * PRESCON * GPA / volume;
                c23 = this.dE2dA2(2, 3, delta, x, eps) * PRESCON * GPA / volume;
                c13 = c23 = (cavg = (c13 + c23) / 2.0);
                c44 = this.dE2dA2(4, 4, delta, x, eps) * PRESCON * GPA / volume;
                c55 = this.dE2dA2(5, 5, delta, x, eps) * PRESCON * GPA / volume;
                c44 = c55 = (cavg = (c44 + c55) / 2.0);
                c66 = 0.5 * (c11 - c12);
                break;
            }
            case TRIGONAL: {
                double cavg;
                c11 = this.dE2dA2(1, 1, delta, x, eps) * PRESCON * GPA / volume;
                c22 = this.dE2dA2(2, 2, delta, x, eps) * PRESCON * GPA / volume;
                c11 = c22 = (cavg = (c11 + c22) / 2.0);
                c33 = this.dE2dA2(3, 3, delta, x, eps) * PRESCON * GPA / volume;
                c12 = this.dE2dA2(1, 2, delta, x, eps) * PRESCON * GPA / volume;
                c13 = this.dE2dA2(1, 3, delta, x, eps) * PRESCON * GPA / volume;
                c23 = this.dE2dA2(2, 3, delta, x, eps) * PRESCON * GPA / volume;
                c13 = c23 = (cavg = (c13 + c23) / 2.0);
                c44 = this.dE2dA2(4, 4, delta, x, eps) * PRESCON * GPA / volume;
                c55 = this.dE2dA2(5, 5, delta, x, eps) * PRESCON * GPA / volume;
                c44 = c55 = (cavg = (c44 + c55) / 2.0);
                c66 = 0.5 * (c11 - c12);
                c14 = this.dE2dA2(1, 4, delta, x, eps) * PRESCON * GPA / volume;
                c24 = this.dE2dA2(2, 4, delta, x, eps) * PRESCON * GPA / volume;
                c56 = c14;
                String pg = this.crystal.getUnitCell().spaceGroup.pointGroupName;
                if (!pg.equalsIgnoreCase("PG3") && !pg.equalsIgnoreCase("PG3bar")) break;
                c15 = this.dE2dA2(1, 5, delta, x, eps) * PRESCON * GPA / volume;
                c46 = c25 = this.dE2dA2(2, 5, delta, x, eps) * PRESCON * GPA / volume;
                break;
            }
            case TETRAGONAL: {
                double cavg;
                c11 = this.dE2dA2(1, 1, delta, x, eps) * PRESCON * GPA / volume;
                c22 = this.dE2dA2(2, 2, delta, x, eps) * PRESCON * GPA / volume;
                c11 = c22 = (cavg = (c11 + c22) / 2.0);
                c33 = this.dE2dA2(3, 3, delta, x, eps) * PRESCON * GPA / volume;
                c12 = this.dE2dA2(1, 2, delta, x, eps) * PRESCON * GPA / volume;
                c13 = this.dE2dA2(1, 3, delta, x, eps) * PRESCON * GPA / volume;
                c23 = this.dE2dA2(2, 3, delta, x, eps) * PRESCON * GPA / volume;
                c13 = c23 = (cavg = (c13 + c23) / 2.0);
                c44 = this.dE2dA2(4, 4, delta, x, eps) * PRESCON * GPA / volume;
                c55 = this.dE2dA2(5, 5, delta, x, eps) * PRESCON * GPA / volume;
                c44 = c55 = (cavg = (c44 + c55) / 2.0);
                c66 = this.dE2dA2(6, 6, delta, x, eps) * PRESCON * GPA / volume;
                String pg = this.crystal.getUnitCell().spaceGroup.pointGroupName;
                if (!pg.equalsIgnoreCase("PG4") && !pg.equalsIgnoreCase("PG4bar") && !pg.equalsIgnoreCase("PG4/m")) break;
                c16 = this.dE2dA2(1, 6, delta, x, eps) * PRESCON * GPA / volume;
                c26 = this.dE2dA2(2, 6, delta, x, eps) * PRESCON * GPA / volume;
                break;
            }
            case ORTHORHOMBIC: {
                c11 = this.dE2dA2(1, 1, delta, x, eps) * PRESCON * GPA / volume;
                c22 = this.dE2dA2(2, 2, delta, x, eps) * PRESCON * GPA / volume;
                c33 = this.dE2dA2(3, 3, delta, x, eps) * PRESCON * GPA / volume;
                c12 = this.dE2dA2(1, 2, delta, x, eps) * PRESCON * GPA / volume;
                c13 = this.dE2dA2(1, 3, delta, x, eps) * PRESCON * GPA / volume;
                c23 = this.dE2dA2(2, 3, delta, x, eps) * PRESCON * GPA / volume;
                c44 = this.dE2dA2(4, 4, delta, x, eps) * PRESCON * GPA / volume;
                c55 = this.dE2dA2(5, 5, delta, x, eps) * PRESCON * GPA / volume;
                c66 = this.dE2dA2(6, 6, delta, x, eps) * PRESCON * GPA / volume;
                break;
            }
            case MONOCLINIC: {
                c11 = this.dE2dA2(1, 1, delta, x, eps) * PRESCON * GPA / volume;
                c22 = this.dE2dA2(2, 2, delta, x, eps) * PRESCON * GPA / volume;
                c33 = this.dE2dA2(3, 3, delta, x, eps) * PRESCON * GPA / volume;
                c12 = this.dE2dA2(1, 2, delta, x, eps) * PRESCON * GPA / volume;
                c13 = this.dE2dA2(1, 3, delta, x, eps) * PRESCON * GPA / volume;
                c23 = this.dE2dA2(2, 3, delta, x, eps) * PRESCON * GPA / volume;
                c15 = this.dE2dA2(1, 5, delta, x, eps) * PRESCON * GPA / volume;
                c25 = this.dE2dA2(2, 5, delta, x, eps) * PRESCON * GPA / volume;
                c35 = this.dE2dA2(3, 5, delta, x, eps) * PRESCON * GPA / volume;
                c46 = this.dE2dA2(4, 6, delta, x, eps) * PRESCON * GPA / volume;
                c44 = this.dE2dA2(4, 4, delta, x, eps) * PRESCON * GPA / volume;
                c55 = this.dE2dA2(5, 5, delta, x, eps) * PRESCON * GPA / volume;
                c66 = this.dE2dA2(6, 6, delta, x, eps) * PRESCON * GPA / volume;
                break;
            }
            default: {
                c11 = this.dE2dA2(1, 1, delta, x, eps) * PRESCON * GPA / volume;
                c22 = this.dE2dA2(2, 2, delta, x, eps) * PRESCON * GPA / volume;
                c33 = this.dE2dA2(3, 3, delta, x, eps) * PRESCON * GPA / volume;
                c12 = this.dE2dA2(1, 2, delta, x, eps) * PRESCON * GPA / volume;
                c13 = this.dE2dA2(1, 3, delta, x, eps) * PRESCON * GPA / volume;
                c23 = this.dE2dA2(2, 3, delta, x, eps) * PRESCON * GPA / volume;
                c14 = this.dE2dA2(1, 4, delta, x, eps) * PRESCON * GPA / volume;
                c15 = this.dE2dA2(1, 5, delta, x, eps) * PRESCON * GPA / volume;
                c16 = this.dE2dA2(1, 6, delta, x, eps) * PRESCON * GPA / volume;
                c24 = this.dE2dA2(2, 4, delta, x, eps) * PRESCON * GPA / volume;
                c25 = this.dE2dA2(2, 5, delta, x, eps) * PRESCON * GPA / volume;
                c26 = this.dE2dA2(2, 6, delta, x, eps) * PRESCON * GPA / volume;
                c34 = this.dE2dA2(3, 4, delta, x, eps) * PRESCON * GPA / volume;
                c35 = this.dE2dA2(3, 5, delta, x, eps) * PRESCON * GPA / volume;
                c36 = this.dE2dA2(3, 6, delta, x, eps) * PRESCON * GPA / volume;
                c44 = this.dE2dA2(4, 4, delta, x, eps) * PRESCON * GPA / volume;
                c55 = this.dE2dA2(5, 5, delta, x, eps) * PRESCON * GPA / volume;
                c66 = this.dE2dA2(6, 6, delta, x, eps) * PRESCON * GPA / volume;
                c45 = this.dE2dA2(4, 5, delta, x, eps) * PRESCON * GPA / volume;
                c46 = this.dE2dA2(4, 6, delta, x, eps) * PRESCON * GPA / volume;
                c56 = this.dE2dA2(5, 6, delta, x, eps) * PRESCON * GPA / volume;
            }
        }
        if (eps > 0.0) {
            logger.info(String.format(" Elasticity Tensor using minimization and FD step size of %6.3e (GPa) =", delta));
        } else {
            logger.info(String.format(" Elasticity Tensor using rigid body fractional coordinates and FD step size of %6.3e (GPa) =", delta));
        }
        logger.info(String.format(" [ %12.3f %12.3f %12.3f %12.3f %12.3f %12.3f ]", c11, c12, c13, c14, c15, c16));
        logger.info(String.format(" [ %12s %12.3f %12.3f %12.3f %12.3f %12.3f ]", "", c22, c23, c24, c25, c26));
        logger.info(String.format(" [ %12s %12s %12.3f %12.3f %12.3f %12.3f ]", "", "", c33, c34, c35, c36));
        logger.info(String.format(" [ %12s %12s %12s %12.3f %12.3f %12.3f ]", "", "", "", c44, c45, c46));
        logger.info(String.format(" [ %12s %12s %12s %12s %12.3f %12.3f ]", "", "", "", "", c55, c56));
        logger.info(String.format(" [ %12s %12s %12s %12s %12s %12.3f ]", "", "", "", "", "", c66));
        this.molecularAssembly.setFractionalMode(currentFractionalMode);
        this.crystal.setCheckRestrictions(currentCheckRestrictions);
    }

    @Override
    public Potential minimize(int m, double eps, int maxIterations) {
        super.minimize(m, eps, maxIterations);
        this.crystal = this.molecularAssembly.getCrystal();
        logger.info("\n Final lattice parameters" + String.valueOf(this.crystal));
        return this.potential;
    }

    public void printTensor() {
        this.computeStressTensor(true);
    }

    private void applyStrain(int voight, double delta, double[][] strain) {
        switch (voight) {
            case 1: {
                double[] dArray = strain[0];
                dArray[0] = dArray[0] + delta;
                break;
            }
            case 2: {
                double[] dArray = strain[1];
                dArray[1] = dArray[1] + delta;
                break;
            }
            case 3: {
                double[] dArray = strain[2];
                dArray[2] = dArray[2] + delta;
                break;
            }
            case 4: {
                double[] dArray = strain[1];
                dArray[2] = dArray[2] + delta / 2.0;
                double[] dArray2 = strain[2];
                dArray2[1] = dArray2[1] + delta / 2.0;
                break;
            }
            case 5: {
                double[] dArray = strain[0];
                dArray[2] = dArray[2] + delta / 2.0;
                double[] dArray3 = strain[2];
                dArray3[0] = dArray3[0] + delta / 2.0;
                break;
            }
            case 6: {
                double[] dArray = strain[0];
                dArray[1] = dArray[1] + delta / 2.0;
                double[] dArray4 = strain[1];
                dArray4[0] = dArray4[0] + delta / 2.0;
            }
        }
    }

    private void computeStressTensor(boolean verbose) {
        double[] x = new double[this.forceFieldEnergy.getNumberOfVariables()];
        this.forceFieldEnergy.getCoordinates(x);
        this.forceFieldEnergy.energy(x, verbose);
        MolecularAssembly.FractionalMode currentFractionalMode = this.molecularAssembly.getFractionalMode();
        this.molecularAssembly.setFractionalMode(MolecularAssembly.FractionalMode.ATOM);
        this.molecularAssembly.computeFractionalCoordinates();
        double delta = 1.0E-5;
        double[][] dEdV = new double[3][3];
        dEdV[0][0] = this.dEdA(0, 0, delta, x);
        dEdV[0][1] = this.dEdA(0, 1, delta, x);
        dEdV[0][2] = this.dEdA(0, 2, delta, x);
        dEdV[1][1] = this.dEdA(1, 1, delta, x);
        dEdV[1][2] = this.dEdA(1, 2, delta, x);
        dEdV[2][2] = this.dEdA(2, 2, delta, x);
        logger.info("\n The Stress Tensor code is under development.");
        logger.info("\n dE/dLvec Derivatives: ");
        logger.info(String.format(" [ %16.8f %16.8f %16.8f ]", dEdV[0][0], dEdV[0][1], dEdV[0][2]));
        logger.info(String.format(" [ %16.8f %16.8f %16.8f ]", dEdV[1][0], dEdV[1][1], dEdV[1][2]));
        logger.info(String.format(" [ %16.8f %16.8f %16.8f ]", dEdV[2][0], dEdV[2][1], dEdV[2][2]));
        dEdV[1][0] = dEdV[0][1];
        dEdV[2][0] = dEdV[0][2];
        dEdV[2][1] = dEdV[1][2];
        double[][] virial = new double[3][3];
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j <= i; ++j) {
                virial[j][i] = 0.0;
                for (int k = 0; k < 3; ++k) {
                    virial[j][i] = virial[j][i] + dEdV[k][j] * this.unitCell.Ai[i][k];
                }
                virial[i][j] = virial[j][i];
            }
        }
        logger.info("\n Numerical Virial: ");
        logger.info(String.format(" [ %16.8f %16.8f %16.8f ]", virial[0][0], virial[0][1], virial[0][2]));
        logger.info(String.format(" [ %16.8f %16.8f %16.8f ]", virial[1][0], virial[1][1], virial[1][2]));
        logger.info(String.format(" [ %16.8f %16.8f %16.8f ]", virial[2][0], virial[2][1], virial[2][2]));
        double dedv = (virial[0][0] + virial[1][1] + virial[2][2]) / (3.0 * this.unitCell.volume);
        double PRESCON = 68568.4112;
        double temperature = 298.15;
        int nAtoms = this.molecularAssembly.getAtomArray().length;
        double pressure = PRESCON * ((double)nAtoms * 0.0019872042586408316 * temperature / this.unitCell.volume - dedv);
        logger.info(String.format("\n Pressure estimate (%6.2f Kelvin): %12.8f (atm)", temperature, pressure));
        this.molecularAssembly.setFractionalMode(currentFractionalMode);
    }

    private double dEdA(int ii, int jj, double delta, double[] x) {
        double a = this.unitCell.a;
        double b = this.unitCell.b;
        double c = this.unitCell.c;
        double alpha = this.unitCell.alpha;
        double beta = this.unitCell.beta;
        double gamma = this.unitCell.gamma;
        double[][] cellVectors = new double[3][3];
        for (int i = 0; i < 3; ++i) {
            System.arraycopy(this.unitCell.Ai[i], 0, cellVectors[i], 0, 3);
        }
        double[] dArray = cellVectors[ii];
        int n = jj;
        dArray[n] = dArray[n] + delta;
        try {
            if (!this.crystal.setCellVectors(cellVectors)) {
                return 0.0;
            }
        }
        catch (Exception e) {
            return 0.0;
        }
        this.forceFieldEnergy.setCrystal(this.crystal);
        this.molecularAssembly.moveToFractionalCoordinates();
        this.forceFieldEnergy.getCoordinates(x);
        double eplus = this.forceFieldEnergy.energy(x);
        double[] dArray2 = cellVectors[ii];
        int n2 = jj;
        dArray2[n2] = dArray2[n2] - 2.0 * delta;
        try {
            if (!this.crystal.setCellVectors(cellVectors)) {
                return 0.0;
            }
        }
        catch (Exception e) {
            return 0.0;
        }
        this.forceFieldEnergy.setCrystal(this.crystal);
        this.molecularAssembly.moveToFractionalCoordinates();
        this.forceFieldEnergy.getCoordinates(x);
        double eminus = this.forceFieldEnergy.energy(x);
        this.crystal.changeUnitCellParameters(a, b, c, alpha, beta, gamma);
        this.forceFieldEnergy.setCrystal(this.crystal);
        this.molecularAssembly.moveToFractionalCoordinates();
        return (eplus - eminus) / (2.0 * delta);
    }

    private double dE2dA2(int voight1, int voight2, double delta, double[] x, double eps) {
        double a = this.unitCell.a;
        double b = this.unitCell.b;
        double c = this.unitCell.c;
        double alpha = this.unitCell.alpha;
        double beta = this.unitCell.beta;
        double gamma = this.unitCell.gamma;
        double[][] dStrain = new double[3][3];
        this.applyStrain(voight1, delta, dStrain);
        this.applyStrain(voight2, delta, dStrain);
        try {
            if (!this.crystal.perturbCellVectors(dStrain)) {
                logger.info(" Crystal method perturbCellVectors returned false.");
                return 0.0;
            }
        }
        catch (Exception e) {
            logger.info(" Exception from Crystal method perturbCellVectors.");
            return 0.0;
        }
        this.forceFieldEnergy.setCrystal(this.crystal);
        this.molecularAssembly.moveToFractionalCoordinates();
        if (eps > 0.0) {
            Minimize minimize = new Minimize(this.molecularAssembly, (Potential)this.forceFieldEnergy, null);
            minimize.minimize(eps);
        }
        this.forceFieldEnergy.getCoordinates(x);
        double e11 = this.forceFieldEnergy.energy(x);
        this.crystal.changeUnitCellParameters(a, b, c, alpha, beta, gamma);
        dStrain = new double[3][3];
        this.applyStrain(voight1, -delta, dStrain);
        this.applyStrain(voight2, -delta, dStrain);
        try {
            if (!this.crystal.perturbCellVectors(dStrain)) {
                logger.info(" Crystal method perturbCellVectors returned false.");
                return 0.0;
            }
        }
        catch (Exception e) {
            logger.info(" Exception from Crystal method perturbCellVectors.");
            return 0.0;
        }
        this.forceFieldEnergy.setCrystal(this.crystal);
        this.molecularAssembly.moveToFractionalCoordinates();
        if (eps > 0.0) {
            Minimize minimize = new Minimize(this.molecularAssembly, (Potential)this.forceFieldEnergy, null);
            minimize.minimize(eps);
        }
        this.forceFieldEnergy.getCoordinates(x);
        double em1m1 = this.forceFieldEnergy.energy(x);
        this.crystal.changeUnitCellParameters(a, b, c, alpha, beta, gamma);
        dStrain = new double[3][3];
        this.applyStrain(voight1, delta, dStrain);
        this.applyStrain(voight2, -delta, dStrain);
        try {
            if (!this.crystal.perturbCellVectors(dStrain)) {
                logger.info(" Crystal method perturbCellVectors returned false.");
                return 0.0;
            }
        }
        catch (Exception e) {
            logger.info(" Exception from Crystal method perturbCellVectors.");
            return 0.0;
        }
        this.forceFieldEnergy.setCrystal(this.crystal);
        this.molecularAssembly.moveToFractionalCoordinates();
        if (eps > 0.0) {
            Minimize minimize = new Minimize(this.molecularAssembly, (Potential)this.forceFieldEnergy, null);
            minimize.minimize(eps);
        }
        this.forceFieldEnergy.getCoordinates(x);
        double e1m1 = this.forceFieldEnergy.energy(x);
        this.crystal.changeUnitCellParameters(a, b, c, alpha, beta, gamma);
        dStrain = new double[3][3];
        this.applyStrain(voight1, -delta, dStrain);
        this.applyStrain(voight2, delta, dStrain);
        try {
            if (!this.crystal.perturbCellVectors(dStrain)) {
                logger.info(" Crystal method perturbCellVectors returned false.");
                return 0.0;
            }
        }
        catch (Exception e) {
            logger.info(" Exception from Crystal method perturbCellVectors.");
            return 0.0;
        }
        this.forceFieldEnergy.setCrystal(this.crystal);
        this.molecularAssembly.moveToFractionalCoordinates();
        if (eps > 0.0) {
            Minimize minimize = new Minimize(this.molecularAssembly, (Potential)this.forceFieldEnergy, null);
            minimize.minimize(eps);
        }
        this.forceFieldEnergy.getCoordinates(x);
        double em11 = this.forceFieldEnergy.energy(x);
        this.crystal.changeUnitCellParameters(a, b, c, alpha, beta, gamma);
        this.forceFieldEnergy.setCrystal(this.crystal);
        this.molecularAssembly.moveToFractionalCoordinates();
        this.forceFieldEnergy.getCoordinates(x);
        return (e11 - e1m1 - em11 + em1m1) / (4.0 * delta * delta);
    }
}

