/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms.mc;

import ffx.algorithms.dynamics.thermostats.Thermostat;
import ffx.algorithms.mc.MonteCarloListener;
import ffx.algorithms.mc.RosenbluthChiAllMove;
import ffx.potential.ForceFieldEnergy;
import ffx.potential.MolecularAssembly;
import ffx.potential.bonded.AminoAcidUtils;
import ffx.potential.bonded.Residue;
import ffx.potential.parsers.PDBFilter;
import java.io.File;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.logging.Logger;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.math3.util.FastMath;

public class RosenbluthCBMC
implements MonteCarloListener {
    private static final Logger logger = Logger.getLogger(RosenbluthCBMC.class.getName());
    private final MolecularAssembly molecularAssembly;
    private final ForceFieldEnergy forceFieldEnergy;
    private final double temperature;
    private final List<Residue> targets;
    private final int mcFrequency;
    private final int trialSetSize;
    private int steps = 0;
    private int numMovesProposed = 0;
    private final boolean writeSnapshots;
    private PDBFilter writer = null;

    public RosenbluthCBMC(MolecularAssembly molecularAssembly, ForceFieldEnergy ffe, Thermostat thermostat, List<Residue> targets, int mcFrequency, int trialSetSize, boolean writeSnapshots) {
        this.targets = targets;
        this.mcFrequency = mcFrequency;
        this.trialSetSize = trialSetSize;
        this.molecularAssembly = molecularAssembly;
        this.forceFieldEnergy = ffe;
        this.writeSnapshots = writeSnapshots;
        this.temperature = thermostat != null ? thermostat.getTargetTemperature() : 298.15;
        for (int i = targets.size() - 1; i >= 0; --i) {
            AminoAcidUtils.AminoAcid3 name = AminoAcidUtils.AminoAcid3.valueOf((String)targets.get(i).getName());
            if (name != AminoAcidUtils.AminoAcid3.GLY && name != AminoAcidUtils.AminoAcid3.PRO && name != AminoAcidUtils.AminoAcid3.ALA) continue;
            targets.remove(i);
        }
        if (targets.isEmpty()) {
            logger.severe(" Empty target list for CMBC.");
        }
    }

    public boolean cbmcStep() {
        boolean accepted;
        ++this.numMovesProposed;
        int index = ThreadLocalRandom.current().nextInt(this.targets.size());
        Residue target = this.targets.get(index);
        RosenbluthChiAllMove cbmcMove = new RosenbluthChiAllMove(this.molecularAssembly, target, this.trialSetSize, this.forceFieldEnergy, this.temperature, this.writeSnapshots, this.numMovesProposed, true);
        if (cbmcMove.getMode() == RosenbluthChiAllMove.MODE.CHEAP) {
            return cbmcMove.wasAccepted();
        }
        double Wn = cbmcMove.getWn();
        double Wo = cbmcMove.getWo();
        double criterion = FastMath.min((double)1.0, (double)(Wn / Wo));
        double rng = ThreadLocalRandom.current().nextDouble();
        logger.info(String.format("    rng:    %5.2f", rng));
        if (rng < criterion) {
            cbmcMove.move();
            logger.info(String.format(" Accepted!  Energy: %.4f\n", cbmcMove.finalEnergy));
            accepted = true;
            this.write();
        } else {
            logger.info(" Denied.\n");
            accepted = false;
        }
        return accepted;
    }

    public boolean controlStep() {
        int index = ThreadLocalRandom.current().nextInt(this.targets.size());
        Residue target = this.targets.get(index);
        RosenbluthChiAllMove cbmcMove = new RosenbluthChiAllMove(this.molecularAssembly, target, -1, this.forceFieldEnergy, this.temperature, false, this.numMovesProposed, true);
        return cbmcMove.wasAccepted();
    }

    @Override
    public boolean mcUpdate(double temperature) {
        ++this.steps;
        if (this.steps % this.mcFrequency == 0) {
            return this.cbmcStep();
        }
        return false;
    }

    private void write() {
        Object filename;
        if (this.writer == null) {
            this.writer = new PDBFilter(this.molecularAssembly.getFile(), this.molecularAssembly, null, null);
        }
        if (!((String)(filename = this.molecularAssembly.getFile().getAbsolutePath())).contains("_mc")) {
            filename = FilenameUtils.removeExtension((String)filename) + "_mc.pdb";
        }
        File file = new File((String)filename);
        this.writer.writeFile(file, false);
    }
}

