/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms.mc;

import ffx.algorithms.AlgorithmListener;
import ffx.algorithms.cli.DynamicsOptions;
import ffx.algorithms.dynamics.MDVerbosity;
import ffx.algorithms.dynamics.MDWriteAction;
import ffx.algorithms.dynamics.MolecularDynamics;
import ffx.algorithms.dynamics.MolecularDynamicsOpenMM;
import ffx.algorithms.mc.MCMove;
import ffx.numerics.Potential;
import ffx.potential.MolecularAssembly;
import java.io.File;
import java.util.EnumSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public class MDMove
implements MCMove {
    private static final Logger logger = Logger.getLogger(MDMove.class.getName());
    private final MolecularDynamics molecularDynamics;
    private final long mdSteps;
    private final double timeStep;
    private final double printInterval;
    private final double temperature;
    private final double saveInterval;
    private final Potential potential;
    private int mdMoveCounter = 0;
    private double energyChange;
    private double energyDriftAbs;
    private double energyDriftNet;
    private double initialKinetic;
    private double initialPotential;
    private double initialTotal;
    private File dynRestartFile;

    public MDMove(MolecularAssembly assembly, Potential potentialEnergy, AlgorithmListener listener, DynamicsOptions dynamics, long stepsPerCycle, @Nullable File dynRestartFile) {
        this.potential = potentialEnergy;
        this.molecularDynamics = MolecularDynamics.dynamicsFactory(assembly, potentialEnergy, listener, dynamics.thermostat, dynamics.integrator);
        this.molecularDynamics.setAutomaticWriteouts(false);
        this.timeStep = dynamics.getDt();
        double dtPs = this.timeStep * 0.001;
        this.mdSteps = stepsPerCycle;
        this.molecularDynamics.setVerbosityLevel(MDVerbosity.QUIET);
        this.molecularDynamics.setObtainVelAcc(false);
        this.molecularDynamics.setRestartFrequency(dynamics.getCheckpoint());
        this.saveInterval = dynamics.getSnapshotInterval();
        double requestedPrint = dynamics.getReport();
        double maxPrintInterval = dtPs * (double)this.mdSteps;
        this.printInterval = Math.min(requestedPrint, maxPrintInterval);
        this.temperature = dynamics.getTemperature();
        this.dynRestartFile = dynRestartFile;
        if (this.dynRestartFile != null && this.dynRestartFile.exists()) {
            this.molecularDynamics.setVerbosityLevel(MDVerbosity.SILENT);
            this.molecularDynamics.dynamic(1L, this.timeStep, this.printInterval, this.saveInterval, this.temperature, false, dynRestartFile);
            this.collectEnergies();
            this.revertMove();
            this.molecularDynamics.setVerbosityLevel(MDVerbosity.QUIET);
        }
    }

    public double getEnergyChange() {
        return this.energyChange;
    }

    public double getInitialKinetic() {
        return this.initialKinetic;
    }

    public double getInitialPotential() {
        return this.initialPotential;
    }

    public double getInitialTotal() {
        return this.initialTotal;
    }

    public double getKineticEnergy() {
        return this.molecularDynamics.getKineticEnergy();
    }

    public MolecularDynamics getMD() {
        return this.molecularDynamics;
    }

    public double getPotentialEnergy() {
        return this.molecularDynamics.getPotentialEnergy();
    }

    @Override
    public void move() {
        this.move(MDVerbosity.QUIET);
    }

    public void move(MDVerbosity verbosityLevel) {
        MDVerbosity origLevel = this.molecularDynamics.getVerbosityLevel();
        this.molecularDynamics.setVerbosityLevel(verbosityLevel);
        if (this.mdMoveCounter == 0 && this.dynRestartFile != null && this.dynRestartFile.exists()) {
            this.molecularDynamics.dynamic(this.mdSteps, this.timeStep, this.printInterval, this.saveInterval, this.temperature, false, this.dynRestartFile);
        } else {
            this.molecularDynamics.dynamic(this.mdSteps, this.timeStep, this.printInterval, this.saveInterval, this.temperature, true, null);
        }
        ++this.mdMoveCounter;
        this.collectEnergies();
        this.energyChange = this.molecularDynamics.getTotalEnergy() - this.initialTotal;
        if (this.molecularDynamics instanceof MolecularDynamicsOpenMM && logger.isLoggable(Level.FINE)) {
            this.energyDriftNet += this.energyChange;
            this.energyDriftAbs += Math.abs(this.energyChange);
            double energyDriftAverageNet = this.energyDriftNet / (double)this.mdMoveCounter;
            double energyDriftAverageAbs = this.energyDriftAbs / (double)this.mdMoveCounter;
            logger.fine(String.format(" Mean signed/unsigned energy drift:                   %8.4f/%8.4f", energyDriftAverageNet, energyDriftAverageAbs));
            double dt = this.molecularDynamics.getTimeStep();
            int intervalSteps = this.molecularDynamics.getIntervalSteps();
            int nAtoms = this.potential.getNumberOfVariables() / 3;
            double normalizedEnergyDriftNet = energyDriftAverageNet / (dt * (double)intervalSteps * (double)nAtoms) * 1000.0;
            double normalizedEnergyDriftAbs = energyDriftAverageAbs / (dt * (double)intervalSteps * (double)nAtoms) * 1000.0;
            logger.fine(String.format(" Mean singed/unsigned energy drift per psec per atom: %8.4f/%8.4f\n", normalizedEnergyDriftNet, normalizedEnergyDriftAbs));
        }
        this.molecularDynamics.setVerbosityLevel(origLevel);
    }

    @Override
    public void revertMove() {
        try {
            this.molecularDynamics.revertState();
        }
        catch (Exception ex) {
            logger.severe(" The MD state could not be reverted.");
        }
    }

    public void setMDIntervalSteps(int intervalSteps) {
        this.molecularDynamics.setIntervalSteps(intervalSteps);
    }

    public EnumSet<MDWriteAction> writeFilesForStep(long mdStep, boolean trySnapshot, boolean tryRestart) {
        return this.molecularDynamics.writeFilesForStep(mdStep, trySnapshot, tryRestart);
    }

    private void collectEnergies() {
        this.initialTotal = this.molecularDynamics.getInitialTotalEnergy();
        this.initialKinetic = this.molecularDynamics.getInitialKineticEnergy();
        this.initialPotential = this.molecularDynamics.getInitialPotentialEnergy();
        assert (Math.abs(this.initialTotal) < 0.001 || Math.abs((this.initialKinetic + this.initialPotential - this.initialTotal) / this.initialTotal) < 1.0E-7);
    }
}

