/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms.mc;

import ffx.algorithms.mc.MCMove;
import ffx.algorithms.thermodynamics.OrthogonalSpaceTempering;
import java.util.Random;
import java.util.logging.Logger;
import org.apache.commons.math3.util.FastMath;

public class LambdaMove
implements MCMove {
    private static final Logger logger = Logger.getLogger(LambdaMove.class.getName());
    private final OrthogonalSpaceTempering orthogonalSpaceTempering;
    private final Random random;
    private double currentLambda;
    private double moveSize = 0.1;
    private boolean isContinuous = true;

    public LambdaMove(OrthogonalSpaceTempering orthogonalSpaceTempering) {
        this.orthogonalSpaceTempering = orthogonalSpaceTempering;
        this.random = new Random();
    }

    public LambdaMove(int randomSeed, OrthogonalSpaceTempering orthogonalSpaceTempering) {
        this.orthogonalSpaceTempering = orthogonalSpaceTempering;
        this.random = new Random(randomSeed);
    }

    public static double mirror(Random random, double lam, double dL) {
        boolean skip;
        if ((lam == 0.0 || lam == 1.0) && (skip = random.nextBoolean())) {
            return lam;
        }
        if (FastMath.abs((double)dL) > 1.0) {
            logger.warning(String.format(" Skipping large lambda move of %.3f not between -1 and +1", dL));
            return lam;
        }
        double newLam = FastMath.abs((double)(lam + dL));
        return newLam <= 1.0 ? newLam : 2.0 - newLam;
    }

    public double getMoveSize() {
        return this.moveSize;
    }

    public void setMoveSize(double moveSize) {
        this.moveSize = moveSize;
    }

    public boolean isContinuous() {
        return this.isContinuous;
    }

    public void setContinuous(boolean continuous) {
        this.isContinuous = continuous;
    }

    @Override
    public void move() {
        this.currentLambda = this.orthogonalSpaceTempering.getLambda();
        double dL = this.isContinuous ? this.continuousMove() : this.discreteMove();
        double newLambda = this.mirror(this.currentLambda, dL);
        this.orthogonalSpaceTempering.setLambda(newLambda);
    }

    @Override
    public void revertMove() {
        this.orthogonalSpaceTempering.setLambda(this.currentLambda);
    }

    public double validateLambda(double lambda) {
        lambda = FastMath.max((double)0.0, (double)FastMath.min((double)lambda, (double)1.0));
        if (this.isContinuous) {
            return lambda;
        }
        double remainder = lambda % this.moveSize;
        if (remainder < this.moveSize / 2.0) {
            return FastMath.max((double)0.0, (double)(lambda - remainder));
        }
        return FastMath.min((double)(lambda + (this.moveSize - remainder)), (double)1.0);
    }

    private double mirror(double lam, double dL) {
        return LambdaMove.mirror(this.random, lam, dL);
    }

    private double continuousMove() {
        return this.random.nextGaussian() * this.moveSize;
    }

    private double discreteMove() {
        double dL = this.moveSize;
        if (this.random.nextBoolean()) {
            dL = -this.moveSize;
        }
        return dL;
    }
}

