/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms.dynamics.thermostats;

import ffx.algorithms.dynamics.thermostats.Thermostat;
import ffx.algorithms.dynamics.thermostats.ThermostatEnum;
import ffx.numerics.Constraint;
import ffx.numerics.Potential;
import ffx.potential.SystemState;
import java.util.Collections;
import java.util.List;
import org.apache.commons.math3.util.FastMath;

public class Berendsen
extends Thermostat {
    private double tau;

    public Berendsen(SystemState state, Potential.VARIABLE_TYPE[] type, double targetTemperature, double tau) {
        this(state, type, targetTemperature, tau, Collections.emptyList());
    }

    public Berendsen(SystemState state, Potential.VARIABLE_TYPE[] type, double targetTemperature, double tau, List<Constraint> constraints) {
        super(state, type, targetTemperature, constraints);
        this.name = ThermostatEnum.BERENDSEN;
        this.tau = tau;
    }

    public Berendsen(SystemState state, Potential.VARIABLE_TYPE[] type, double targetTemperature) {
        this(state, type, targetTemperature, 0.2);
    }

    @Override
    public void fullStep(double dt) {
        double ratio = this.targetTemperature / this.state.getTemperature();
        double scale = FastMath.sqrt((double)(1.0 + dt / this.tau * (ratio - 1.0)));
        double[] v = this.state.v();
        double[] mass = this.state.getMass();
        for (int i = 0; i < this.state.getNumberOfVariables(); ++i) {
            if (!(mass[i] > 0.0)) continue;
            int n = i;
            v[n] = v[n] * scale;
        }
    }

    public double getTau() {
        return this.tau;
    }

    public void setTau(double tau) {
        this.tau = tau;
    }

    @Override
    public void halfStep(double dt) {
    }

    public String toThermostatString() {
        return String.format("\n Berendsen Thermostat (tau = %8.3f psec)\n  %s", this.tau, super.toString());
    }

    @Override
    public String toString() {
        return "Berendsen";
    }
}

