/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms.dynamics.integrators;

import ffx.algorithms.dynamics.integrators.Integrator;
import ffx.numerics.Potential;
import ffx.potential.SystemState;

public class BetterBeeman
extends Integrator {
    private double dt2_8;
    private double dt_8;

    public BetterBeeman(SystemState state) {
        super(state);
        this.dt_8 = 0.125 * this.dt;
        this.dt2_8 = this.dt * this.dt_8;
    }

    @Override
    public void postForce(double[] gradient) {
        this.copyAccelerationToPrevious();
        double[] a = this.state.a();
        double[] v = this.state.v();
        double[] mass = this.state.getMass();
        double[] aPrevious = this.state.aPrevious();
        for (int i = 0; i < this.state.getNumberOfVariables(); ++i) {
            double m = mass[i];
            if (!(m > 0.0)) continue;
            a[i] = -418.4 * gradient[i] / m;
            int n = i;
            v[n] = v[n] + (3.0 * a[i] + aPrevious[i]) * this.dt_8;
        }
    }

    @Override
    public void preForce(Potential potential) {
        double[] x = this.state.x();
        double[] a = this.state.a();
        double[] v = this.state.v();
        double[] mass = this.state.getMass();
        double[] aPrevious = this.state.aPrevious();
        for (int i = 0; i < this.state.getNumberOfVariables(); ++i) {
            double m = mass[i];
            if (!(m > 0.0)) continue;
            double temp = 5.0 * a[i] - aPrevious[i];
            int n = i;
            x[n] = x[n] + (v[i] * this.dt + temp * this.dt2_8);
            int n2 = i;
            v[n2] = v[n2] + temp * this.dt_8;
        }
    }

    @Override
    public void setTimeStep(double dt) {
        this.dt = dt;
        this.dt_8 = 0.125 * dt;
        this.dt2_8 = dt * this.dt_8;
    }

    public String toString() {
        return "Better Beeman";
    }
}

