/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms.commands.test;

import ffx.algorithms.cli.AlgorithmsCommand;
import ffx.algorithms.cli.DynamicsOptions;
import ffx.algorithms.dynamics.MolecularDynamics;
import ffx.algorithms.dynamics.WeightedEnsembleManager;
import ffx.numerics.Potential;
import ffx.potential.ForceFieldEnergy;
import ffx.potential.MolecularAssembly;
import ffx.potential.cli.AtomSelectionOptions;
import ffx.potential.cli.WriteoutOptions;
import ffx.utilities.FFXBinding;
import java.io.File;
import picocli.CommandLine;

@CommandLine.Command(description={" Runs parallel simulations with intermittent resampling."}, name="test.WeightedEnsemble")
public class WeightedEnsemble
extends AlgorithmsCommand {
    @CommandLine.Mixin
    private AtomSelectionOptions atomSelectionOptions;
    @CommandLine.Mixin
    private DynamicsOptions dynamicsOptions;
    @CommandLine.Mixin
    private WriteoutOptions writeOutOptions;
    @CommandLine.Option(names={"--stepsPer"}, paramLabel="10000", defaultValue="10000", description={"Number of steps to take between resampling cycles."})
    private int stepsPer;
    @CommandLine.Option(names={"--initDynamics"}, paramLabel="10000", defaultValue="10000", description={"Number of initialization steps to take before windows start. This is good for getting diverse starting structures."})
    private int initDynamics;
    @CommandLine.Option(names={"--numPerBin"}, paramLabel="2", defaultValue="2", description={"Number of walkers per bin."})
    private int numPerBin;
    @CommandLine.Option(names={"--oneDimensionalMetric"}, paramLabel="RMSD", defaultValue="RMSD", description={"Bin across this metric. Options: RMSD, POTENTIAL, RESIDUE_DISTANCE, ATOM_DISTANCE, COM_DISTANCE, RADIUS_OF_GYRATION"})
    private String oneDimensionalMetric;
    @CommandLine.Parameters(arity="1..*", paramLabel="files", description={"XYZ or PDB input files."})
    private String filename;

    public WeightedEnsemble() {
    }

    public WeightedEnsemble(FFXBinding binding) {
        super(binding);
    }

    public WeightedEnsemble(String[] args) {
        super(args);
    }

    public WeightedEnsemble run() {
        if (!this.init()) {
            return this;
        }
        this.dynamicsOptions.init();
        MolecularAssembly assembly = this.getActiveAssembly(this.filename);
        File file = assembly.getFile();
        if (file == null) {
            logger.severe(" No file found for assembly: " + String.valueOf(assembly));
        } else {
            logger.info(" Running Weighted Ensemble on " + String.valueOf(file));
        }
        ForceFieldEnergy potential = assembly.getPotentialEnergy();
        double[] x = new double[potential.getNumberOfVariables()];
        potential.getCoordinates(x);
        potential.energy(x, true);
        MolecularDynamics md = this.dynamicsOptions.getDynamics(this.writeOutOptions, (Potential)potential, assembly, this.algorithmListener);
        WeightedEnsembleManager.OneDimMetric metric = null;
        try {
            metric = WeightedEnsembleManager.OneDimMetric.valueOf(this.oneDimensionalMetric);
        }
        catch (IllegalArgumentException e) {
            logger.severe(" Invalid oneDimensionalMetric: " + this.oneDimensionalMetric);
            return this;
        }
        WeightedEnsembleManager weightedEnsemble = new WeightedEnsembleManager(metric, this.numPerBin, md, file, true);
        weightedEnsemble.run(this.dynamicsOptions.getSteps(), this.stepsPer, this.dynamicsOptions.getTemperature(), this.dynamicsOptions.getDt());
        return this;
    }
}

