/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms.commands.test;

import edu.rit.pj.Comm;
import ffx.algorithms.cli.AlgorithmsCommand;
import ffx.utilities.FFXBinding;
import ffx.utilities.FFXCommand;
import java.util.ArrayList;
import java.util.List;
import picocli.CommandLine;

@CommandLine.Command(description={" Run a pH Scan with ManyBody."}, name="test.ManyBodyPHScan")
public class ManyBodyPhScan
extends AlgorithmsCommand {
    @CommandLine.Option(names={"--spH", "--startpH"}, paramLabel="0.0", defaultValue="0.0", description={"Lower end of the pH range to be evaluated."})
    private double start;
    @CommandLine.Option(names={"--epH", "--endpH"}, paramLabel="14.0", defaultValue="14.0", description={"Upper end of the pH range to be evaluated."})
    private double end;
    @CommandLine.Option(names={"--ns", "--nSteps"}, paramLabel="2.0", defaultValue="2.0", description={"Number of steps for a given pH range."})
    private double nSteps;
    @CommandLine.Unmatched
    private List<String> unmatched;

    public ManyBodyPhScan() {
    }

    public ManyBodyPhScan(FFXBinding binding) {
        super(binding);
    }

    public ManyBodyPhScan(String[] args) {
        super(args);
    }

    public ManyBodyPhScan run() {
        if (!this.init()) {
            return this;
        }
        System.setProperty("pj.use.mpi", "false");
        Class script = FFXCommand.getCommand((String)this.unmatched.get(0));
        Comm world = Comm.world();
        int numProc = world.size();
        int rank = world.rank();
        if (numProc > 1) {
            logger.info(String.format(" Number of processes:  %d", numProc));
            logger.info(String.format(" Rank of this process: %d", rank));
        }
        this.unmatched.remove(0);
        double stepSize = (this.end - this.start) / (this.nSteps - 1.0);
        int pHIndex = this.unmatched.indexOf("0.0");
        int i = 0;
        while ((double)i < this.nSteps) {
            double pHValue = this.start + stepSize * (double)i;
            ArrayList<String> commandArgs = new ArrayList<String>();
            for (String arg : this.unmatched) {
                this.unmatched.set(pHIndex, String.valueOf(pHValue));
                commandArgs.add(arg);
            }
            FFXBinding binding = new FFXBinding();
            binding.setVariable("args", commandArgs);
            try {
                FFXCommand command = (FFXCommand)script.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                command.setBinding(binding);
                command.run();
            }
            catch (Exception e) {
                logger.info(String.format(" Exception for pH value: %s", pHValue));
            }
            ++i;
        }
        System.clearProperty("pj.use.mpi");
        return this;
    }
}

