/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms.commands.test;

import ffx.algorithms.cli.AlgorithmsCommand;
import ffx.utilities.FFXBinding;
import java.util.List;
import org.apache.commons.math3.special.Erf;
import picocli.CommandLine;

@CommandLine.Command(description={" Calculate restraint free energy corrections."}, name="test.Freefix")
public class Freefix
extends AlgorithmsCommand {
    @CommandLine.Option(names={"--ri"}, paramLabel="0.00", defaultValue="0.00", description={"Constant Inner Radius value."})
    private double innerRadius;
    @CommandLine.Option(names={"--fi"}, paramLabel="0.0", defaultValue="0.0", description={"Constant Inner Force value."})
    private double innerForce;
    @CommandLine.Option(names={"--ro"}, paramLabel="0.00", defaultValue="0.00", description={"Constant Outer Radius value."})
    private double outerRadius;
    @CommandLine.Option(names={"--fo"}, paramLabel="15.0", defaultValue="15.0", description={"Constant Outer Force value."})
    private double outerForce;
    @CommandLine.Option(names={"--temp"}, paramLabel="298.0", defaultValue="298.0", description={"Constant Temperature value."})
    private double temperature;
    @CommandLine.Parameters(arity="1..*", paramLabel="files", description={"Atomic coordinate files in PDB or XYZ format."})
    private List<String> filenames;
    public static final double AVOGADRO = 6.02214076E23;
    public static final double STD_CONVERSION = 1660.5390671738467;

    public Freefix() {
    }

    public Freefix(FFXBinding binding) {
        super(binding);
    }

    public Freefix(String[] args) {
        super(args);
    }

    public Freefix run() {
        if (!this.init()) {
            return this;
        }
        if (this.innerForce == 0.0) {
            this.innerForce = 1.0;
            this.innerRadius = 0.0;
        }
        if (this.outerForce == 0.0) {
            this.outerForce = 1.0;
        }
        System.out.printf("%-35s %.4f Ang%n", "Inner Flat-Bottom Radius:", this.innerRadius);
        System.out.printf("%-35s %.4f Kcal/mole/Ang^2%n", "Inner Force Constant:", this.innerForce);
        System.out.printf("%-35s %.4f Ang%n", "Outer Flat-Bottom Radius:", this.outerRadius);
        System.out.printf("%-35s %.4f Kcal/mole/Ang^2%n", "Outer Force Constant:", this.outerForce);
        System.out.printf("%-35s %.4f Kelvin%n%n", "System Temperature Value:", this.temperature);
        double kB = 0.0019872041;
        double kt = kB * this.temperature;
        double[] volumeResults = Freefix.computeVolumeIntegrals(this.innerRadius, this.innerForce, this.outerRadius, this.outerForce, this.temperature);
        double vol = volumeResults[0];
        double dvol = volumeResults[1];
        logger.info(String.format("%-35s %.4f Ang^3%n", "Analytical Volume Integral:", vol));
        logger.info(String.format("%-35s %.4f Ang^3/K%n", "Analytical dVol/dT Value:", dvol));
        double dg = -kt * Math.log(vol / 1660.5390671738467);
        double ds = -dg / this.temperature + kt * dvol / vol;
        double dh = dg + this.temperature * ds;
        logger.info(String.format("%-35s %.4f Kcal/mole%n", "Restraint Free Energy:", dg));
        logger.info(String.format("%-35s %.4f Kcal/mole/K%n", "Restraint Entropy Value:", ds));
        logger.info(String.format("%-35s %.4f Kcal/mole%n", "Restraint Enthalpy Value:", dh));
        logger.info(String.format("%-35s %.4f Kcal/mole%n", "Restraint -T deltaS Value:", -this.temperature * ds));
        return this;
    }

    public static double[] computeVolumeIntegrals(double innerRadius, double innerForce, double outerRadius, double outerForce, double temperature) {
        double term1_v3;
        double kB = 0.0019872041;
        double kt = kB * temperature;
        double volume1 = 0.0;
        double volume3 = 0.0;
        if (innerRadius != 0.0) {
            double term1_v1 = Math.PI * 2 * innerRadius * (-2.0 + Math.exp(-Math.pow(innerRadius, 2.0) * innerForce / kt)) * kt / innerForce;
            double term2_v1 = Math.sqrt(kt * Math.pow(Math.PI / innerForce, 3.0)) * (2.0 * innerForce * Math.pow(innerRadius, 2.0) + kt) * Erf.erf((double)(innerRadius * Math.sqrt(innerForce / kt)));
            volume1 = term1_v1 + term2_v1;
        }
        double volume2 = 4.1887902047863905 * (Math.pow(outerRadius, 3.0) - Math.pow(innerRadius, 3.0));
        volume3 = outerRadius == 0.0 ? (term1_v3 = Math.sqrt(kt * Math.pow(Math.PI / outerForce, 3.0)) * kt) : (term1_v3 = Math.sqrt(kt * Math.pow(Math.PI / outerForce, 3.0)) * (2.0 * outerForce * Math.pow(outerRadius, 2.0) + kt + 4.0 * outerRadius * Math.sqrt(kt * outerForce / Math.PI)));
        double volume = volume1 + volume2 + volume3;
        double dv1 = innerRadius != 0.0 ? Freefix.computeDv1(innerRadius, innerForce, kt, temperature) : 0.0;
        double dv3 = outerRadius != 0.0 ? Freefix.computeDv3(outerRadius, outerForce, kt, temperature) : 1.5 * Math.pow(kt * Math.PI / outerForce, 1.5) / temperature;
        double dvolume = dv1 + dv3;
        return new double[]{volume, dvolume};
    }

    private static double computeDv1(double innerRadius, double innerForce, double kt, double temperature) {
        double term1_dv1 = Math.PI * 2 * Math.pow(innerRadius, 3.0) * Math.exp(-Math.pow(innerRadius, 2.0) * innerForce / kt) / temperature;
        double term2_dv1 = Math.PI * 2 * innerRadius * (-2.0 + Math.exp(-Math.pow(innerRadius, 2.0) * innerForce / kt)) * kt / (innerForce * temperature);
        double term3_dv1 = 0.5 * Math.sqrt(Math.pow(Math.PI / innerForce, 3.0)) * Math.sqrt(kt) * (2.0 * innerForce * Math.pow(innerRadius, 2.0) + kt) * Erf.erf((double)(innerRadius * Math.sqrt(innerForce / kt))) / temperature;
        double term4_dv1 = -Math.PI * innerRadius * Math.exp(-Math.pow(innerRadius, 2.0) * innerForce / kt) * (2.0 * innerForce * Math.pow(innerRadius, 2.0) + kt) / (innerForce * temperature);
        double term5_dv1 = Math.sqrt(Math.pow(kt * Math.PI / innerForce, 3.0)) * Erf.erf((double)(innerRadius * Math.sqrt(innerForce / kt))) / temperature;
        return term1_dv1 + term2_dv1 + term3_dv1 + term4_dv1 + term5_dv1;
    }

    private static double computeDv3(double outerRadius, double outerForce, double kt, double temperature) {
        double term1_dv3 = Math.sqrt(kt * Math.pow(Math.PI / outerForce, 3.0)) * outerForce * Math.pow(outerRadius, 2.0) / temperature;
        double term2_dv3 = 4.0 * kt * (Math.PI / outerForce) * outerRadius / temperature;
        double term3_dv3 = 1.5 * Math.sqrt(Math.pow(kt * Math.PI / outerForce, 3.0)) / temperature;
        return term1_dv3 + term2_dv3 + term3_dv3;
    }
}

