/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms.commands;

import ffx.algorithms.cli.AlgorithmsCommand;
import ffx.numerics.Potential;
import ffx.numerics.math.RunningStatistics;
import ffx.potential.bonded.Atom;
import ffx.potential.bonded.Bond;
import ffx.potential.parsers.SystemFilter;
import ffx.potential.utils.ProgressiveAlignmentOfCrystals;
import ffx.utilities.FFXBinding;
import ffx.utilities.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import org.apache.commons.io.FilenameUtils;
import picocli.CommandLine;

@CommandLine.Command(description={" Determine the RMSD for crystal polymorphs using the Progressive Alignment of Crystals (PAC) algorithm."}, name="SuperposeCrystals")
public class SuperposeCrystals
extends AlgorithmsCommand {
    @CommandLine.Option(names={"--ac", "--alchemicalAtoms"}, paramLabel="", defaultValue="", description={"Atom indices to be excluded from both crystals (e.g. 1-24,32-65). Use if molecular identity and atom ordering are the same for both crystals (otherwise use \"--ac1\" and \"--ac2\"."})
    private String excludeAtoms = "";
    @CommandLine.Option(names={"--ac1", "--alchemicalAtoms1"}, paramLabel="", defaultValue="", description={"Atom indices to be excluded in the first crystal (e.g. 1-24,32-65)."})
    private String excludeAtomsA = "";
    @CommandLine.Option(names={"--ac2", "--alchemicalAtoms2"}, paramLabel="", defaultValue="", description={"Atom indices to be excluded in the second crystal (e.g. 1-24,32-65)."})
    private String excludeAtomsB = "";
    @CommandLine.Option(names={"--ca", "--carbonAlphas"}, paramLabel="false", defaultValue="false", description={"Consider only alpha carbons for proteins."})
    private static boolean alphaCarbons;
    @CommandLine.Option(names={"--cd", "--createDirectories"}, paramLabel="false", defaultValue="false", description={"Create subdirectories for free energy simulations."})
    private static boolean createFE;
    @CommandLine.Option(names={"--as", "--autoSymmetry"}, paramLabel="false", defaultValue="false", description={"Automatically generate symmetry operators."})
    private static boolean autoSym;
    @CommandLine.Option(names={"--st", "--symTolerance"}, paramLabel="0.5", defaultValue="0.5", description={"Add atoms to torsion based symmetries that are beneath this cutoff."})
    private static double symTolerance;
    @CommandLine.Option(names={"--ws", "--writeSym"}, paramLabel="false", defaultValue="false", description={"Write the created symmetry operators in the corresponding Properties/Key file."})
    private static boolean writeSym;
    @CommandLine.Option(names={"--gc", "--gyrationComponents"}, paramLabel="false", defaultValue="false", description={"Display components for radius of gyration for final clusters."})
    private static boolean gyrationComponents;
    @CommandLine.Option(names={"--ht", "--hitTolerance"}, paramLabel="-1.0", defaultValue="-1.0", description={"Sum comparisons that attain a value lower than this tolerance."})
    private double hitTol;
    @CommandLine.Option(names={"--if", "--inflationFactor"}, paramLabel="5.0", defaultValue="5.0", description={"Inflation factor used to determine replicates expansion (IF * nAU in replicates)."})
    private double inflationFactor;
    @CommandLine.Option(names={"--ih", "--includeHydrogen"}, paramLabel="false", defaultValue="false", description={"Include hydrogen atoms."})
    private boolean includeHydrogen;
    @CommandLine.Option(names={"--in", "--inertia"}, paramLabel="false", defaultValue="false", description={"Display moments of inertia for final clusters."})
    private static boolean inertia;
    @CommandLine.Option(names={"-l", "--linkage"}, paramLabel="1", defaultValue="1", description={"Single (0), Average (1), or Complete (2) coordinate linkage for molecule prioritization."})
    private int linkage;
    @CommandLine.Option(names={"--lm", "--lowMemory"}, paramLabel="false", defaultValue="false", description={"Reduce memory usage at the cost of efficiency."})
    private static boolean lowMemory;
    @CommandLine.Option(names={"--mt", "--moleculeTolerance"}, paramLabel="0.0015", defaultValue="0.0015", description={"Tolerance to determine if two AUs are different."})
    private double matchTol;
    @CommandLine.Option(names={"--mw", "--massWeighted"}, paramLabel="false", defaultValue="false", description={"Use mass-weighted atomic coordinates for alignment."})
    private static boolean massWeighted;
    @CommandLine.Option(names={"--na", "--numAU"}, paramLabel="20", defaultValue="20", description={"Number of asymmetric units included to calculate the RMSD."})
    private int numAU;
    @CommandLine.Option(names={"--pc", "--prioritizeCrystals"}, paramLabel="0", defaultValue="0", description={"Prioritize crystals based on high density (0), low density (1), or file order (2)."})
    private int crystalPriority;
    @CommandLine.Option(names={"--ps", "--printSymOp"}, paramLabel="-1.0", defaultValue="-1.0", description={"Print optimal SymOp to align input crystals (print out atom deviations above value)."})
    private static double printSym;
    @CommandLine.Option(names={"-r", "--restart"}, paramLabel="false", defaultValue="false", description={"Restart from a previously written RMSD matrix (if one exists)."})
    private static boolean restart;
    @CommandLine.Option(names={"-s", "--save"}, paramLabel="-1.0", defaultValue="-1.0", description={"Save structures less than or equal to this cutoff."})
    private static double save;
    @CommandLine.Option(names={"--sc", "--saveClusters"}, paramLabel="0", defaultValue="0", description={"Save files for the superposed crystal clusters (1=PDB, 2=XYZ)."})
    private static int saveClusters;
    @CommandLine.Option(names={"--sm", "--saveMachineLearning"}, paramLabel="false", defaultValue="false", description={"Final structures for each comparison will be written out with RMSD in a CSV."})
    private static boolean machineLearning;
    @CommandLine.Option(names={"--th", "--thorough"}, paramLabel="false", defaultValue="false", description={"More intensive, less efficient version of PAC."})
    private static boolean thorough;
    @CommandLine.Option(names={"-w", "--write"}, paramLabel="false", defaultValue="false", description={"Write out the PAC RMSD matrix."})
    private static boolean write;
    @CommandLine.Option(names={"--zp", "--zPrime"}, paramLabel="-1", defaultValue="-1", description={"Z'' for both crystals (assumes same value)."})
    private int zPrime;
    @CommandLine.Option(names={"--zp1", "--zPrime1"}, paramLabel="-1", defaultValue="-1", description={"Z'' for crystal 1 (default will try to autodetect)."})
    private int zPrime1;
    @CommandLine.Option(names={"--zp2", "--zPrime2"}, paramLabel="-1", defaultValue="-1", description={"Z'' for crystal 2 (default will try to autodetect)."})
    private int zPrime2;
    @CommandLine.Parameters(arity="1..2", paramLabel="files", description={"Atomic coordinate file(s) to compare in XYZ format."})
    List<String> filenames = null;
    private final List<Atom> previouslyIncludedBase = new ArrayList<Atom>();
    private final List<Integer> queueIndices = new ArrayList<Integer>();
    public RunningStatistics runningStatistics;
    public final StringBuilder symOpsA = new StringBuilder();
    public final StringBuilder symOpsB = new StringBuilder();

    public SuperposeCrystals() {
    }

    public SuperposeCrystals(FFXBinding binding) {
        super(binding);
    }

    public SuperposeCrystals(String[] args) {
        super(args);
    }

    /*
     * WARNING - void declaration
     */
    public SuperposeCrystals run() {
        SystemFilter targetFilter;
        System.setProperty("vdwterm", "false");
        if (!this.init()) {
            return this;
        }
        if (this.filenames == null) {
            logger.info(this.helpString());
            return this;
        }
        this.algorithmFunctions.openAll(this.filenames.get(0));
        SystemFilter baseFilter = this.algorithmFunctions.getFilter();
        boolean isSymmetric = false;
        int numFiles = this.filenames.size();
        if (numFiles == 1) {
            logger.info("\n PAC will be applied between all pairs of conformations within the supplied file.\n");
            isSymmetric = true;
            this.algorithmFunctions.openAll(this.filenames.get(0));
            targetFilter = this.algorithmFunctions.getFilter();
        } else {
            logger.info("\n PAC will compare all conformations in the first file to all those in the second file.\n");
            this.algorithmFunctions.openAll(this.filenames.get(1));
            targetFilter = this.algorithmFunctions.getFilter();
            String filenameA = FilenameUtils.getBaseName((String)this.filenames.get(0));
            String filenameB = FilenameUtils.getBaseName((String)this.filenames.get(1));
            this.symOpsA.append(String.format("\n Add the following symop to properties/key file of %s (Apply on %s to generate %s):\nsymop", filenameA, filenameB, filenameA));
            this.symOpsB.append(String.format("\n\n Add the following symop to properties/key file of %s (Apply on %s to generate %s):\nsymop", filenameB, filenameA, filenameB));
        }
        String filename = this.filenames.get(0);
        String pacFilename = FilenameUtils.concat((String)FilenameUtils.getFullPath((String)filename), (String)(FilenameUtils.getBaseName((String)filename) + ".dst"));
        if (this.zPrime > 0 && this.zPrime % 1 == 0) {
            this.zPrime1 = this.zPrime;
            this.zPrime2 = this.zPrime;
        }
        if (printSym < 0.0 && writeSym || autoSym) {
            logger.info("\n Printing distance for atoms greater than large distance of 10.0 \u00c5");
            printSym = 10.0;
        }
        if (createFE) {
            lowMemory = true;
        }
        if (autoSym) {
            void var20_33;
            Object sb;
            int i;
            boolean loggerLevelChanged = false;
            if (logger.isLoggable(Level.INFO) && !logger.isLoggable(Level.FINE)) {
                loggerLevelChanged = true;
                logger.setLevel(Level.WARNING);
            }
            Atom[] atomsBase = baseFilter.getActiveMolecularSystem().getAtomArray();
            Atom[] atomsTarget = targetFilter.getActiveMolecularSystem().getAtomArray();
            int nAtomsBase = atomsBase.length;
            int nAtomsTarget = atomsTarget.length;
            ArrayList smallAtomGroups = new ArrayList();
            ArrayList<Double> smallGroupsRMSD = new ArrayList<Double>();
            ArrayList<Atom> mapBaseAtoms = new ArrayList<Atom>();
            ArrayList<Integer> mapBaseIndices = new ArrayList<Integer>();
            ArrayList<Atom> mapTargetAtoms = new ArrayList<Atom>();
            ArrayList<Integer> mapTargetIndices = new ArrayList<Integer>();
            if (!this.excludeAtoms.isEmpty()) {
                List alchAtoms = StringUtils.parseAtomRanges((String)"AutoSym", (String)this.excludeAtoms, (int)nAtomsBase);
                for (i = 0; i < nAtomsBase - 1; ++i) {
                    if (!alchAtoms.contains(i + 1)) {
                        logger.warning(String.format(" Include Atoms for both:\n %s\n %s.", atomsBase[i].toString(), atomsTarget[i].toString()));
                        mapBaseIndices.add(i + 1);
                        mapBaseAtoms.add(atomsBase[i]);
                        mapTargetIndices.add(i + 1);
                        mapTargetAtoms.add(atomsTarget[i]);
                        continue;
                    }
                    this.previouslyIncludedBase.add(atomsBase[i]);
                }
            } else if (!this.excludeAtomsA.isEmpty() || !this.excludeAtomsB.isEmpty()) {
                logger.warning(String.format(" Independent alchemical atoms has not been implemented.", new Object[0]));
            }
            assert (mapBaseIndices.size() == mapBaseAtoms.size());
            assert (mapTargetIndices.size() == mapTargetAtoms.size());
            if (mapBaseAtoms.size() != mapTargetAtoms.size()) {
                logger.warning(String.format(" Error in atom selection. Base size of %3d does not match Target size of %3d.", mapBaseAtoms.size(), mapTargetAtoms.size()));
                if (logger.isLoggable(Level.FINE)) {
                    sb = new StringBuilder();
                    for (Integer n : mapBaseIndices) {
                        ((StringBuilder)sb).append(n).append(",");
                    }
                    ((StringBuilder)sb).append("\n");
                    logger.fine(" Base indices:" + ((StringBuilder)sb).toString());
                    ((StringBuilder)sb).setLength(0);
                    for (Integer n : mapTargetIndices) {
                        ((StringBuilder)sb).append(n).append(",");
                    }
                    ((StringBuilder)sb).append("\n");
                    logger.fine(" Target indices:" + ((StringBuilder)sb).toString());
                }
                return this;
            }
            sb = atomsBase;
            i = ((Atom[])sb).length;
            boolean bl = false;
            while (var20_33 < i) {
                Atom a = sb[var20_33];
                if (!this.previouslyIncludedBase.contains(a)) {
                    this.queueIndices.clear();
                    this.addAtomIndex(a);
                    ArrayList<Atom> arrayList = new ArrayList<Atom>();
                    for (Integer n : this.queueIndices) {
                        arrayList.add(atomsBase[n - 1]);
                    }
                    if (arrayList.size() < 3) {
                        boolean groupFound = false;
                        for (Atom atom : arrayList) {
                            Bond[] bondArray;
                            for (Bond bond : bondArray = atom.getBonds().toArray(new Bond[0])) {
                                Atom atomGrouped = bond.get1_2(atom);
                                for (List list : smallAtomGroups) {
                                    if (list.contains(atomGrouped)) {
                                        groupFound = true;
                                        for (Atom atomNeedingGroup : arrayList) {
                                            list.add(atomNeedingGroup);
                                        }
                                    }
                                    if (!groupFound) continue;
                                    break;
                                }
                                if (groupFound) break;
                            }
                            if (!groupFound) continue;
                            break;
                        }
                    } else {
                        smallAtomGroups.add(arrayList);
                    }
                }
                ++var20_33;
            }
            block9: for (int i2 = 0; i2 < nAtomsBase; ++i2) {
                Bond[] bondArray;
                Atom atom = atomsBase[i2];
                boolean bl2 = false;
                for (List list : smallAtomGroups) {
                    if (!list.contains(atom)) continue;
                    bl2 = true;
                    break;
                }
                if (bl2) continue;
                boolean groupFound = false;
                for (Bond bond : bondArray = atom.getBonds().toArray(new Bond[0])) {
                    Atom atomGrouped = bond.get1_2(atom);
                    for (List list : smallAtomGroups) {
                        if (list.contains(atomGrouped)) {
                            groupFound = true;
                            list.add(atom);
                        }
                        if (!groupFound) continue;
                        break;
                    }
                    if (groupFound) continue block9;
                }
            }
            StringBuilder sb2 = new StringBuilder(" Small Groups:\n");
            for (List list : smallAtomGroups) {
                void var22_49;
                ArrayList<Integer> includeIndices = new ArrayList<Integer>();
                sb2.append(" New Group: ");
                for (Atom atom : list) {
                    sb2.append(atom.getIndex() + ", ");
                    includeIndices.add(atom.getIndex());
                }
                sb2.append("\n");
                this.excludeAtoms = "";
                boolean bl3 = false;
                while (var22_49 < nAtomsBase) {
                    void ind = var22_49 + true;
                    if (!includeIndices.contains((int)ind) && this.excludeAtoms.length() == 0) {
                        this.excludeAtoms = String.valueOf((int)ind);
                    } else if (!includeIndices.contains((int)ind)) {
                        this.excludeAtoms = this.excludeAtoms + "," + (int)ind;
                    }
                    ++var22_49;
                }
                if (this.excludeAtoms == null || this.excludeAtoms.isEmpty()) continue;
                this.excludeAtomsA = this.excludeAtoms;
                this.excludeAtomsB = this.excludeAtoms;
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("A: " + this.excludeAtomsA);
                    logger.fine("B: " + this.excludeAtomsB);
                }
                ProgressiveAlignmentOfCrystals progressiveAlignmentOfCrystals = new ProgressiveAlignmentOfCrystals(baseFilter, targetFilter, isSymmetric);
                this.runningStatistics = progressiveAlignmentOfCrystals.comparisons(this.numAU, this.inflationFactor, this.matchTol, this.hitTol, this.zPrime1, this.zPrime2, this.excludeAtomsA, this.excludeAtomsB, alphaCarbons, this.includeHydrogen, massWeighted, this.crystalPriority, thorough, saveClusters, save, restart, write, machineLearning, inertia, gyrationComponents, this.linkage, printSym, lowMemory, createFE, false, pacFilename, new StringBuilder(""), new StringBuilder(""));
                double min = this.runningStatistics.getMin();
                smallGroupsRMSD.add(min);
            }
            logger.info(sb2.toString());
            int numGroups = smallAtomGroups.size();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(String.format(" Number of minimal groups: %3d", numGroups));
            }
            int[][] nArrayArray = new int[numGroups][];
            for (int i3 = 0; i3 < numGroups; ++i3) {
                List list = (List)smallAtomGroups.get(i3);
                int currentSize = list.size();
                nArrayArray[i3] = new int[currentSize];
                for (int j = 0; j < currentSize; ++j) {
                    nArrayArray[i3][j] = ((Atom)list.get(j)).getIndex();
                }
            }
            ArrayList finalGroups = new ArrayList();
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            ArrayList<Integer> queuedIndices = new ArrayList<Integer>();
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            for (int i4 = 0; i4 < numGroups; ++i4) {
                List list = (List)smallAtomGroups.get(i4);
                int[] currentIndexGroup = nArrayArray[i4];
                int numAtomsInGroup = list.size();
                arrayList.clear();
                queuedIndices.clear();
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(String.format(" Minimal group number: %3d Size: %3d RMSD: %9.3f", i4, numAtomsInGroup, smallGroupsRMSD.get(i4)));
                }
                if (arrayList2.contains(i4)) continue;
                for (int index : currentIndexGroup) {
                    arrayList.add(index);
                }
                arrayList2.add(i4);
                if ((Double)smallGroupsRMSD.get(i4) > symTolerance) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine(String.format(" Run (group) %3d added outright to final.", i4));
                    }
                } else {
                    void var29_91;
                    boolean bl4 = false;
                    while (var29_91 < arrayList.size()) {
                        Bond[] b1;
                        Atom a1 = atomsBase[(Integer)arrayList.get((int)var29_91) - 1];
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine(String.format(" Current group: %3d Atom in Group: %3d of %3d (was %3d==%3d) Atom Index: %3d", i4, (int)var29_91, arrayList.size(), numAtomsInGroup, currentIndexGroup.length, a1.getIndex()));
                        }
                        for (Bond b : b1 = a1.getBonds().toArray(new Bond[0])) {
                            Atom a2 = b.get1_2(a1);
                            int a2Index = a2.getIndex();
                            boolean currentIndexGroupContains = false;
                            for (int idx : currentIndexGroup) {
                                if (idx != a2Index) continue;
                                currentIndexGroupContains = true;
                                break;
                            }
                            if (currentIndexGroupContains) continue;
                            for (int k = 0; k < numGroups; ++k) {
                                int[] currentIndexGroup2 = nArrayArray[k];
                                boolean currentIndexGroup2Contains = false;
                                for (int idx : currentIndexGroup2) {
                                    if (idx != a2Index) continue;
                                    currentIndexGroup2Contains = true;
                                    break;
                                }
                                if (arrayList2.contains(k) || !((Double)smallGroupsRMSD.get(k) < symTolerance) || !currentIndexGroup2Contains) continue;
                                for (int ind : currentIndexGroup2) {
                                    queuedIndices.add(ind);
                                }
                                this.excludeAtoms = "";
                                for (int l = 0; l < nAtomsBase; ++l) {
                                    boolean exclude;
                                    int ind = l + 1;
                                    boolean bl5 = exclude = !arrayList.contains(ind) && !queuedIndices.contains(ind);
                                    if (!exclude) continue;
                                    this.excludeAtoms = this.excludeAtoms.length() == 0 ? String.valueOf(ind) : this.excludeAtoms + "," + ind;
                                }
                                this.excludeAtomsA = this.excludeAtoms;
                                this.excludeAtomsB = this.excludeAtoms;
                                if (logger.isLoggable(Level.FINE)) {
                                    logger.fine(" Excluded atoms A: " + this.excludeAtomsA);
                                    logger.fine(" Excluded atoms B: " + this.excludeAtomsB);
                                }
                                ProgressiveAlignmentOfCrystals pac = new ProgressiveAlignmentOfCrystals(baseFilter, targetFilter, isSymmetric);
                                this.runningStatistics = pac.comparisons(this.numAU, this.inflationFactor, this.matchTol, this.hitTol, this.zPrime1, this.zPrime2, this.excludeAtomsA, this.excludeAtomsB, alphaCarbons, this.includeHydrogen, massWeighted, this.crystalPriority, thorough, saveClusters, save, restart, write, machineLearning, inertia, gyrationComponents, this.linkage, printSym, lowMemory, createFE, false, pacFilename, new StringBuilder(""), new StringBuilder(""));
                                double min = this.runningStatistics.getMin();
                                if (min > symTolerance) {
                                    if (logger.isLoggable(Level.FINE)) {
                                        logger.fine(String.format(" Run %3d Group %3d failed with RMSD %9.3f > tolerance (%9.3f).", i4, k, min, symTolerance));
                                    }
                                    queuedIndices.clear();
                                    continue;
                                }
                                for (Integer value : queuedIndices) {
                                    if (arrayList.contains(value)) continue;
                                    arrayList.add(value);
                                }
                                if (logger.isLoggable(Level.FINE)) {
                                    logger.fine(String.format(" Run %3d Group %3d added to accepted with RMSD: %9.3f.", i4, k, min));
                                }
                                arrayList2.add(k);
                            }
                        }
                        ++var29_91;
                    }
                }
                ArrayList<Integer> arrayList3 = new ArrayList<Integer>(arrayList.size());
                arrayList3.addAll(arrayList);
                finalGroups.add(arrayList3);
                if (!logger.isLoggable(Level.FINE)) continue;
                logger.fine(String.format(" Run %3d accepted atoms (size: %3d) added to finalGroups (size: %3d)", i4, arrayList.size(), finalGroups.size()));
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(String.format(" Final Num Groups: %3d", finalGroups.size()));
            }
            if (loggerLevelChanged) {
                logger.setLevel(Level.INFO);
            }
            for (ArrayList arrayList4 : finalGroups) {
                int groupSize = arrayList4.size();
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(String.format(" Final Size: %3d", groupSize));
                }
                if (groupSize <= 0) {
                    logger.warning(" Final group of size zero was encountered. Check selection logic.");
                    continue;
                }
                queuedIndices.clear();
                for (Integer n : arrayList4) {
                    queuedIndices.add(n);
                }
                this.excludeAtoms = "";
                for (int l = 0; l < nAtomsBase; ++l) {
                    int n = l + 1;
                    if (!queuedIndices.contains(n) && this.excludeAtoms.length() == 0) {
                        this.excludeAtoms = String.valueOf(n);
                        continue;
                    }
                    if (queuedIndices.contains(n)) continue;
                    this.excludeAtoms = this.excludeAtoms + "," + n;
                }
                this.excludeAtomsA = this.excludeAtoms;
                this.excludeAtomsB = this.excludeAtoms;
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("A: " + this.excludeAtomsA);
                    logger.fine("B: " + this.excludeAtomsB);
                }
                ProgressiveAlignmentOfCrystals pac = new ProgressiveAlignmentOfCrystals(baseFilter, targetFilter, isSymmetric);
                this.runningStatistics = pac.comparisons(this.numAU, this.inflationFactor, this.matchTol, this.hitTol, this.zPrime1, this.zPrime2, this.excludeAtomsA, this.excludeAtomsB, alphaCarbons, this.includeHydrogen, massWeighted, this.crystalPriority, thorough, saveClusters, save, restart, write, machineLearning, inertia, gyrationComponents, this.linkage, printSym, lowMemory, createFE, writeSym, pacFilename, this.symOpsA, this.symOpsB);
            }
        } else {
            if (this.excludeAtoms != null && !this.excludeAtoms.isEmpty()) {
                this.excludeAtomsA = this.excludeAtoms;
                this.excludeAtomsB = this.excludeAtoms;
            }
            ProgressiveAlignmentOfCrystals pac = new ProgressiveAlignmentOfCrystals(baseFilter, targetFilter, isSymmetric);
            this.runningStatistics = pac.comparisons(this.numAU, this.inflationFactor, this.matchTol, this.hitTol, this.zPrime1, this.zPrime2, this.excludeAtomsA, this.excludeAtomsB, alphaCarbons, this.includeHydrogen, massWeighted, this.crystalPriority, thorough, saveClusters, save, restart, write, machineLearning, inertia, gyrationComponents, this.linkage, printSym, lowMemory, createFE, writeSym, pacFilename, this.symOpsA, this.symOpsB);
        }
        if (printSym >= 0.0) {
            int finalCharB;
            int finalCharA = this.symOpsA.length() - 2;
            if (this.symOpsA.substring(finalCharA).equals("\\\n")) {
                this.symOpsA.setLength(finalCharA);
            }
            if (this.symOpsB.substring(finalCharB = this.symOpsB.length() - 2).equals("\\\n")) {
                this.symOpsB.setLength(finalCharB);
            }
            if (this.symOpsA.indexOf("\\") >= 0 && this.symOpsB.indexOf("\\") >= 0) {
                logger.info(this.symOpsA.toString() + this.symOpsB.toString());
            } else if (logger.isLoggable(Level.FINE)) {
                logger.fine(" Following generated SymOp strings did not contain symmetry operators." + this.symOpsA.toString() + this.symOpsB.toString());
            }
        }
        baseFilter.closeReader();
        targetFilter.closeReader();
        return this;
    }

    private void addAtomIndex(Atom aAdded) {
        if (!this.previouslyIncludedBase.contains(aAdded)) {
            Bond[] bonds4Added;
            this.queueIndices.add(aAdded.getIndex());
            this.previouslyIncludedBase.add(aAdded);
            int numBondsAdded = aAdded.getNumBonds();
            int numHAdded = aAdded.getNumberOfBondedHydrogen();
            int nonHbonds = numBondsAdded - numHAdded;
            for (Bond b : bonds4Added = aAdded.getBonds().toArray(new Bond[0])) {
                Atom aBond2B2A;
                Atom aBound2Added = b.get1_2(aAdded);
                if (nonHbonds == 1) {
                    this.addAtomIndex(aBound2Added);
                    for (Bond bAdded : bonds4Added) {
                        Atom a3 = bAdded.get1_2(aAdded);
                        if (!a3.isHydrogen()) continue;
                        this.addAtomIndex(a3);
                    }
                }
                int numBondsB2A = aBound2Added.getNumBonds();
                int numHB2A = aBound2Added.getNumberOfBondedHydrogen();
                int nonHB2A = numBondsB2A - numHB2A;
                Bond[] bondsB2A = aBound2Added.getBonds().toArray(new Bond[0]);
                if (nonHB2A == 1) {
                    this.addAtomIndex(aBound2Added);
                    for (Bond b2a : bondsB2A) {
                        aBond2B2A = b2a.get1_2(aBound2Added);
                        if (!aBond2B2A.isHydrogen()) continue;
                        this.addAtomIndex(aBond2B2A);
                    }
                    continue;
                }
                if (numBondsAdded == 1 || numBondsB2A == 1) {
                    this.addAtomIndex(aBound2Added);
                    continue;
                }
                if (nonHB2A == 2) {
                    this.addAtomIndex(aBound2Added);
                    for (Bond b2a : bondsB2A) {
                        aBond2B2A = b2a.get1_2(aBound2Added);
                        if (!aBond2B2A.isHydrogen()) continue;
                        this.addAtomIndex(aBond2B2A);
                    }
                    continue;
                }
                for (Bond b2a : bondsB2A) {
                    int numBonds2B2A;
                    aBond2B2A = b2a.get1_2(aBound2Added);
                    if (aBond2B2A.isHydrogen() || nonHbonds != 1 || (numBonds2B2A = aBond2B2A.getNumBonds()) != 1 || !aBond2B2A.isBonded(aBound2Added) && !aBond2B2A.isBonded(aAdded)) continue;
                    this.addAtomIndex(aBond2B2A);
                }
            }
        }
    }

    @Override
    public List<Potential> getPotentials() {
        return Collections.emptyList();
    }
}

