/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms.commands;

import ffx.algorithms.cli.AlgorithmsCommand;
import ffx.numerics.Potential;
import ffx.potential.MolecularAssembly;
import ffx.potential.bonded.AminoAcidUtils;
import ffx.potential.bonded.Atom;
import ffx.potential.bonded.Residue;
import ffx.potential.cli.AtomSelectionOptions;
import ffx.potential.parsers.SystemFilter;
import ffx.utilities.FFXBinding;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import picocli.CommandLine;

@CommandLine.Command(description={" Superpose frames one or two trajectory files to calculate RMSD."}, name="Superpose")
public class Superpose
extends AlgorithmsCommand {
    @CommandLine.Mixin
    private AtomSelectionOptions atomSelectionOptions;
    @CommandLine.Option(names={"--bb", "--backboneSelection"}, paramLabel="-1", defaultValue="-1", description={"Restrict selection to backbone atoms [0 == C_ALPHA or 1 == BACKBONE]. Note C_ALPHA uses N1 or N9 for NA."})
    private int backboneSelection;
    @CommandLine.Option(names={"--ih", "--includeHydrogen"}, paramLabel="false", defaultValue="false", description={"Include hydrogen atoms."})
    private static boolean includeHydrogen;
    @CommandLine.Option(names={"--ss", "--secondaryStructure"}, paramLabel="", defaultValue="", description={"Restrict selection using a secondary structure string."})
    private String secondaryStructure;
    @CommandLine.Option(names={"--dRMSD"}, paramLabel="false", defaultValue="false", description={"Calculate dRMSD in addition to RMSD."})
    private boolean dRMSD;
    @CommandLine.Option(names={"--ps", "--printSymOp"}, paramLabel="false", defaultValue="false", description={"Print optimal SymOp to align input structures."})
    private static boolean printSym;
    @CommandLine.Option(names={"-w", "--write"}, paramLabel="false", defaultValue="false", description={"Write out the RMSD matrix."})
    private static boolean write;
    @CommandLine.Option(names={"-r", "--restart"}, paramLabel="false", defaultValue="false", description={"Attempt to restart from a previously written RMSD matrix."})
    private static boolean restart;
    @CommandLine.Option(names={"--save", "--saveSnapshots"}, paramLabel="false", defaultValue="false", description={"Save superposed snapshots (only for single process jobs)."})
    private boolean saveSnapshots;
    @CommandLine.Option(names={"-v", "--verbose"}, paramLabel="true", defaultValue="true", description={"Write out RMSD information."})
    private boolean verbose;
    @CommandLine.Parameters(arity="1..2", paramLabel="files", description={"Atomic coordinate file(s) to compare in PDB or XYZ format."})
    List<String> filenames = null;

    public Superpose() {
    }

    public Superpose(FFXBinding binding) {
        super(binding);
    }

    public Superpose(String[] args) {
        super(args);
    }

    public Superpose run() {
        SystemFilter targetFilter;
        if (!this.init() || this.filenames == null || this.filenames.size() < 1) {
            return this;
        }
        System.setProperty("vdwterm", "false");
        this.activeAssembly = this.getActiveAssembly(this.filenames.get(0));
        if (this.activeAssembly == null) {
            logger.info(this.helpString());
            return this;
        }
        SystemFilter baseFilter = this.algorithmFunctions.getFilter();
        int numFiles = this.filenames.size();
        boolean isSymmetric = false;
        if (numFiles == 1) {
            logger.info("\n Superpose will be applied between all pairs of conformations within the supplied file.\n");
            isSymmetric = true;
            this.algorithmFunctions.openAll(this.filenames.get(0));
            targetFilter = this.algorithmFunctions.getFilter();
        } else {
            logger.info("\n Superpose will compare all conformations in the first file to all those in the second file.\n");
            this.algorithmFunctions.openAll(this.filenames.get(1));
            targetFilter = this.algorithmFunctions.getFilter();
        }
        this.atomSelectionOptions.setActiveAtoms(this.activeAssembly);
        List<List<Integer>> helices = null;
        List<List<Integer>> sheets = null;
        boolean applySS = false;
        if (!this.secondaryStructure.isEmpty()) {
            this.secondaryStructure = this.validateSecondaryStructurePrediction(this.activeAssembly);
            this.checkForAppropriateResidueIdentities(this.activeAssembly);
            String helixChar = "H";
            String sheetChar = "E";
            helices = Superpose.extractSecondaryElement(this.secondaryStructure, helixChar, 2);
            sheets = Superpose.extractSecondaryElement(this.secondaryStructure, sheetChar, 2);
            if (!helices.isEmpty() || !sheets.isEmpty()) {
                applySS = true;
            }
        }
        Atom[] atoms = this.activeAssembly.getAtomArray();
        ArrayList<Integer> selectedList = new ArrayList<Integer>();
        for (Atom atom : atoms) {
            if (!includeHydrogen && atom.isActive() && atom.isHydrogen()) {
                atom.setActive(false);
            }
            if (applySS && atom.isActive() && !Superpose.isSS(helices, sheets, atom)) {
                atom.setActive(false);
            }
            if (this.backboneSelection > -1 && atom.isActive()) {
                if (this.backboneSelection == 0) {
                    if (!(atom.getName().equals("CA") || atom.getName().equals("N1") || atom.getName().equals("N9"))) {
                        atom.setActive(false);
                    }
                } else if (!(this.backboneSelection != 1 || atom.getName().equals("CA") || atom.getName().equals("N") || atom.getName().equals("C"))) {
                    atom.setActive(false);
                }
            }
            if (!atom.isActive()) continue;
            selectedList.add(atom.getIndex() - 1);
        }
        int nSelected = selectedList.size();
        int[] usedIndices = new int[nSelected];
        for (int i = 0; i < nSelected; ++i) {
            usedIndices[i] = (Integer)selectedList.get(i);
        }
        for (Atom atom : atoms) {
            atom.setActive(true);
        }
        ffx.potential.utils.Superpose superpose = new ffx.potential.utils.Superpose(baseFilter, targetFilter, isSymmetric);
        superpose.calculateRMSDs(usedIndices, this.dRMSD, this.verbose, restart, write, this.saveSnapshots, printSym);
        return this;
    }

    private static boolean isSS(List<List<Integer>> helices, List<List<Integer>> sheets, Atom atom) {
        int resNum = atom.getResidueNumber() - 1;
        boolean isHelix = false;
        for (List<Integer> helix : helices) {
            if (resNum < helix.get(0) || resNum > helix.get(1)) continue;
            isHelix = true;
            break;
        }
        boolean isSheet = false;
        for (List<Integer> sheet : sheets) {
            if (resNum < sheet.get(0) || resNum > sheet.get(1)) continue;
            isSheet = true;
            break;
        }
        return isHelix || isSheet;
    }

    static List<List<Integer>> extractSecondaryElement(String ss, String elementType, int minNumResidues) {
        ArrayList<List<Integer>> allElements = new ArrayList<List<Integer>>();
        int lastMatch = 0;
        int i = 0;
        while (i < ss.length()) {
            if (ss.charAt(i) == elementType.charAt(0)) {
                int elementStartIndex = i;
                for (int j = i + 1; j <= ss.length(); ++j) {
                    ArrayList<Integer> currentElement;
                    int elementLength;
                    if (j < ss.length()) {
                        if (ss.charAt(j) != elementType.charAt(0)) {
                            if (j == lastMatch + 1) {
                                i = j;
                                elementLength = j - elementStartIndex;
                                if (elementLength > minNumResidues) {
                                    currentElement = new ArrayList<Integer>();
                                    currentElement.add(elementStartIndex);
                                    currentElement.add(lastMatch);
                                    allElements.add(currentElement);
                                }
                                j = ss.length() + 1;
                            }
                        } else {
                            lastMatch = j;
                            ++i;
                        }
                    }
                    if (j != ss.length()) continue;
                    i = ss.length() + 1;
                    if (j != lastMatch + 1) continue;
                    elementLength = j - elementStartIndex;
                    if (elementLength > minNumResidues) {
                        currentElement = new ArrayList();
                        currentElement.add(elementStartIndex);
                        currentElement.add(lastMatch);
                        allElements.add(currentElement);
                    }
                    j = ss.length() + 1;
                }
                continue;
            }
            ++i;
        }
        return allElements;
    }

    String validateSecondaryStructurePrediction(MolecularAssembly molecularAssembly) {
        if (!this.secondaryStructure.matches("^[HE.]+") && !this.secondaryStructure.isEmpty()) {
            logger.severe(" Secondary structure restraints may only contain characters 'H', 'E' and '.'");
        }
        int numResidues = molecularAssembly.getResidueList().size();
        int numSecondaryStructure = this.secondaryStructure.length();
        if (numSecondaryStructure == 0) {
            logger.warning(" No secondary structure restraints have been provided. Simulation will proceed with all residues having random coil secondary structure restraints.");
            String randomCoil = StringUtils.leftPad((String)"", (int)numResidues, (String)".");
            return randomCoil;
        }
        if (numSecondaryStructure < numResidues) {
            logger.warning(" Too few secondary structure restraints exist for number of residues present. Random coil will be added to end residues without provided secondary structure restraints.");
            String extraCoil = StringUtils.rightPad((String)this.secondaryStructure, (int)numResidues, (char)'.');
            return extraCoil;
        }
        if (numSecondaryStructure == numResidues) {
            logger.info(" Secondary structure restraints will be added for all residues.");
            return this.secondaryStructure;
        }
        if (numSecondaryStructure > numResidues) {
            logger.warning(" Too many secondary structure restraints exist for number of residues present. Provided secondary structure restraints will be truncated.");
            String truncated = this.secondaryStructure.substring(0, numResidues);
            return truncated;
        }
        logger.severe(" Secondary structure restraints or residues do not exist.");
        return null;
    }

    void checkForAppropriateResidueIdentities(MolecularAssembly molecularAssembly) {
        List residues = molecularAssembly.getResidueList();
        for (int i = 0; i < this.secondaryStructure.length(); ++i) {
            Residue residue = (Residue)residues.get(i);
            AminoAcidUtils.AminoAcid3 aminoAcid3 = residue.getAminoAcid3();
            String aminoAcidString = aminoAcid3.toString();
            String NMEString = AminoAcidUtils.AminoAcid3.NME.toString();
            String ACEString = AminoAcidUtils.AminoAcid3.ACE.toString();
            if (!aminoAcidString.equals(NMEString) && !aminoAcidString.equals(ACEString)) continue;
            char character = this.secondaryStructure.charAt(i);
            char H = 'H';
            char E = 'E';
            if (character == H) {
                logger.info(" Secondary structure was modified to accommodate non-standard amino acid residue.");
                this.secondaryStructure = this.secondaryStructure.substring(0, i) + "." + this.secondaryStructure.substring(i + 1);
                continue;
            }
            if (character != E) continue;
            logger.info(" Secondary structure was modified to accommodate non-standard amino acid residue.");
            this.secondaryStructure = this.secondaryStructure.substring(0, i) + "." + this.secondaryStructure.substring(i + 1);
        }
    }

    @Override
    public List<Potential> getPotentials() {
        return Collections.emptyList();
    }
}

