/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms.commands;

import ffx.algorithms.cli.AlgorithmsCommand;
import ffx.numerics.Potential;
import ffx.potential.MolecularAssembly;
import ffx.potential.cli.AlchemicalOptions;
import ffx.potential.cli.TopologyOptions;
import ffx.potential.parsers.SystemFilter;
import ffx.potential.parsers.XYZFilter;
import ffx.potential.utils.PotentialsFunctions;
import ffx.utilities.FFXBinding;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.configuration2.CompositeConfiguration;
import org.apache.commons.io.FilenameUtils;
import picocli.CommandLine;

@CommandLine.Command(description={" Unwind .ARC files for nWindows"}, name="SortArc")
public class SortArc
extends AlgorithmsCommand {
    @CommandLine.Mixin
    private AlchemicalOptions alchemicalOptions;
    @CommandLine.Mixin
    private TopologyOptions topologyOptions;
    @CommandLine.Option(names={"--nw", "--nWindows"}, paramLabel="-1", description={"If set, auto-determine lambda values and subdirectories (overrides other flags)."})
    private int nWindows = -1;
    @CommandLine.Option(names={"--bT", "--sortByTemp"}, paramLabel="false", description={"If set, sort archive files by temperature values"})
    private boolean sortTemp = false;
    @CommandLine.Option(names={"--sT", "--startTemp"}, paramLabel="298.15", defaultValue="298.15", description={"Sets the starting temperature for the exponential temperature ladder if sorting by temperature."})
    private double lowTemperature = 298.15;
    @CommandLine.Option(names={"--ex", "--exponent"}, paramLabel="0.5", defaultValue="0.5", description={"Sets the exponent for the exponential temperature ladder if sorting by temperature."})
    private double exponent = 0.05;
    @CommandLine.Parameters(arity="1..*", paramLabel="files", description={"Trajectory files for the first end of the window, followed by trajectories for the other end"})
    List<String> filenames = null;
    private double[] lambdaValues;
    private double[] temperatureValues;
    private SystemFilter[] openers;
    private SystemFilter[][] writers;
    private String[] files;
    private CompositeConfiguration additionalProperties;
    private List<String> windowFiles = new ArrayList<String>();
    MolecularAssembly[] topologies;
    MolecularAssembly ma;

    public void setProperties(CompositeConfiguration additionalProps) {
        this.additionalProperties = additionalProps;
    }

    public SortArc() {
    }

    public SortArc(FFXBinding binding) {
        super(binding);
    }

    public SortArc(String[] args) {
        super(args);
    }

    public SortArc run() {
        int j;
        int i;
        if (!this.init()) {
            return this;
        }
        int numTopologies = this.topologyOptions.getNumberOfTopologies(this.filenames);
        int threadsPerTopology = this.topologyOptions.getThreadsPerTopology(numTopologies);
        this.topologies = new MolecularAssembly[numTopologies];
        this.alchemicalOptions.setAlchemicalProperties();
        this.topologyOptions.setAlchemicalProperties(numTopologies);
        this.files = new String[numTopologies];
        for (i = 0; i < numTopologies; ++i) {
            this.files[i] = this.filenames.get(i);
        }
        if (this.nWindows != -1) {
            for (i = 0; i < this.nWindows; ++i) {
                for (int j2 = 0; j2 < numTopologies; ++j2) {
                    String fullPathToFile = FilenameUtils.getFullPath((String)this.files[j2]);
                    String directoryFullPath = fullPathToFile.replace(this.files[j2], "") + i;
                    this.windowFiles.add(directoryFullPath + File.separator + i);
                }
            }
            this.lambdaValues = new double[this.nWindows];
            this.temperatureValues = new double[this.nWindows];
            for (i = 0; i < this.nWindows; ++i) {
                if (this.sortTemp) {
                    this.temperatureValues[i] = this.lowTemperature * Math.exp(this.exponent * (double)i);
                    continue;
                }
                this.lambdaValues[i] = this.alchemicalOptions.getInitialLambda(this.nWindows, i, false);
            }
        }
        if (this.filenames == null) {
            return this;
        }
        String[][] archiveFullPaths = new String[this.nWindows][numTopologies];
        File file = new File(this.files[0]);
        String directoryPath = file.getAbsoluteFile().getParent() + File.separator;
        String[][] archiveNewPath = new String[this.nWindows][numTopologies];
        File[][] saveFile = new File[this.nWindows][numTopologies];
        File[][] arcFiles = new File[this.nWindows][numTopologies];
        for (j = 0; j < numTopologies; ++j) {
            String archiveName = FilenameUtils.getBaseName((String)this.files[j]) + ".arc";
            for (int i2 = 0; i2 < this.nWindows; ++i2) {
                File arcFile;
                archiveFullPaths[i2][j] = directoryPath + i2 + File.separator + archiveName;
                arcFiles[i2][j] = arcFile = new File(archiveFullPaths[i2][j]);
                archiveNewPath[i2][j] = directoryPath + i2 + File.separator + FilenameUtils.getBaseName((String)this.files[j]) + "_E" + i2 + ".arc";
                saveFile[i2][j] = new File(archiveNewPath[i2][j]);
            }
        }
        this.openers = new XYZFilter[numTopologies];
        this.writers = new XYZFilter[this.nWindows][numTopologies];
        for (j = 0; j < numTopologies; ++j) {
            this.ma = this.filenames.get(j).contains(".pdb") ? this.alchemicalOptions.openFile((PotentialsFunctions)this.algorithmFunctions, this.topologyOptions, threadsPerTopology, archiveFullPaths[0][j], j) : this.alchemicalOptions.openFile((PotentialsFunctions)this.algorithmFunctions, this.topologyOptions, threadsPerTopology, this.filenames.get(j), j);
            this.topologies[j] = this.ma;
            this.openers[j] = this.algorithmFunctions.getFilter();
            for (int i3 = 0; i3 < this.nWindows; ++i3) {
                File arc = saveFile[i3][j];
                this.writers[i3][j] = new XYZFilter(arc, this.topologies[j], this.topologies[j].getForceField(), this.additionalProperties);
            }
        }
        double tolerance = this.sortTemp ? 0.01 : 1.0E-4;
        for (int j3 = 0; j3 < numTopologies; ++j3) {
            for (int i4 = 0; i4 < this.nWindows; ++i4) {
                logger.info(String.format(" Initializing %d topologies for each end", numTopologies));
                this.openers[j3].setFile(arcFiles[i4][j3]);
                this.topologies[j3].setFile(arcFiles[i4][j3]);
                logger.info("Set file to:" + arcFiles[i4][j3].toString());
                int snapshots = this.openers[j3].countNumModels();
                logger.info(String.valueOf(snapshots));
                block10: for (int n = 0; n < snapshots; ++n) {
                    boolean resetPosition = n == 0;
                    this.openers[j3].readNext(resetPosition, false);
                    String remarkLine = this.openers[j3].getRemarkLines()[0];
                    double lambda = 0.0;
                    double temp = 0.0;
                    if (remarkLine.contains(" Lambda: ")) {
                        String[] tokens = remarkLine.split(" +");
                        for (int p = 0; p < tokens.length; ++p) {
                            if (tokens[p].startsWith("Lambda")) {
                                lambda = Double.parseDouble(tokens[p + 1]);
                            }
                            if (!tokens[p].startsWith("Temp")) continue;
                            temp = Double.parseDouble(tokens[p + 1]);
                        }
                    }
                    for (int k = 0; k < this.nWindows; ++k) {
                        double diff = this.sortTemp ? Math.abs(this.temperatureValues[k] - temp) : Math.abs(this.lambdaValues[k] - lambda);
                        if (!(diff < tolerance)) continue;
                        this.writers[k][j3].writeFile(saveFile[k][j3], true, new String[]{remarkLine});
                        this.topologies[j3].setFile(arcFiles[i4][j3]);
                        continue block10;
                    }
                }
            }
        }
        return this;
    }

    @Override
    public List<Potential> getPotentials() {
        return Collections.emptyList();
    }
}

