/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms.commands;

import ffx.algorithms.cli.AlgorithmsCommand;
import ffx.algorithms.cli.MinimizeOptions;
import ffx.crystal.Crystal;
import ffx.numerics.Potential;
import ffx.potential.ForceFieldEnergy;
import ffx.potential.cli.AtomSelectionOptions;
import ffx.potential.openmm.OpenMMEnergy;
import ffx.potential.parsers.PDBFilter;
import ffx.potential.parsers.SystemFilter;
import ffx.potential.parsers.XYZFilter;
import ffx.utilities.FFXBinding;
import ffx.utilities.FileUtils;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import picocli.CommandLine;

@CommandLine.Command(description={" Run OpenMM Accelerated L-BFGS minimization on a system."}, name="MinimizeOpenMM")
public class MinimizeOpenMM
extends AlgorithmsCommand {
    @CommandLine.Mixin
    private AtomSelectionOptions atomSelectionOptions;
    @CommandLine.Mixin
    private MinimizeOptions minimizeOptions;
    @CommandLine.Parameters(arity="1", paramLabel="file", description={"XYZ or PDB input file."})
    private String filename;
    private ForceFieldEnergy forceFieldEnergy;

    public MinimizeOpenMM() {
    }

    public MinimizeOpenMM(FFXBinding binding) {
        super(binding);
    }

    public MinimizeOpenMM(String[] args) {
        super(args);
    }

    public MinimizeOpenMM run() {
        if (!this.init()) {
            return this;
        }
        if (System.getProperty("platform") == null || System.getProperty("platform").isEmpty()) {
            System.setProperty("platform", "OMM");
        }
        this.activeAssembly = this.getActiveAssembly(this.filename);
        if (this.activeAssembly == null) {
            logger.info(this.helpString());
            return this;
        }
        this.filename = this.activeAssembly.getFile().getAbsolutePath();
        this.atomSelectionOptions.setActiveAtoms(this.activeAssembly);
        this.forceFieldEnergy = this.activeAssembly.getPotentialEnergy();
        switch (this.forceFieldEnergy.getPlatform()) {
            case OMM: 
            case OMM_CUDA: 
            case OMM_OPENCL: 
            case OMM_CPU: 
            case OMM_REF: {
                logger.fine(" Platform is appropriate for OpenMM Minimization.");
                break;
            }
            default: {
                logger.severe(String.format(" Platform %s is inappropriate for OpenMM minimization. Please explicitly specify an OpenMM platform.", this.forceFieldEnergy.getPlatform()));
            }
        }
        if (this.forceFieldEnergy instanceof OpenMMEnergy) {
            XYZFilter writeFilter;
            File saveFile;
            ffx.algorithms.optimize.MinimizeOpenMM minimizeOpenMM = new ffx.algorithms.optimize.MinimizeOpenMM(this.activeAssembly);
            minimizeOpenMM.minimize(this.minimizeOptions.getEps(), this.minimizeOptions.getIterations());
            if (!(this.baseDir != null && this.baseDir.exists() && this.baseDir.isDirectory() && this.baseDir.canWrite())) {
                this.baseDir = new File(FilenameUtils.getFullPath((String)this.filename));
            }
            String dirName = this.baseDir.toString() + File.separator;
            String name = FilenameUtils.getName((String)this.filename);
            String ext = FilenameUtils.getExtension((String)name);
            name = FilenameUtils.removeExtension((String)name);
            PDBFilter pdbFilter = null;
            XYZFilter xyzFilter = null;
            if (ext.toUpperCase().contains("XYZ")) {
                saveFile = new File(dirName + name + ".xyz");
                writeFilter = xyzFilter = new XYZFilter(saveFile, this.activeAssembly, this.activeAssembly.getForceField(), this.activeAssembly.getProperties());
                this.algorithmFunctions.saveAsXYZ(this.activeAssembly, saveFile);
            } else if (ext.toUpperCase().contains("ARC")) {
                saveFile = new File(dirName + name + ".arc");
                saveFile = this.algorithmFunctions.versionFile(saveFile);
                writeFilter = xyzFilter = new XYZFilter(saveFile, this.activeAssembly, this.activeAssembly.getForceField(), this.activeAssembly.getProperties());
                this.algorithmFunctions.saveAsXYZ(this.activeAssembly, saveFile);
            } else {
                saveFile = new File(dirName + name + ".pdb");
                saveFile = this.algorithmFunctions.versionFile(saveFile);
                pdbFilter = new PDBFilter(saveFile, this.activeAssembly, this.activeAssembly.getForceField(), this.activeAssembly.getProperties());
                writeFilter = pdbFilter;
                int numModels = this.algorithmFunctions.getFilter().countNumModels();
                if (numModels > 1) {
                    pdbFilter.setModelNumbering(0);
                }
                pdbFilter.writeFile(saveFile, true, false, false);
            }
            SystemFilter systemFilter = this.algorithmFunctions.getFilter();
            saveFile = this.activeAssembly.getFile();
            if (systemFilter instanceof XYZFilter || systemFilter instanceof PDBFilter) {
                while (systemFilter.readNext()) {
                    Crystal crystal = this.activeAssembly.getCrystal();
                    ForceFieldEnergy forceFieldEnergy = this.activeAssembly.getPotentialEnergy();
                    forceFieldEnergy.setCrystal(crystal);
                    if (systemFilter instanceof PDBFilter) {
                        FileUtils.append((File)saveFile, (String)"ENDMDL\n");
                        minimizeOpenMM.minimize(this.minimizeOptions.getEps(), this.minimizeOptions.getIterations());
                        pdbFilter.writeFile(saveFile, true, false, false);
                        continue;
                    }
                    if (!(systemFilter instanceof XYZFilter)) continue;
                    minimizeOpenMM.minimize(this.minimizeOptions.getEps(), this.minimizeOptions.getIterations());
                    writeFilter.writeFile(saveFile, true);
                }
                if (systemFilter instanceof PDBFilter) {
                    FileUtils.append((File)saveFile, (String)"END\n");
                }
            }
        } else {
            logger.severe(" Could not start OpenMM minimization.");
        }
        return this;
    }

    @Override
    public List<Potential> getPotentials() {
        List<Object> potentials = this.forceFieldEnergy == null ? Collections.emptyList() : Collections.singletonList(this.forceFieldEnergy);
        return potentials;
    }
}

