/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms.commands;

import edu.rit.pj.Comm;
import ffx.algorithms.cli.AlgorithmsCommand;
import ffx.algorithms.cli.BarostatOptions;
import ffx.algorithms.cli.DynamicsOptions;
import ffx.algorithms.cli.RepExOptions;
import ffx.algorithms.dynamics.MolecularDynamics;
import ffx.algorithms.dynamics.ReplicaExchange;
import ffx.crystal.CrystalPotential;
import ffx.numerics.Potential;
import ffx.potential.cli.AtomSelectionOptions;
import ffx.potential.cli.WriteoutOptions;
import ffx.utilities.FFXBinding;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import picocli.CommandLine;

@CommandLine.Command(description={" Run dynamics on a system."}, name="Dynamics")
public class Dynamics
extends AlgorithmsCommand {
    @CommandLine.Mixin
    private AtomSelectionOptions atomSelectionOptions;
    @CommandLine.Mixin
    private DynamicsOptions dynamicsOptions;
    @CommandLine.Mixin
    private BarostatOptions barostatOptions;
    @CommandLine.Mixin
    private WriteoutOptions writeOut;
    @CommandLine.Mixin
    private RepExOptions repEx;
    @CommandLine.Parameters(arity="1", paramLabel="file", description={"XYZ or PDB input file."})
    private String filename;
    public Potential potential = null;
    public MolecularDynamics molDyn = null;

    public MolecularDynamics getMolecularDynamics() {
        return this.molDyn;
    }

    public Potential getPotentialObject() {
        return this.potential;
    }

    public Dynamics() {
    }

    public Dynamics(FFXBinding binding) {
        super(binding);
    }

    public Dynamics(String[] args) {
        super(args);
    }

    public Dynamics run() {
        if (!this.init()) {
            return this;
        }
        this.dynamicsOptions.init();
        this.activeAssembly = this.getActiveAssembly(this.filename);
        if (this.activeAssembly == null) {
            logger.info(this.helpString());
            return this;
        }
        this.filename = this.activeAssembly.getFile().getAbsolutePath();
        this.atomSelectionOptions.setActiveAtoms(this.activeAssembly);
        this.potential = this.activeAssembly.getPotentialEnergy();
        double[] x = new double[this.potential.getNumberOfVariables()];
        this.potential.getCoordinates(x);
        this.potential.energy(x, true);
        if (this.barostatOptions.getPressure() > 0.0) {
            CrystalPotential crystalPotential = (CrystalPotential)this.potential;
            this.potential = this.barostatOptions.createBarostat(this.activeAssembly, crystalPotential);
        }
        Comm world = Comm.world();
        int size = world.size();
        if (!this.repEx.getRepEx() || size < 2) {
            logger.info("\n Running molecular dynamics on " + this.filename);
            File dyn = new File(FilenameUtils.removeExtension((String)this.filename) + ".dyn");
            if (!dyn.exists()) {
                dyn = null;
            }
            this.molDyn = this.dynamicsOptions.getDynamics(this.writeOut, this.potential, this.activeAssembly, this.algorithmListener);
            this.molDyn.dynamic(this.dynamicsOptions.getSteps(), this.dynamicsOptions.getDt(), this.dynamicsOptions.getReport(), this.dynamicsOptions.getWrite(), this.dynamicsOptions.getTemperature(), true, dyn);
        } else {
            String withRankName;
            File dyn;
            logger.info("\n Running replica exchange molecular dynamics on " + this.filename);
            int rank = size > 1 ? world.rank() : 0;
            logger.info("Rank:" + rank);
            File structureFile = new File(this.filename);
            String baseFilename = FilenameUtils.removeExtension((String)structureFile.getName());
            File rankDirectory = new File(structureFile.getParent() + File.separator + rank);
            if (!rankDirectory.exists()) {
                rankDirectory.mkdir();
            }
            if (!(dyn = new File((withRankName = rankDirectory.getPath() + File.separator + baseFilename) + ".dyn")).exists()) {
                dyn = null;
            }
            String newMolAssemblyFile = rankDirectory.getPath() + File.separator + structureFile.getName();
            logger.info("Set activeAssembly filename: " + newMolAssemblyFile);
            this.activeAssembly.setFile(new File(newMolAssemblyFile));
            this.molDyn = this.dynamicsOptions.getDynamics(this.writeOut, this.potential, this.activeAssembly, this.algorithmListener);
            ReplicaExchange replicaExchange = new ReplicaExchange(this.molDyn, this.algorithmListener, this.dynamicsOptions.getTemperature(), this.repEx.getExponent(), this.repEx.getMonteCarlo());
            long totalSteps = this.dynamicsOptions.getSteps();
            int nSteps = this.repEx.getReplicaSteps();
            int cycles = (int)(totalSteps / (long)nSteps);
            if (cycles <= 0) {
                cycles = 1;
            }
            replicaExchange.sample(cycles, nSteps, this.dynamicsOptions.getDt(), this.dynamicsOptions.getReport(), this.dynamicsOptions.getWrite());
        }
        return this;
    }

    @Override
    public List<Potential> getPotentials() {
        List<Potential> potentials = this.potential == null ? Collections.emptyList() : Collections.singletonList(this.potential);
        return potentials;
    }
}

