/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms.commands;

import ffx.algorithms.cli.AlgorithmsCommand;
import ffx.numerics.Potential;
import ffx.potential.Utilities;
import ffx.potential.parsers.BARFilter;
import ffx.utilities.FFXBinding;
import ffx.utilities.FFXCommand;
import ffx.utilities.FileUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import picocli.CommandLine;

@CommandLine.Command(description={"Performs analysis of Non-equilibrium work simulations."}, name="AnalyzeNEQ")
public class AnalyzeNEQ
extends AlgorithmsCommand {
    @CommandLine.Option(names={"--reFile", "--fileSelectionRegex"}, paramLabel="work.log", defaultValue="work.log", description={"Locate files that match a regular expression."})
    private String reFile;
    @CommandLine.Option(names={"--reSearch", "--fileSearchRegex"}, paramLabel="Boole", defaultValue="Boole", description={"Locate this regular expression in log files."})
    private String reSearch;
    @CommandLine.Option(names={"--bi", "--barIterations"}, paramLabel="100", defaultValue="100", description={"Maximum iterations for BAR calculation."})
    private int barIterations;
    @CommandLine.Parameters(arity="2", paramLabel="path", description={"Two paths to directories. The first to the forward work directory and second to the reverse work directory."})
    private List<String> directories = null;

    public AnalyzeNEQ() {
    }

    public AnalyzeNEQ(FFXBinding binding) {
        super(binding);
    }

    public AnalyzeNEQ(String[] args) {
        super(args);
    }

    public AnalyzeNEQ run() {
        if (!this.init()) {
            return this;
        }
        int recurse = 1;
        String forwardDir = this.directories.get(0);
        String reverseDir = this.directories.get(1);
        File fdir = new File(forwardDir);
        List ffiles = FileUtils.traverseFiles((File)fdir, (int)recurse, (String)this.reFile);
        double[] fworks = this.grabWorks(ffiles);
        File rdir = new File(reverseDir);
        List rfiles = FileUtils.traverseFiles((File)rdir, (int)recurse, (String)this.reFile);
        double[] rworks = this.grabWorks(rfiles);
        String outputName = FilenameUtils.getBaseName((String)fdir.getName()) + "-" + FilenameUtils.getBaseName((String)rdir.getName()) + ".bar";
        File barFile = new File(".", "this.xyz");
        double temp = 300.0;
        BARFilter barFilter = new BARFilter(barFile, new double[fworks.length], fworks, rworks, new double[rworks.length], new double[3], new double[3], temp, temp);
        barFilter.writeFile(outputName, false, false);
        ArrayList<Object> commandArgs = new ArrayList<Object>();
        commandArgs.add("--ns");
        commandArgs.add("2");
        commandArgs.add("--ni");
        commandArgs.add(Integer.toString(this.barIterations));
        commandArgs.add("--useTinker");
        commandArgs.add("--bf");
        commandArgs.add(outputName);
        FFXBinding binding = new FFXBinding();
        binding.setVariable("args", commandArgs);
        Class script = AnalyzeNEQ.getCommand((String)"BAR");
        try {
            FFXCommand command = (FFXCommand)script.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            command.setBinding(binding);
            command.run();
        }
        catch (Exception e) {
            logger.info(" Exception running BAR.");
            logger.info(e.toString());
            logger.info(Utilities.stackTraceToString((Throwable)e));
        }
        return this;
    }

    private double[] grabWorks(List<File> files) {
        Collections.sort(files);
        int numFiles = files.size();
        ArrayList<Double> works = new ArrayList<Double>();
        Pattern workRegEx = Pattern.compile(this.reSearch);
        for (int i = 0; i < numFiles; ++i) {
            File file = files.get(i);
            if (!file.exists()) {
                logger.info(String.format(" Ignoring file that does not exist: %s", file.getAbsolutePath()));
                continue;
            }
            String path = FilenameUtils.normalize((String)file.getAbsolutePath());
            try (BufferedReader reader = new BufferedReader(new FileReader(path));){
                String line;
                while ((line = reader.readLine()) != null) {
                    Matcher matcher = workRegEx.matcher(line);
                    if (!matcher.find()) continue;
                    String[] workSplit = line.trim().split("\\s+");
                    if (workSplit.length != 4 && workSplit.length != 5) {
                        logger.warning(String.format("%s line is NOT length four or five: \"%s\"", this.reSearch, line));
                        continue;
                    }
                    works.add(Double.parseDouble(workSplit[workSplit.length - 1]));
                }
                continue;
            }
            catch (IOException e) {
                System.err.println("Error reading file: " + e.getMessage());
            }
        }
        double[] result = new double[works.size()];
        for (int i = 0; i < works.size(); ++i) {
            result[i] = (Double)works.get(i);
        }
        return result;
    }

    @Override
    public List<Potential> getPotentials() {
        return Collections.emptyList();
    }
}

