/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms.cli;

import ffx.algorithms.AlgorithmListener;
import ffx.algorithms.cli.DynamicsOptions;
import ffx.algorithms.dynamics.MolecularDynamics;
import ffx.crystal.CrystalPotential;
import ffx.numerics.Potential;
import ffx.potential.MolecularAssembly;
import ffx.potential.bonded.LambdaInterface;
import ffx.potential.cli.WriteoutOptions;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import picocli.CommandLine;

public class ThermodynamicsOptions {
    private static final Logger logger = Logger.getLogger(ThermodynamicsOptions.class.getName());
    @CommandLine.ArgGroup(heading="%n Thermodynamics Options%n", validate=false)
    private final ThermodynamicsOptionGroup group = new ThermodynamicsOptionGroup();

    public ThermodynamicsAlgorithm getAlgorithm() {
        return ThermodynamicsAlgorithm.parse(this.group.thermoAlgoString);
    }

    public long getEquilSteps() {
        return this.group.equilibrationSteps;
    }

    public boolean getResetNumSteps() {
        return this.group.resetNumSteps;
    }

    public MolecularDynamics runFixedAlchemy(MolecularAssembly[] molecularAssemblies, CrystalPotential crystalPotential, DynamicsOptions dynamicsOptions, WriteoutOptions writeoutOptions, File dyn, AlgorithmListener algorithmListener) {
        dynamicsOptions.init();
        MolecularDynamics molDyn = dynamicsOptions.getDynamics(writeoutOptions, (Potential)crystalPotential, molecularAssemblies[0], algorithmListener);
        for (int i = 1; i < molecularAssemblies.length; ++i) {
            molDyn.addAssembly(molecularAssemblies[i]);
        }
        boolean initVelocities = true;
        long nSteps = dynamicsOptions.getSteps();
        molDyn.setRestartFrequency(dynamicsOptions.getCheckpoint());
        if (this.group.equilibrationSteps > 0L) {
            logger.info("\n Beginning Equilibration");
            this.runDynamics(molDyn, this.group.equilibrationSteps, dynamicsOptions, writeoutOptions, true, dyn);
            logger.info(" Beginning Fixed-Lambda Alchemical Sampling");
            initVelocities = false;
        } else {
            logger.info("\n Beginning Fixed-Lambda Alchemical Sampling Without Equilibration");
            if (!this.group.resetNumSteps) {
                initVelocities = true;
            }
        }
        if (nSteps > 0L) {
            this.runDynamics(molDyn, nSteps, dynamicsOptions, writeoutOptions, initVelocities, dyn);
        } else {
            logger.info(" No steps remaining for this process.");
        }
        return molDyn;
    }

    public MolecularDynamics runNEQ(MolecularAssembly[] molecularAssemblies, CrystalPotential crystalPotential, DynamicsOptions dynamicsOptions, WriteoutOptions writeoutOptions, File dyn, AlgorithmListener algorithmListener) {
        dynamicsOptions.init();
        MolecularDynamics molDyn = dynamicsOptions.getDynamics(writeoutOptions, (Potential)crystalPotential, molecularAssemblies[0], algorithmListener);
        for (int i = 1; i < molecularAssemblies.length; ++i) {
            molDyn.addAssembly(molecularAssemblies[i]);
        }
        boolean initVelocities = true;
        long nSteps = dynamicsOptions.getSteps();
        molDyn.setRestartFrequency(dynamicsOptions.getCheckpoint());
        if (this.group.equilibrationSteps > 0L) {
            double initialLambda = this.group.reverseNEQ ? 1.0 : 0.0;
            logger.info(String.format("\n Beginning Equilibration (at L=%5.3f)", initialLambda));
            LambdaInterface lambdaInterface = (LambdaInterface)crystalPotential;
            lambdaInterface.setLambda(initialLambda);
            this.runDynamics(molDyn, this.group.equilibrationSteps, dynamicsOptions, writeoutOptions, true, dyn);
            if (nSteps > 0L) {
                logger.info(" Beginning Non-Equilibrium Sampling");
            }
            initVelocities = false;
        } else if (nSteps > 0L) {
            logger.info("\n Beginning Non-Equilibrium Sampling Without Equilibration");
            if (!this.group.resetNumSteps) {
                initVelocities = true;
            }
        }
        if (nSteps > 0L) {
            molDyn.setNonEquilibriumLambda(true, this.group.nonEquilibriumSteps, this.group.reverseNEQ);
            this.runDynamics(molDyn, nSteps, dynamicsOptions, writeoutOptions, initVelocities, dyn);
        }
        return molDyn;
    }

    public long getEquilibrationSteps() {
        return this.group.equilibrationSteps;
    }

    private void runDynamics(MolecularDynamics molecularDynamics, long nSteps, DynamicsOptions dynamicsOptions, WriteoutOptions writeoutOptions, boolean initVelocities, File dyn) {
        molecularDynamics.dynamic(nSteps, dynamicsOptions.getDt(), dynamicsOptions.getReport(), dynamicsOptions.getWrite(), dynamicsOptions.getTemperature(), initVelocities, writeoutOptions.getFileType(), dynamicsOptions.getCheckpoint(), dyn);
    }

    public void setEquilibrationSteps(long equilibrationSteps) {
        this.group.equilibrationSteps = equilibrationSteps;
    }

    public boolean isResetNumSteps() {
        return this.group.resetNumSteps;
    }

    public void setResetNumSteps(boolean resetNumSteps) {
        this.group.resetNumSteps = resetNumSteps;
    }

    public String getThermoAlgoString() {
        return this.group.thermoAlgoString;
    }

    public void setThermoAlgoString(String thermoAlgoString) {
        this.group.thermoAlgoString = thermoAlgoString;
    }

    private static class ThermodynamicsOptionGroup {
        @CommandLine.Option(names={"-Q", "--equilibrate"}, paramLabel="1000", defaultValue="1000", description={"Number of equilibration steps before evaluation of thermodynamics."})
        private long equilibrationSteps = 1000L;
        @CommandLine.Option(names={"--nEQ", "--nonEquilibriumSteps"}, paramLabel="100", defaultValue="100", description={"Sets the number of non-equilibrium lambda steps."})
        private int nonEquilibriumSteps = 100;
        @CommandLine.Option(names={"--rNEQ", "--reverseNonEquilibrium"}, defaultValue="false", description={"Run non-equilibrium dynamics from L=1 to L=0."})
        private boolean reverseNEQ = false;
        @CommandLine.Option(names={"--rn", "--resetNumSteps"}, defaultValue="false", description={"Ignore prior steps logged in .lam or similar files."})
        private boolean resetNumSteps = false;
        @CommandLine.Option(names={"--tA", "--thermodynamicsAlgorithm"}, paramLabel="OST", defaultValue="OST", description={"Choice of thermodynamics algorithm [OST, FIXED, or NEQ]."})
        private String thermoAlgoString = "OST";

        private ThermodynamicsOptionGroup() {
        }
    }

    public static enum ThermodynamicsAlgorithm {
        OST("OST", "MC-OST", "MD-OST", "DEFAULT"),
        FIXED("FIXED", "BAR", "MBAR", "FEP", "WINDOWED"),
        NEQ("NEQ", "NON-EQUILIBRIUM");

        private final Set<String> aliases;

        private ThermodynamicsAlgorithm(String ... aliases) {
            TreeSet<String> names = new TreeSet<String>(Arrays.asList(aliases));
            names.add(this.name());
            this.aliases = Collections.unmodifiableSet(names);
        }

        public static ThermodynamicsAlgorithm parse(String name) throws IllegalArgumentException {
            String ucName = name.toUpperCase();
            for (ThermodynamicsAlgorithm thermodynamicsAlgorithm : ThermodynamicsAlgorithm.values()) {
                if (!thermodynamicsAlgorithm.aliases.contains(ucName)) continue;
                return thermodynamicsAlgorithm;
            }
            throw new IllegalArgumentException(String.format(" Could not parse %s as a ThermodynamicsAlgorithm", name));
        }
    }
}

