/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms.cli;

import ffx.algorithms.AlgorithmListener;
import ffx.algorithms.cli.DynamicsOptions;
import ffx.algorithms.optimize.anneal.AnnealingSchedule;
import ffx.algorithms.optimize.anneal.FlatEndAnnealSchedule;
import ffx.algorithms.optimize.anneal.SimulatedAnnealing;
import ffx.numerics.Potential;
import ffx.potential.MolecularAssembly;
import java.io.File;
import java.util.logging.Logger;
import picocli.CommandLine;

public class AnnealOptions {
    private static final Logger logger = Logger.getLogger(AnnealOptions.class.getName());
    @CommandLine.ArgGroup(heading="%n Simulated Annealing Options%n", validate=false)
    private final AnnealOptionGroup group = new AnnealOptionGroup();

    public int getWindows() {
        return this.group.windows;
    }

    public SimulatedAnnealing createAnnealer(DynamicsOptions dynamicsOptions, MolecularAssembly molecularAssembly, Potential potential, AlgorithmListener algorithmListener) {
        return this.createAnnealer(dynamicsOptions, molecularAssembly, potential, algorithmListener, null);
    }

    public SimulatedAnnealing createAnnealer(DynamicsOptions dynamicsOptions, MolecularAssembly molecularAssembly, Potential potential, AlgorithmListener algorithmListener, File dynFile) {
        long perWindowSteps;
        AnnealingSchedule schedule = this.getSchedule();
        double totNormLen = schedule.totalWindowLength();
        long totSteps = dynamicsOptions.getSteps();
        if ((double)totSteps > (double)(perWindowSteps = (long)((double)totSteps / totNormLen)) * totNormLen) {
            ++perWindowSteps;
        }
        long minWindowSteps = (long)((double)perWindowSteps * schedule.minWindowLength());
        long maxWindowSteps = (long)((double)perWindowSteps * schedule.maxWindowLength());
        int nWindows = schedule.getNumWindows();
        if (minWindowSteps == maxWindowSteps && minWindowSteps == perWindowSteps) {
            logger.info(String.format(" Each of %d simulated annealing windows will have %d steps each, for a total duration of %d time-steps", nWindows, perWindowSteps, perWindowSteps * (long)nWindows));
        } else {
            logger.info(String.format(" Each of %d simulated annealing windows will have %d-%d steps each, with a \"normal\" length of %d steps, for a total duration of %d time-steps", nWindows, minWindowSteps, maxWindowSteps, perWindowSteps, (int)((double)perWindowSteps * schedule.totalWindowLength())));
        }
        if (nWindows < 201) {
            StringBuilder sb = new StringBuilder("\n Simulated annealing windows [index,MD steps, temperature (K)]:\n [");
            for (int i = 0; i < nWindows; ++i) {
                double len = schedule.windowLength(i);
                double temp = schedule.getTemperature(i);
                sb.append(String.format("[%d,%d,%10.4g]", i + 1, (int)(len * (double)perWindowSteps), temp));
                if (i == nWindows - 1) {
                    sb.append("]\n");
                    continue;
                }
                if (i % 10 == 9) {
                    sb.append("\n");
                    continue;
                }
                sb.append(",");
            }
            logger.info(sb.toString());
        } else {
            logger.info(" Skipping printout of window lengths/temperatures (max printout at 200 windows)");
        }
        return new SimulatedAnnealing(molecularAssembly, potential, algorithmListener, dynamicsOptions.thermostat, dynamicsOptions.integrator, schedule, perWindowSteps, dynamicsOptions.getDt(), this.isReinitVelocities(), dynFile);
    }

    public AnnealingSchedule getSchedule() {
        SimulatedAnnealing.Schedules schedules = SimulatedAnnealing.Schedules.parse(this.getTemperString());
        AnnealingSchedule annealingSchedule = schedules.generate(this.getWindows(), this.getLow(), this.getUpper());
        if (this.getTemperBefore() > 0 || this.getTemperAfter() > 0) {
            annealingSchedule = new FlatEndAnnealSchedule(annealingSchedule, this.getLow(), this.getUpper(), this.getTemperBefore(), this.getTemperAfter());
        }
        return annealingSchedule;
    }

    public void setWindows(int windows) {
        this.group.windows = windows;
    }

    public double getLow() {
        return this.group.low;
    }

    public void setLow(double low) {
        this.group.low = low;
    }

    public double getUpper() {
        return this.group.upper;
    }

    public void setUpper(double upper) {
        this.group.upper = upper;
    }

    public boolean isReinitVelocities() {
        return this.group.reinitVelocities;
    }

    public void setReinitVelocities(boolean reinitVelocities) {
        this.group.reinitVelocities = reinitVelocities;
    }

    public String getTemperString() {
        return this.group.temperString;
    }

    public void setTemperString(String temperString) {
        this.group.temperString = temperString;
    }

    public int getTemperBefore() {
        return this.group.temperBefore;
    }

    public void setTemperBefore(int temperBefore) {
        this.group.temperBefore = temperBefore;
    }

    public int getTemperAfter() {
        return this.group.temperAfter;
    }

    public void setTemperAfter(int temperAfter) {
        this.group.temperAfter = temperAfter;
    }

    private static class AnnealOptionGroup {
        @CommandLine.Option(names={"-W", "--windows"}, paramLabel="10", defaultValue="10", description={"Number of annealing windows."})
        private int windows = 10;
        @CommandLine.Option(names={"--tl", "--temperatureLow"}, paramLabel="10.0", defaultValue="10.0", description={"Low temperature limit (Kelvin)."})
        private double low = 10.0;
        @CommandLine.Option(names={"--tu", "--temperatureUpper"}, paramLabel="1000.0", defaultValue="1000.0", description={"High temperature limit (Kelvin)."})
        private double upper = 1000.0;
        @CommandLine.Option(names={"--rv", "--reinitVelocities"}, paramLabel="false", defaultValue="false", description={"Re-initialize velocities before each round of annealing."})
        private boolean reinitVelocities = false;
        @CommandLine.Option(names={"--tmS", "--temperingSchedule"}, paramLabel="EXP", defaultValue="EXP", description={"Tempering schedule: choose between EXP (exponential) or LINEAR"})
        private String temperString = "EXP";
        @CommandLine.Option(names={"--tmB", "--temperingBefore"}, paramLabel="0", defaultValue="0", description={"Number of (annealing, not MD/MC) steps to remain at the high temperature"})
        private int temperBefore = 0;
        @CommandLine.Option(names={"--tmA", "--temperingAfter"}, paramLabel="0", defaultValue="0", description={"Number of (annealing, not MD/MC) steps to remain at the low temperature"})
        private int temperAfter = 0;

        private AnnealOptionGroup() {
        }
    }
}

