/*
 * Decompiled with CFR 0.152.
 */
package ffx.algorithms.thermodynamics;

import edu.rit.mp.Buf;
import edu.rit.mp.DoubleBuf;
import edu.rit.pj.Comm;
import ffx.algorithms.thermodynamics.OrthogonalSpaceTempering;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.math3.util.FastMath;

class SendAsynchronous
extends Thread {
    private static final Logger logger = Logger.getLogger(SendAsynchronous.class.getName());
    private final double[] sendCount;
    private final DoubleBuf sendCountBuf;
    private final double[] receiveCount;
    private final DoubleBuf receiveCountBuf;
    private final Comm world = Comm.world();
    private final int rank = this.world.rank();
    private final int numProc = this.world.size();
    private final OrthogonalSpaceTempering.Histogram histogram;

    SendAsynchronous(OrthogonalSpaceTempering.Histogram histogram) {
        this.histogram = histogram;
        this.sendCount = new double[4];
        this.sendCountBuf = DoubleBuf.buffer((double[])this.sendCount);
        this.receiveCount = new double[4];
        this.receiveCountBuf = DoubleBuf.buffer((double[])this.receiveCount);
    }

    @Override
    public void run() {
        block6: {
            while (true) {
                try {
                    this.histogram.world.receive(null, (Buf)this.receiveCountBuf);
                }
                catch (InterruptedIOException ioe) {
                    String message = " SendAsynchronous was interrupted at world.receive; future message passing may be in an error state.";
                    logger.log(Level.WARNING, message, ioe);
                    break block6;
                }
                catch (IOException e) {
                    String message = e.getMessage();
                    logger.log(Level.WARNING, message, e);
                }
                boolean terminateSignal = Arrays.stream(this.receiveCount).allMatch(Double::isNaN);
                if (terminateSignal) {
                    logger.fine(" Termination signal received -- finishing execution.");
                    break block6;
                }
                int countRank = (int)FastMath.round((double)this.receiveCount[0]);
                double lambda = this.receiveCount[1];
                double dUdL = this.receiveCount[2];
                double weight = this.receiveCount[3];
                if (this.histogram.getIndependentWalkers() && countRank != this.rank) continue;
                if (this.histogram.getResetStatistics() && lambda > this.histogram.getLambdaResetValue()) {
                    this.histogram.allocateRecursionKernel();
                    this.histogram.disableResetStatistics();
                    logger.info(String.format(" Cleared OST histogram (Lambda = %6.4f).", lambda));
                }
                this.histogram.addToRecursionKernelValue(lambda, dUdL, weight);
                if (this.isInterrupted()) break;
            }
            logger.log(Level.INFO, " SendAsynchronous was interrupted -- finishing execution.");
        }
    }

    public void send(double lambda, double dUdL, double temperingWeight) {
        this.sendCount[0] = this.rank;
        this.sendCount[1] = lambda;
        this.sendCount[2] = dUdL;
        this.sendCount[3] = temperingWeight;
        this.histogram.setLastReceivedLambda(lambda);
        this.histogram.setLastReceiveddUdL(dUdL);
        for (int i = 0; i < this.numProc; ++i) {
            try {
                this.world.send(i, (Buf)this.sendCountBuf);
                continue;
            }
            catch (Exception ex) {
                String message = " Asynchronous Multiwalker OST send failed.";
                logger.log(Level.SEVERE, message, ex);
            }
        }
    }
}

